/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.gui.TooltipAddera;
import crazypants.enderio.item.darksteel.IDarkSteelUpgrade;
import crazypants.util.ItemUtil;
import crazypants.util.Lang;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public abstract class AbstractUpgrade
implements IDarkSteelUpgrade {
    public static final String KEY_LEVEL_COST = "level_cost";
    private static final String KEY_UNLOC_NAME = "unlocalized_name";
    public static final String KEY_UPGRADE_PREFIX = "enderio.darksteel.upgrade.";
    private static final String KEY_UPGRADE_ITEM = "upgradeItem";
    protected final int levelCost;
    protected final String id;
    protected final String unlocName;
    protected ItemStack upgradeItem;

    protected AbstractUpgrade(String id, String unlocName, ItemStack upgradeItem, int levelCost) {
        this.id = KEY_UPGRADE_PREFIX + id;
        this.unlocName = unlocName;
        this.upgradeItem = upgradeItem;
        this.levelCost = levelCost;
    }

    public AbstractUpgrade(String id, NBTTagCompound tag) {
        this.id = KEY_UPGRADE_PREFIX + id;
        this.levelCost = tag.func_74762_e(KEY_LEVEL_COST);
        this.unlocName = tag.func_74779_i(KEY_UNLOC_NAME);
        if (tag.func_74764_b(KEY_UPGRADE_ITEM)) {
            this.upgradeItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag.func_74781_a(KEY_UPGRADE_ITEM)));
        }
    }

    @Override
    public boolean isUpgradeItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || this.getUpgradeItem() == null) {
            return false;
        }
        return stack.func_77969_a(this.getUpgradeItem()) && stack.field_77994_a == this.getUpgradeItem().field_77994_a;
    }

    @Override
    public ItemStack getUpgradeItem() {
        return this.upgradeItem;
    }

    @Override
    public String getUpgradeItemName() {
        return this.getUpgradeItem().func_82833_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        TooltipAddera.addCommonTooltipFromResources(list, this.getUnlocalizedName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(EnumChatFormatting.DARK_AQUA + Lang.localize(this.getUnlocalizedName() + ".name", false));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(EnumChatFormatting.DARK_AQUA + Lang.localize(this.getUnlocalizedName() + ".name", false));
        TooltipAddera.addDetailedTooltipFromResources(list, this.getUnlocalizedName());
    }

    @Override
    public int getLevelCost() {
        return this.levelCost;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocName;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.field_77990_d == null) {
            return false;
        }
        return stack.field_77990_d.func_74764_b(this.id);
    }

    @Override
    public void writeToItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound upgradeRoot = new NBTTagCompound();
        upgradeRoot.func_74768_a(KEY_LEVEL_COST, this.levelCost);
        upgradeRoot.func_74778_a(KEY_UNLOC_NAME, this.getUnlocalizedName());
        if (this.getUpgradeItem() != null) {
            NBTTagCompound itemRoot = new NBTTagCompound();
            this.getUpgradeItem().func_77955_b(itemRoot);
            upgradeRoot.func_74782_a(KEY_UPGRADE_ITEM, (NBTBase)itemRoot);
        }
        this.writeUpgradeToNBT(upgradeRoot);
        NBTTagCompound stackRoot = ItemUtil.getOrCreateNBT(stack);
        stackRoot.func_74782_a(this.id, (NBTBase)upgradeRoot);
        stack.func_77982_d(stackRoot);
    }

    public NBTTagCompound getUpgradeRoot(ItemStack stack) {
        if (!this.hasUpgrade(stack)) {
            return null;
        }
        return (NBTTagCompound)stack.field_77990_d.func_74781_a(this.id);
    }

    public abstract void writeUpgradeToNBT(NBTTagCompound var1);

    @Override
    public void removeFromItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.field_77990_d == null) {
            return;
        }
        stack.field_77990_d.func_82580_o(this.id);
    }
}

