/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import net.minecraftforge.fluids.FluidStack;

public class AbstractTankConduitNetwork<T extends AbstractTankConduit>
extends AbstractConduitNetwork<ILiquidConduit, T> {
    protected FluidStack liquidType;
    protected boolean fluidTypeLocked = false;

    protected AbstractTankConduitNetwork(Class<T> cl) {
        super(cl);
    }

    public FluidStack getFluidType() {
        return this.liquidType;
    }

    @Override
    public Class<ILiquidConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public void addConduit(T con) {
        super.addConduit(con);
        ((AbstractTankConduit)con).setFluidType(this.liquidType);
        if (((AbstractTankConduit)con).fluidTypeLocked && !this.fluidTypeLocked) {
            this.setFluidTypeLocked(true);
        }
    }

    public boolean setFluidType(FluidStack newType) {
        if (this.liquidType != null && this.liquidType.isFluidEqual(newType)) {
            return false;
        }
        if (newType != null) {
            this.liquidType = newType.copy();
            this.liquidType.amount = 0;
        } else {
            this.liquidType = null;
        }
        for (AbstractTankConduit conduit : this.conduits) {
            conduit.setFluidType(this.liquidType);
        }
        return true;
    }

    public void setFluidTypeLocked(boolean fluidTypeLocked) {
        if (this.fluidTypeLocked == fluidTypeLocked) {
            return;
        }
        this.fluidTypeLocked = fluidTypeLocked;
        for (AbstractTankConduit conduit : this.conduits) {
            conduit.setFluidTypeLocked(fluidTypeLocked);
        }
    }

    public boolean canAcceptLiquid(FluidStack acceptable) {
        return AbstractTankConduitNetwork.areFluidsCompatable(this.liquidType, acceptable);
    }

    public static boolean areFluidsCompatable(FluidStack a, FluidStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.isFluidEqual(b);
    }

    public int getTotalVolume() {
        int totalVolume = 0;
        for (AbstractTankConduit con : this.conduits) {
            totalVolume += con.getTank().getFluidAmount();
        }
        return totalVolume;
    }
}

