/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractTankConduit
extends AbstractLiquidConduit {
    protected ConduitTank tank = new ConduitTank(0);
    protected boolean stateDirty = false;
    protected long lastEmptyTick = 0L;
    protected int numEmptyEvents = 0;
    protected boolean fluidTypeLocked = false;
    private int lastLightValue;

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        AbstractTankConduitNetwork<? extends AbstractTankConduit> network = this.getTankNetwork();
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit((IBlockAccess)this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!this.canJoinNeighbour(n)) {
                        return false;
                    }
                    if (!(n instanceof AbstractTankConduit)) {
                        return false;
                    }
                    AbstractTankConduit neighbour = (AbstractTankConduit)n;
                    if (neighbour.getFluidType() == null || this.getFluidType() == null) {
                        FluidStack type = this.getFluidType();
                        type = type != null ? type : neighbour.getFluidType();
                        neighbour.setFluidTypeOnNetwork(neighbour, type);
                        this.setFluidTypeOnNetwork(this, type);
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    FluidStack curFluidType = null;
                    if (this.getTankNetwork() != null) {
                        curFluidType = this.getTankNetwork().getFluidType();
                    }
                    ConduitUtil.disconectConduits(this, connDir);
                    this.setFluidType(curFluidType);
                }
            }
            return true;
        }
        if (player.func_71045_bC().func_77973_b() == Items.field_151133_ar) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K) {
                long curTick = this.getBundle().getEntity().func_145831_w().func_82737_E();
                this.numEmptyEvents = curTick - this.lastEmptyTick < 20L ? ++this.numEmptyEvents : 1;
                this.lastEmptyTick = curTick;
                if (this.numEmptyEvents < 2) {
                    if (network.fluidTypeLocked) {
                        network.setFluidTypeLocked(false);
                        this.numEmptyEvents = 0;
                        player.func_146105_b((IChatComponent)new ChatComponentText(Lang.localize("itemLiquidConduit.unlockedType")));
                    }
                } else if (network != null) {
                    network.setFluidType(null);
                    this.numEmptyEvents = 0;
                }
            }
            return true;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.func_71045_bC());
        if (fluid != null) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && network != null && (network.getFluidType() == null || network.getTotalVolume() < 500 || LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), fluid))) {
                network.setFluidType(fluid);
                network.setFluidTypeLocked(true);
                player.func_146105_b((IChatComponent)new ChatComponentText(Lang.localize("itemLiquidConduit.lockedType") + " " + FluidRegistry.getFluidName((FluidStack)fluid)));
            }
            return true;
        }
        return false;
    }

    void setFluidTypeLocked(boolean fluidTypeLocked) {
        if (fluidTypeLocked == this.fluidTypeLocked) {
            return;
        }
        this.fluidTypeLocked = fluidTypeLocked;
        this.stateDirty = true;
    }

    private void setFluidTypeOnNetwork(AbstractTankConduit con, FluidStack type) {
        AbstractConduitNetwork<?, ?> n = con.getNetwork();
        if (n != null) {
            AbstractTankConduitNetwork network = (AbstractTankConduitNetwork)n;
            network.setFluidType(type);
        }
    }

    protected abstract boolean canJoinNeighbour(ILiquidConduit var1);

    public abstract AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork();

    public void setFluidType(FluidStack liquidType) {
        if (this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(liquidType)) {
            return;
        }
        if (liquidType != null) {
            liquidType = liquidType.copy();
        } else if (this.tank.getFluid() == null) {
            return;
        }
        this.tank.setLiquid(liquidType);
        this.stateDirty = true;
    }

    public ConduitTank getTank() {
        return this.tank;
    }

    public FluidStack getFluidType() {
        FluidStack result = null;
        if (this.getTankNetwork() != null) {
            result = this.getTankNetwork().getFluidType();
        }
        if (result == null) {
            result = this.tank.getFluid();
        }
        return result;
    }

    public boolean isFluidTypeLocked() {
        return this.fluidTypeLocked;
    }

    @Override
    public void updateEntity(World world) {
        int lightValue = this.getLightValue();
        if (this.lastLightValue != lightValue) {
            BlockCoord bc = this.getLocation();
            this.getBundle().getWorld().func_147463_c(EnumSkyBlock.Block, bc.x, bc.y, bc.z);
            this.lastLightValue = lightValue;
        }
        super.updateEntity(world);
    }

    @Override
    public int getLightValue() {
        FluidStack stack = this.getFluidType();
        return stack == null || stack.amount <= 0 ? 0 : stack.getFluid().getLuminosity(stack);
    }

    protected abstract void updateTank();

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.updateTank();
        if (nbtRoot.func_74764_b("tank")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot.func_74775_l("tank"));
            this.tank.setLiquid(liquid);
        } else {
            this.tank.setLiquid(null);
        }
        this.fluidTypeLocked = nbtRoot.func_74767_n("fluidLocked");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        FluidStack ft = this.getFluidType();
        if (ConduitUtil.isFluidValid(ft)) {
            this.updateTank();
            ft = ft.copy();
            ft.amount = this.tank.getFluidAmount();
            nbtRoot.func_74782_a("tank", (NBTBase)ft.writeToNBT(new NBTTagCompound()));
        }
        nbtRoot.func_74757_a("fluidLocked", this.fluidTypeLocked);
    }
}

