/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.preloader.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import tconstruct.preloader.TConstructLoaderContainer;

public class PropertyManager {
    public static final String propFileName = "TConPreloader.cfg";
    private static String[] vars = new String[]{"preloaderContainer_verboseLog", "asmInterfaceRepair_verboseLog"};
    public static boolean preloaderContainer_verboseLog = false;
    public static boolean asmInterfaceRepair_verboseLog = false;

    private PropertyManager() {
    }

    public static boolean getOrCreateProps() throws PropAccessException {
        File fp = new File("config/TConPreloader.cfg");
        Properties props = new Properties();
        if (fp.exists()) {
            try {
                TConstructLoaderContainer.logger.info("Found a properties file. Attempting load...");
                props.load(new FileInputStream(fp));
                for (String var : vars) {
                    if (props.containsKey(var)) continue;
                    throw new NullPointerException();
                }
                preloaderContainer_verboseLog = props.getProperty("preloaderContainer_verboseLog", "false").equalsIgnoreCase("true");
                asmInterfaceRepair_verboseLog = props.getProperty("asmInterfaceRepair_verboseLog", "false").equalsIgnoreCase("true");
                TConstructLoaderContainer.logger.info("Loaded properties successfully. Using specified settings.");
            }
            catch (IOException ex) {
                throw new PropAccessException();
            }
            catch (NullPointerException ex) {
                TConstructLoaderContainer.logger.warn("Preloader config structure has changed; attempting to recreate.");
                PropertyManager.attemptCreate(fp, props);
            }
        } else {
            TConstructLoaderContainer.logger.info("Preloader config not found. Attempting to make a new one.");
            PropertyManager.attemptCreate(fp, props);
        }
        return false;
    }

    private static void attemptCreate(File fp, Properties props) throws PropAccessException {
        try {
            if (fp.exists()) {
                fp.delete();
            }
            if (!fp.createNewFile()) {
                throw new PropAccessException();
            }
            TConstructLoaderContainer.logger.info("Creating new properties file, as none found...");
            props.setProperty("asmInterfaceRepair_verboseLog", "false");
            props.setProperty("preloaderContainer_verboseLog", "false");
            props.store(new FileOutputStream(fp), null);
            TConstructLoaderContainer.logger.info("Created properties file; using defaults this run.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new PropAccessException();
        }
    }

    public static class PropAccessException
    extends Exception {
    }
}

