/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import tconstruct.TConstruct;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.items.TravelWings;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.modifier.IModifyable;
import tconstruct.util.network.ArmourGuiSyncPacket;

public class TinkerArmorEvents {
    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (!event.entityLiving.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            return;
        }
        if (TConstruct.random.nextInt(200) == 0 && event.entityLiving instanceof IMob && event.source.field_76373_n.equals("player")) {
            ItemStack dropStack = new ItemStack(TinkerArmor.heartCanister, 1, 1);
            EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_145804_b = 10;
            event.drops.add(entityitem);
        }
        if (event.entityLiving instanceof IBossDisplayData) {
            String entityName = event.entityLiving.getClass().getSimpleName().toLowerCase();
            if (entityName.contains("entitynpc") || entityName.contains("entitycustomnpc")) {
                return;
            }
            int count = event.entityLiving instanceof EntityDragon ? 5 : 1;
            for (int i = 0; i < count; ++i) {
                ItemStack dropStack = new ItemStack(TinkerArmor.heartCanister, 1, 3);
                EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
                entityitem.field_145804_b = 10;
                event.drops.add(entityitem);
            }
        }
    }

    @SubscribeEvent
    public void armorMineSpeed(PlayerEvent.BreakSpeed event) {
        if (event.entityPlayer == null) {
            return;
        }
        ItemStack glove = TPlayerStats.get((EntityPlayer)event.entityPlayer).armor.func_70301_a(1);
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            glove = ArmorProxyClient.armorExtended.func_70301_a(1);
        }
        if (glove == null || !glove.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = glove.func_77978_p().func_74775_l(TinkerArmor.travelGlove.getBaseTagName());
        float mineSpeed = tags.func_74762_e("MiningSpeed");
        float modifier = 1.0f + mineSpeed / 1000.0f;
        float base = mineSpeed / 250.0f;
        event.newSpeed = (event.originalSpeed + base) * modifier;
    }

    @SubscribeEvent
    public void jumpHeight(LivingEvent.LivingJumpEvent event) {
        ItemStack stack = event.entityLiving.func_71124_b(2);
        if (stack != null && stack.func_77973_b() instanceof TravelWings) {
            event.entityLiving.field_70181_x += 0.2;
        }
    }

    @SubscribeEvent
    public void slimefall(LivingFallEvent event) {
        NBTTagCompound tag;
        int sole;
        ItemStack boots = event.entityLiving.func_71124_b(1);
        if (boots != null && boots.func_77973_b() instanceof IModifyable && (sole = (tag = boots.func_77978_p().func_74775_l(((IModifyable)boots.func_77973_b()).getBaseTagName())).func_74762_e("Slimy Soles")) > 0) {
            event.distance /= (float)(1 + sole);
            event.entityLiving.field_70143_R /= (float)(1 + sole);
        }
    }

    @SubscribeEvent
    public void perfectDodge(LivingAttackEvent event) {
        if (!event.source.func_76352_a()) {
            return;
        }
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack chest = player.func_82169_q(2);
        if (chest == null || !(chest.func_77973_b() instanceof IModifyable) || !chest.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = chest.func_77978_p().func_74775_l(((IModifyable)chest.func_77973_b()).getBaseTagName());
        int dodge = tags.func_74762_e("Perfect Dodge");
        if (dodge > TConstruct.random.nextInt(10)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            TPlayerStats stats = TPlayerStats.get((EntityPlayer)player);
            NBTTagCompound tag = new NBTTagCompound();
            stats.saveNBTData(tag);
            ArmourGuiSyncPacket syncPacket = new ArmourGuiSyncPacket(tag);
            TConstruct.packetPipeline.sendTo(syncPacket, player);
        }
    }
}

