/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tconstruct.TConstruct;
import tconstruct.armor.ArmorAbilities;
import tconstruct.armor.ArmorProxyCommon;
import tconstruct.armor.TinkerArmorEvents;
import tconstruct.armor.blocks.DryingRack;
import tconstruct.armor.items.ArmorBasic;
import tconstruct.armor.items.DiamondApple;
import tconstruct.armor.items.HeartCanister;
import tconstruct.armor.items.Jerky;
import tconstruct.armor.items.Knapsack;
import tconstruct.armor.items.TravelBelt;
import tconstruct.armor.items.TravelGear;
import tconstruct.armor.items.TravelGlove;
import tconstruct.armor.items.TravelWings;
import tconstruct.blocks.logic.DryingRackLogic;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.accessory.AccessoryCore;
import tconstruct.library.armor.ArmorPart;
import tconstruct.library.crafting.DryingRackRecipes;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.modifiers.accessory.GloveSpeed;
import tconstruct.modifiers.armor.AModBoolean;
import tconstruct.modifiers.armor.AModInteger;
import tconstruct.modifiers.armor.AModLeadBoots;
import tconstruct.modifiers.armor.ActiveTinkerArmor;
import tconstruct.modifiers.armor.TravelModDoubleJump;
import tconstruct.modifiers.armor.TravelModRepair;
import tconstruct.modifiers.tools.ModAttack;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;

@GameRegistry.ObjectHolder(value="TConstruct")
@Pulse(id="Tinkers' Armory", description="Modifyable armors, such as the traveller's gear.")
public class TinkerArmor {
    @SidedProxy(clientSide="tconstruct.armor.ArmorProxyClient", serverSide="tconstruct.armor.ArmorProxyCommon")
    public static ArmorProxyCommon proxy;
    public static Item diamondApple;
    public static Item jerky;
    public static Block dryingRack;
    public static Item knapsack;
    public static Item heartCanister;
    public static Item helmetWood;
    public static Item chestplateWood;
    public static Item leggingsWood;
    public static Item bootsWood;
    public static ItemArmor.ArmorMaterial materialWood;
    public static TravelGear travelGoggles;
    public static TravelGear travelWings;
    public static TravelGear travelVest;
    public static TravelGear travelBoots;
    public static AccessoryCore travelGlove;
    public static AccessoryCore travelBelt;
    public static ModAttack modAttackGlove;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new TinkerArmorEvents());
        FMLCommonHandler.instance().bus().register((Object)new ArmorAbilities());
        dryingRack = new DryingRack().func_149663_c("Armor.DryingRack");
        GameRegistry.registerBlock((Block)dryingRack, (String)"Armor.DryingRack");
        GameRegistry.registerTileEntity(DryingRackLogic.class, (String)"Armor.DryingRack");
        diamondApple = new DiamondApple().func_77655_b("tconstruct.apple.diamond");
        GameRegistry.registerItem((Item)diamondApple, (String)"diamondApple");
        boolean foodOverhaul = false;
        if (Loader.isModLoaded((String)"HungerOverhaul") || Loader.isModLoaded((String)"fc_food")) {
            foodOverhaul = true;
        }
        jerky = new Jerky(foodOverhaul).func_77655_b("tconstruct.jerky");
        GameRegistry.registerItem((Item)jerky, (String)"jerky");
        heartCanister = new HeartCanister().func_77655_b("tconstruct.canister");
        knapsack = new Knapsack().func_77655_b("tconstruct.storage");
        GameRegistry.registerItem((Item)heartCanister, (String)"heartCanister");
        GameRegistry.registerItem((Item)knapsack, (String)"knapsack");
        LiquidCasting basinCasting = TConstruct.getBasinCasting();
        materialWood = EnumHelper.addArmorMaterial((String)"WOOD", (int)2, (int[])new int[]{1, 2, 2, 1}, (int)3);
        helmetWood = new ArmorBasic(materialWood, 0, "wood").func_77655_b("tconstruct.helmetWood");
        chestplateWood = new ArmorBasic(materialWood, 1, "wood").func_77655_b("tconstruct.chestplateWood");
        leggingsWood = new ArmorBasic(materialWood, 2, "wood").func_77655_b("tconstruct.leggingsWood");
        bootsWood = new ArmorBasic(materialWood, 3, "wood").func_77655_b("tconstruct.bootsWood");
        GameRegistry.registerItem((Item)helmetWood, (String)"helmetWood");
        GameRegistry.registerItem((Item)chestplateWood, (String)"chestplateWood");
        GameRegistry.registerItem((Item)leggingsWood, (String)"leggingsWood");
        GameRegistry.registerItem((Item)bootsWood, (String)"bootsWood");
        TConstructRegistry.addItemStackToDirectory("diamondApple", new ItemStack(diamondApple, 1, 0));
        TConstructRegistry.addItemStackToDirectory("canisterEmpty", new ItemStack(heartCanister, 1, 0));
        TConstructRegistry.addItemStackToDirectory("miniRedHeart", new ItemStack(heartCanister, 1, 1));
        TConstructRegistry.addItemStackToDirectory("canisterRedHeart", new ItemStack(heartCanister, 1, 2));
        travelGoggles = (TravelGear)new TravelGear(ArmorPart.Head).func_77655_b("tconstruct.travelgoggles");
        travelVest = (TravelGear)new TravelGear(ArmorPart.Chest).func_77655_b("tconstruct.travelvest");
        travelWings = (TravelGear)new TravelWings().func_77655_b("tconstruct.travelwings");
        travelBoots = (TravelGear)new TravelGear(ArmorPart.Feet).func_77655_b("tconstruct.travelboots");
        travelGlove = (AccessoryCore)new TravelGlove().func_77655_b("tconstruct.travelgloves");
        travelBelt = (AccessoryCore)new TravelBelt().func_77655_b("tconstruct.travelbelt");
        GameRegistry.registerItem((Item)travelGoggles, (String)"travelGoggles");
        GameRegistry.registerItem((Item)travelVest, (String)"travelVest");
        GameRegistry.registerItem((Item)travelWings, (String)"travelWings");
        GameRegistry.registerItem((Item)travelBoots, (String)"travelBoots");
        GameRegistry.registerItem((Item)travelGlove, (String)"travelGlove");
        GameRegistry.registerItem((Item)travelBelt, (String)"travelBelt");
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        this.craftingTableRecipes();
        this.registerModifiers();
        TinkerArmor.addRecipesForDryingRack();
        TConstructRegistry.equipableTab.init(travelGoggles.getDefaultItem());
        proxy.initialize();
    }

    @Handler
    public void postInit(FMLPostInitializationEvent evt) {
        proxy.registerTickHandler();
    }

    private void craftingTableRecipes() {
        String[] helm = new String[]{"www", "w w"};
        String[] chest = new String[]{"w w", "www", "www"};
        String[] pants = new String[]{"www", "w w", "w w"};
        String[] shoes = new String[]{"w w", "w w"};
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(helmetWood, new Object[]{helm, Character.valueOf('w'), "logWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(chestplateWood, new Object[]{chest, Character.valueOf('w'), "logWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(leggingsWood, new Object[]{pants, Character.valueOf('w'), "logWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bootsWood, new Object[]{shoes, Character.valueOf('w'), "logWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(heartCanister, 1, 0), new Object[]{"##", "##", Character.valueOf('#'), "ingotAluminum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(heartCanister, 1, 0), new Object[]{"##", "##", Character.valueOf('#'), "ingotAluminium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(heartCanister, 1, 0), new Object[]{" # ", "#B#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(diamondApple), (Object[])new Object[]{" d ", "d#d", " d ", Character.valueOf('d'), new ItemStack(Items.field_151045_i), Character.valueOf('#'), new ItemStack(Items.field_151034_e)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(heartCanister, 1, 2), (Object[])new Object[]{new ItemStack(diamondApple), new ItemStack(TinkerTools.materials, 1, 8), new ItemStack(heartCanister, 1, 0), new ItemStack(heartCanister, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(heartCanister, 1, 1), (Object[])new Object[]{new ItemStack(heartCanister, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(heartCanister, 1, 4), (Object[])new Object[]{new ItemStack(heartCanister, 1, 2), new ItemStack(heartCanister, 1, 3), new ItemStack(Items.field_151153_ao, 1, 1)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(knapsack, 1, 0), new Object[]{"###", "rmr", "###", Character.valueOf('#'), new ItemStack(Items.field_151116_aA), Character.valueOf('r'), new ItemStack(TinkerTools.toughRod, 1, 2), Character.valueOf('m'), "ingotGold"}));
        ItemStack aluBrass = new ItemStack(TinkerTools.materials, 1, 14);
        GameRegistry.addRecipe((ItemStack)new ItemStack(knapsack, 1, 0), (Object[])new Object[]{"###", "rmr", "###", Character.valueOf('#'), new ItemStack(Items.field_151116_aA), Character.valueOf('r'), new ItemStack(TinkerTools.toughRod, 1, 2), Character.valueOf('m'), aluBrass});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(dryingRack, 1, 0), new Object[]{"bbb", Character.valueOf('b'), "slabWood"}));
        ItemStack leather = new ItemStack(Items.field_151116_aA);
        ItemStack glass = new ItemStack(Blocks.field_150359_w);
        ItemStack string = new ItemStack(Items.field_151007_F);
        GameRegistry.addShapedRecipe((ItemStack)travelGoggles.getDefaultItem(), (Object[])new Object[]{"# #", "q#q", "g g", Character.valueOf('#'), leather, Character.valueOf('q'), glass, Character.valueOf('g'), new ItemStack(Items.field_151043_k)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(travelWings.getDefaultItem(), new Object[]{"g g", "i#i", "i i", Character.valueOf('#'), Items.field_151079_bi, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), "ingotBronze"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(travelVest.getDefaultItem(), new Object[]{"#w#", "#i#", "#w#", Character.valueOf('#'), leather, Character.valueOf('i'), "ingotAluminum", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(travelBoots.getDefaultItem(), new Object[]{"#s#", "#i#", "#s#", Character.valueOf('#'), leather, Character.valueOf('s'), string, Character.valueOf('i'), "ingotAluminum"}));
        GameRegistry.addShapedRecipe((ItemStack)travelGlove.getDefaultItem(), (Object[])new Object[]{"  #", "###", " ##", Character.valueOf('#'), leather});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(travelBelt.getDefaultItem(), new Object[]{"###", "ici", "###", Character.valueOf('#'), leather, Character.valueOf('c'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('i'), "ingotAluminum"}));
    }

    protected static void addRecipesForDryingRack() {
        DryingRackRecipes.addDryingRecipe(Items.field_151082_bd, 6000, new ItemStack(jerky, 1, 0));
        DryingRackRecipes.addDryingRecipe(Items.field_151076_bf, 6000, new ItemStack(jerky, 1, 1));
        DryingRackRecipes.addDryingRecipe(Items.field_151147_al, 6000, new ItemStack(jerky, 1, 2));
        DryingRackRecipes.addDryingRecipe(Items.field_151115_aP, 6000, new ItemStack(jerky, 1, 4));
        DryingRackRecipes.addDryingRecipe(Items.field_151078_bh, 6000, new ItemStack(jerky, 1, 5));
        DryingRackRecipes.addDryingRecipe(new ItemStack(TinkerWorld.strangeFood, 1, 0), 6000, new ItemStack(jerky, 1, 6));
        DryingRackRecipes.addDryingRecipe(new ItemStack(TinkerWorld.strangeFood, 1, 1), 6000, new ItemStack(jerky, 1, 7));
    }

    private void registerModifiers() {
        ItemStack redstoneItem = new ItemStack(Items.field_151137_ax);
        ItemStack redstoneBlock = new ItemStack(Blocks.field_150451_bX);
        ModifyBuilder.registerModifier(new TravelModDoubleJump(EnumSet.of(ArmorPart.Legs, ArmorPart.Feet), new ItemStack[]{new ItemStack(Items.field_151073_bk), new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack((Block)Blocks.field_150331_J)}));
        ModifyBuilder.registerModifier(new TravelModDoubleJump(EnumSet.of(ArmorPart.Legs, ArmorPart.Feet), new ItemStack[]{new ItemStack(Items.field_151073_bk), new ItemStack(TinkerWorld.slimeGel, 1, 1), new ItemStack((Block)Blocks.field_150331_J)}));
        ModifyBuilder.registerModifier(new AModInteger(4, "Moss", EnumSet.of(ArmorPart.Legs, ArmorPart.Feet, ArmorPart.Chest, ArmorPart.Head), new ItemStack[]{new ItemStack(TinkerTools.materials, 1, 6)}, 3, "\u00a72", StatCollector.func_74838_a((String)"modifier.tool.moss")));
        ModifyBuilder.registerModifier(new TravelModRepair());
        TConstructRegistry.registerActiveArmorMod(new ActiveTinkerArmor());
        ModifyBuilder.registerModifier(new AModBoolean(0, "Night Vision", EnumSet.of(ArmorPart.Head), new ItemStack[]{new ItemStack(Items.field_151033_d), new ItemStack((Item)Items.field_151068_bn, 1, 8198), new ItemStack(Items.field_151150_bK)}, "\u00a78", "Night Vision"));
        ModifyBuilder.registerModifier(new AModInteger(0, "Perfect Dodge", EnumSet.of(ArmorPart.Chest), new ItemStack[]{new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151102_aT)}, 1, "\u00a7d", "Perfect Dodge"));
        ModifyBuilder.registerModifier(new AModBoolean(1, "Stealth", EnumSet.of(ArmorPart.Chest), new ItemStack[]{new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151061_bv), new ItemStack((Item)Items.field_151068_bn, 1, 8206), new ItemStack(Items.field_151150_bK)}, "\u00a78", "Stealth"));
        ItemStack feather = new ItemStack(Items.field_151008_G);
        ModifyBuilder.registerModifier(new AModInteger(1, "Feather Fall", EnumSet.of(ArmorPart.Legs), new ItemStack[]{new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack(Items.field_151079_bi), feather, feather, feather, feather, feather, feather}, 1, "\u00a7f", "Feather Fall"));
        ModifyBuilder.registerModifier(new AModInteger(1, "Feather Fall", EnumSet.of(ArmorPart.Legs), new ItemStack[]{new ItemStack(TinkerWorld.slimeGel, 1, 1), new ItemStack(Items.field_151079_bi), feather, feather, feather, feather, feather, feather}, 1, "\u00a7f", "Feather Fall"));
        ModifyBuilder.registerModifier(new AModBoolean(1, "WaterWalk", EnumSet.of(ArmorPart.Feet), new ItemStack[]{new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150392_bi)}, "\u00a79", "Water-Walking"));
        ModifyBuilder.registerModifier(new AModLeadBoots(new ItemStack[]{new ItemStack(Blocks.field_150339_S)}));
        ModifyBuilder.registerModifier(new AModInteger(3, "Slimy Soles", EnumSet.of(ArmorPart.Feet), new ItemStack[]{new ItemStack(TinkerWorld.slimePad, 1, 0), new ItemStack(TinkerWorld.slimePad, 1, 0)}, 1, "\u00a7a", "Slimy Soles"));
        ModifyBuilder.registerModifier(new GloveSpeed(1, new ItemStack[]{redstoneItem, redstoneBlock}, new int[]{1, 9}));
        modAttackGlove = new ModAttack("Quartz", 2, new ItemStack[]{new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE)}, new int[]{1, 4}, 50, 50, "Accessory");
    }
}

