/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.armor.ArmorProxyCommon;
import tconstruct.armor.ArmorTickHandler;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.gui.ArmorExtendedGui;
import tconstruct.armor.gui.KnapsackGui;
import tconstruct.armor.items.TravelGear;
import tconstruct.armor.model.BeltModel;
import tconstruct.armor.model.BootBump;
import tconstruct.armor.model.HiddenPlayerModel;
import tconstruct.armor.model.WingModel;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.KnapsackInventory;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.client.ArmorControls;
import tconstruct.client.tabs.InventoryTabArmorExtended;
import tconstruct.client.tabs.InventoryTabKnapsack;
import tconstruct.client.tabs.InventoryTabVanilla;
import tconstruct.client.tabs.TabRegistry;
import tconstruct.common.TProxyCommon;
import tconstruct.library.accessory.IAccessoryModel;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;

public class ArmorProxyClient
extends ArmorProxyCommon {
    public static WingModel wings = new WingModel();
    public static BootBump bootbump = new BootBump();
    public static HiddenPlayerModel glove = new HiddenPlayerModel(0.25f, 4);
    public static HiddenPlayerModel vest = new HiddenPlayerModel(0.25f, 1);
    public static BeltModel belt = new BeltModel();
    public static TPlayerStats playerStats = new TPlayerStats();
    public static KnapsackInventory knapsack = ArmorProxyClient.playerStats.knapsack;
    public static ArmorExtended armorExtended = ArmorProxyClient.playerStats.armor;
    public static ArmorControls controlInstance;
    Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation hearts;
    private static final ResourceLocation icons;
    Random rand = new Random();
    int updateCounter = 0;
    GameSettings gs;
    double zLevel;

    public ArmorProxyClient() {
        this.gs = Minecraft.func_71410_x().field_71474_y;
        this.zLevel = 0.0;
    }

    @Override
    public void preInit() {
        controlInstance = new ArmorControls();
        FMLCommonHandler.instance().bus().register((Object)controlInstance);
        MinecraftForge.EVENT_BUS.register((Object)controlInstance);
        MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
    }

    @Override
    public void initialize() {
        this.registerGuiHandler();
        this.registerKeys();
        this.registerManualIcons();
        this.registerManualRecipes();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerManualIcons() {
        MantleClientRegistry.registerManualIcon((String)"travelgoggles", (ItemStack)TinkerArmor.travelGoggles.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelvest", (ItemStack)TinkerArmor.travelVest.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelwings", (ItemStack)TinkerArmor.travelWings.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelboots", (ItemStack)TinkerArmor.travelBoots.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelbelt", (ItemStack)TinkerArmor.travelBelt.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelglove", (ItemStack)TinkerArmor.travelGlove.getDefaultItem());
    }

    private void registerManualRecipes() {
        ItemStack feather = new ItemStack(Items.field_151008_G);
        ItemStack redstone = new ItemStack(Items.field_151137_ax);
        ItemStack goggles = TinkerArmor.travelGoggles.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("nightvision", goggles.func_77946_l(), new ItemStack(Items.field_151033_d), new ItemStack((Item)Items.field_151068_bn, 1, 8198), new ItemStack(Items.field_151150_bK), null);
        ItemStack vest = TinkerArmor.travelVest.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("dodge", vest.func_77946_l(), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151102_aT), null);
        TConstructClientRegistry.registerManualModifier("stealth", vest.func_77946_l(), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151061_bv), new ItemStack((Item)Items.field_151068_bn, 1, 8206), new ItemStack(Items.field_151150_bK));
        ItemStack wings = TinkerArmor.travelWings.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("doublejumpwings", wings.func_77946_l(), new ItemStack(Items.field_151073_bk), new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack((Block)Blocks.field_150331_J), null);
        ItemStack[] recipe = new ItemStack[]{new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack(Items.field_151079_bi), feather, feather, feather, feather, feather, feather};
        ItemStack modWings = ModifyBuilder.instance.modifyItem(wings, recipe);
        MantleClientRegistry.registerManualLargeRecipe((String)"featherfall", (ItemStack)modWings.func_77946_l(), (ItemStack[])new ItemStack[]{feather, new ItemStack(TinkerWorld.slimeGel, 1, 0), feather, feather, wings.func_77946_l(), feather, feather, new ItemStack(Items.field_151079_bi), feather});
        ItemStack boots = TinkerArmor.travelBoots.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("doublejumpboots", boots.func_77946_l(), new ItemStack(Items.field_151073_bk), new ItemStack(TinkerWorld.slimeGel, 1, 1), new ItemStack((Block)Blocks.field_150331_J), null);
        TConstructClientRegistry.registerManualModifier("waterwalk", boots.func_77946_l(), new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150392_bi));
        TConstructClientRegistry.registerManualModifier("leadboots", boots.func_77946_l(), new ItemStack(Blocks.field_150339_S));
        TConstructClientRegistry.registerManualModifier("slimysoles", boots.func_77946_l(), new ItemStack(TinkerWorld.slimePad, 1, 0), new ItemStack(TinkerWorld.slimePad, 1, 0));
        ItemStack gloves = TinkerArmor.travelGlove.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("glovehaste", gloves.func_77946_l(), redstone, new ItemStack(Blocks.field_150451_bX));
        TConstructClientRegistry.registerManualModifier("gloveknuckles", gloves.func_77946_l(), new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE));
        ItemStack moss = new ItemStack(TinkerTools.materials, 1, 6);
        TConstructClientRegistry.registerManualModifier("mossgoggles", goggles.func_77946_l(), moss.func_77946_l());
        TConstructClientRegistry.registerManualModifier("mossvest", vest.func_77946_l(), moss.func_77946_l());
        TConstructClientRegistry.registerManualModifier("mosswings", wings.func_77946_l(), moss.func_77946_l());
        TConstructClientRegistry.registerManualModifier("mossboots", boots.func_77946_l(), moss.func_77946_l());
    }

    @Override
    protected void registerGuiHandler() {
        super.registerGuiHandler();
        TProxyCommon.registerClientGuiHandler(100, this);
        TProxyCommon.registerClientGuiHandler(101, this);
        TProxyCommon.registerClientGuiHandler(102, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 100) {
            GuiInventory inventory = new GuiInventory(player);
            return inventory;
        }
        if (ID == 101) {
            armorExtended.init((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return new ArmorExtendedGui(player.field_71071_by, armorExtended);
        }
        if (ID == 102) {
            knapsack.init((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return new KnapsackGui(player.field_71071_by, knapsack);
        }
        return null;
    }

    @Override
    public void registerTickHandler() {
        FMLCommonHandler.instance().bus().register((Object)new ArmorTickHandler());
    }

    @Override
    public void registerKeys() {
        controlInstance.registerKeys();
        TabRegistry.registerTab(new InventoryTabVanilla());
        TabRegistry.registerTab(new InventoryTabArmorExtended());
        TabRegistry.registerTab(new InventoryTabKnapsack());
    }

    @SubscribeEvent
    public void goggleZoom(FOVUpdateEvent event) {
        ItemStack helmet;
        if (ArmorControls.zoom && (helmet = event.entity.func_82169_q(3)) != null && helmet.func_77973_b() instanceof TravelGear) {
            event.newfov = 0.3f;
        }
    }

    @SubscribeEvent
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        if (Loader.isModLoaded((String)"rpghud")) {
            return;
        }
        if ((!Loader.isModLoaded((String)"tukmc_Vz") || Loader.isModLoaded((String)"borderlands")) && event.type == RenderGameOverlayEvent.ElementType.HEALTH) {
            boolean highlight;
            ++this.updateCounter;
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            int scaledWidth = scaledresolution.func_78326_a();
            int scaledHeight = scaledresolution.func_78328_b();
            int xBasePos = scaledWidth / 2 - 91;
            int yBasePos = scaledHeight - 39;
            boolean bl = highlight = this.mc.field_71439_g.field_70172_ad / 3 % 2 == 1;
            if (this.mc.field_71439_g.field_70172_ad < 10) {
                highlight = false;
            }
            IAttributeInstance attrMaxHealth = this.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a);
            int health = MathHelper.func_76123_f((float)this.mc.field_71439_g.func_110143_aJ());
            int healthLast = MathHelper.func_76123_f((float)this.mc.field_71439_g.field_70735_aL);
            float healthMax = (float)attrMaxHealth.func_111126_e();
            if (healthMax > 20.0f) {
                healthMax = 20.0f;
            }
            float absorb = this.mc.field_71439_g.func_110139_bj();
            int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            this.rand.setSeed(this.updateCounter * 312871);
            int left = scaledWidth / 2 - 91;
            int top = scaledHeight - GuiIngameForge.left_height;
            if (!GuiIngameForge.renderExperiance) {
                top += 7;
                yBasePos += 7;
            }
            int regen = -1;
            if (this.mc.field_71439_g.func_70644_a(Potion.field_76428_l)) {
                regen = this.updateCounter % 25;
            }
            int TOP = 9 * (this.mc.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
            int BACKGROUND = highlight ? 25 : 16;
            int MARGIN = 16;
            if (this.mc.field_71439_g.func_70644_a(Potion.field_76436_u)) {
                MARGIN += 36;
            } else if (this.mc.field_71439_g.func_70644_a(Potion.field_82731_v)) {
                MARGIN += 72;
            }
            float absorbRemaining = absorb;
            for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                boolean b0 = highlight;
                int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
                int x = left + i % 10 * 8;
                int y = top - row * rowHeight;
                if (health <= 4) {
                    y += this.rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                this.drawTexturedModalRect(x, y, BACKGROUND, TOP, 9, 9);
                if (highlight) {
                    if (i * 2 + 1 < healthLast) {
                        this.drawTexturedModalRect(x, y, MARGIN + 54, TOP, 9, 9);
                    } else if (i * 2 + 1 == healthLast) {
                        this.drawTexturedModalRect(x, y, MARGIN + 63, TOP, 9, 9);
                    }
                }
                if (absorbRemaining > 0.0f) {
                    if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                        this.drawTexturedModalRect(x, y, MARGIN + 153, TOP, 9, 9);
                    } else {
                        this.drawTexturedModalRect(x, y, MARGIN + 144, TOP, 9, 9);
                    }
                    absorbRemaining -= 2.0f;
                    continue;
                }
                if (i * 2 + 1 < health) {
                    this.drawTexturedModalRect(x, y, MARGIN + 36, TOP, 9, 9);
                    continue;
                }
                if (i * 2 + 1 != health) continue;
                this.drawTexturedModalRect(x, y, MARGIN + 45, TOP, 9, 9);
            }
            int potionOffset = 0;
            PotionEffect potion = this.mc.field_71439_g.func_70660_b(Potion.field_82731_v);
            if (potion != null) {
                potionOffset = 18;
            }
            if ((potion = this.mc.field_71439_g.func_70660_b(Potion.field_76436_u)) != null) {
                potionOffset = 9;
            }
            if (this.mc.field_71441_e.func_72912_H().func_76093_s()) {
                potionOffset += 27;
            }
            this.mc.func_110434_K().func_110577_a(hearts);
            int hp = MathHelper.func_76123_f((float)this.mc.field_71439_g.func_110143_aJ());
            for (int iter = 0; iter < hp / 20; ++iter) {
                int renderHearts = (hp - 20 * (iter + 1)) / 2;
                if (renderHearts > 10) {
                    renderHearts = 10;
                }
                for (int i = 0; i < renderHearts; ++i) {
                    int y = 0;
                    if (i == regen) {
                        y -= 2;
                    }
                    this.drawTexturedModalRect(xBasePos + 8 * i, yBasePos + y, 0 + 18 * iter, potionOffset, 9, 9);
                }
                if (hp % 2 != 1 || renderHearts >= 10) continue;
                this.drawTexturedModalRect(xBasePos + 8 * renderHearts, yBasePos, 9 + 18 * iter, potionOffset, 9, 9);
            }
            this.mc.func_110434_K().func_110577_a(icons);
            GuiIngameForge.left_height += 10;
            if (absorb > 0.0f) {
                GuiIngameForge.left_height += 10;
            }
            event.setCanceled(true);
            if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.gs.field_74320_O != 0) {
                event.setCanceled(true);
            }
        }
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void adjustArmor(RenderPlayerEvent.SetArmorModel event) {
        switch (event.slot) {
            case 1: {
                ArmorProxyClient.vest.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.vest.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.vest.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.vest.field_78117_n = event.renderer.field_77109_a.field_78117_n;
            }
            case 2: {
                ArmorProxyClient.wings.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.wings.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.wings.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.wings.field_78117_n = event.renderer.field_77109_a.field_78117_n;
                ArmorProxyClient.glove.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.glove.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.glove.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.glove.field_78117_n = event.renderer.field_77109_a.field_78117_n;
                ArmorProxyClient.glove.field_78119_l = event.renderer.field_77109_a.field_78119_l;
                ArmorProxyClient.glove.field_78120_m = event.renderer.field_77109_a.field_78120_m;
                ArmorProxyClient.belt.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.belt.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.belt.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.belt.field_78117_n = event.renderer.field_77109_a.field_78117_n;
                this.renderArmorExtras(event);
                break;
            }
            case 3: {
                ArmorProxyClient.bootbump.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.bootbump.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.bootbump.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.bootbump.field_78117_n = event.renderer.field_77109_a.field_78117_n;
            }
        }
    }

    void renderArmorExtras(RenderPlayerEvent.SetArmorModel event) {
        ModelBiped model;
        Item item;
        float pitch;
        float partialTick = event.partialRenderTick;
        EntityPlayer player = event.entityPlayer;
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        float posX = (float)(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTick);
        float posY = (float)(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTick);
        float posZ = (float)(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTick);
        float yawOffset = this.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialTick);
        float yawRotation = this.interpolateRotation(player.field_70758_at, player.field_70759_as, partialTick);
        float zeropointsixtwofive = 0.0625f;
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.field_70154_o;
            yawOffset = this.interpolateRotation(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, partialTick);
            pitch = MathHelper.func_76142_g((float)(yawRotation - yawOffset));
            if (pitch < -85.0f) {
                pitch = -85.0f;
            }
            if (pitch >= 85.0f) {
                pitch = 85.0f;
            }
            yawOffset = yawRotation - pitch;
            if (pitch * pitch > 2500.0f) {
                yawOffset += pitch * 0.2f;
            }
        }
        pitch = this.handleRotationFloat((EntityLivingBase)player, partialTick);
        float bodyRotation = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTick;
        float limbSwing = player.field_70722_aY + (player.field_70721_aZ - player.field_70722_aY) * partialTick;
        float limbSwingMod = player.field_70754_ba - player.field_70721_aZ * (1.0f - partialTick);
        ArmorExtended armor = armorExtended;
        if (armor != null && armor.inventory[1] != null) {
            item = armor.inventory[1].func_77973_b();
            model = item.getArmorModel((EntityLivingBase)player, armor.inventory[1], 4);
            if (item instanceof IAccessoryModel) {
                this.mc.func_110434_K().func_110577_a(((IAccessoryModel)item).getWearbleTexture((Entity)player, armor.inventory[1], 1));
                model.func_78086_a((EntityLivingBase)player, limbSwingMod, limbSwing, partialTick);
                model.func_78088_a((Entity)player, limbSwingMod, limbSwing, pitch, yawRotation - yawOffset, bodyRotation, 0.0625f);
            }
        }
        if (armor != null && armor.inventory[3] != null) {
            item = armor.inventory[3].func_77973_b();
            model = item.getArmorModel((EntityLivingBase)player, armor.inventory[3], 5);
            if (item instanceof IAccessoryModel) {
                this.mc.func_110434_K().func_110577_a(((IAccessoryModel)item).getWearbleTexture((Entity)player, armor.inventory[1], 1));
                model.func_78086_a((EntityLivingBase)player, limbSwingMod, limbSwing, partialTick);
                model.func_78088_a((Entity)player, limbSwingMod, limbSwing, pitch, yawRotation - yawOffset, bodyRotation, 0.0625f);
            }
        }
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    protected float handleRotationFloat(EntityLivingBase par1EntityLivingBase, float par2) {
        return (float)par1EntityLivingBase.field_70173_aa + par2;
    }

    @Override
    public void updatePlayerStats(TPlayerStats stats) {
        playerStats.copyFrom(stats, false);
        armorExtended = stats.armor;
        knapsack = stats.knapsack;
    }

    static {
        hearts = new ResourceLocation("tinker", "textures/gui/newhearts.png");
        icons = new ResourceLocation("textures/gui/icons.png");
    }
}

