/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.gui.container;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.gui.container.ContainerInventoryItem;
import cofh.lib.gui.slot.SlotLocked;
import cofh.thermalfoundation.gui.container.InventoryLexiconStudy;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.util.LexiconManager;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerLexiconStudy
extends ContainerInventoryItem {
    public static final byte ORE_PREV = 0;
    public static final byte ORE_NEXT = 1;
    public static final byte SET_PREFERRED = 2;
    public static final byte CLEAR_PREFERRED = 3;
    public static final byte SELECT_ORE = 4;
    ArrayList<ItemStack> oreList;
    int oreSelection = -1;
    boolean hasPreferredStack = false;
    boolean syncClient = false;
    EntityPlayer player;
    public InventoryLexiconStudy lexiconInv = new InventoryLexiconStudy();

    public ContainerLexiconStudy(ItemStack itemStack, InventoryPlayer inventoryPlayer) {
        super(itemStack, inventoryPlayer);
        this.player = inventoryPlayer.field_70458_d;
        this.func_75146_a((Slot)new SlotLocked((IInventory)this.lexiconInv, 0, 95, 33));
    }

    public boolean canSetPreferred() {
        ItemStack itemStack = this.lexiconInv.func_70301_a(0);
        if (itemStack == null) {
            return false;
        }
        return LexiconManager.validOre(itemStack);
    }

    public boolean doSetPreferred() {
        if (!this.canSetPreferred()) {
            return false;
        }
        LexiconManager.setPreferredStack(this.player, this.lexiconInv.func_70301_a(0));
        this.hasPreferredStack = true;
        this.syncClient = true;
        return true;
    }

    public boolean doClearPreferred() {
        if (!this.hasPreferredOre()) {
            return false;
        }
        LexiconManager.clearPreferredStack(this.player, this.lexiconInv.func_70301_a(0));
        this.hasPreferredStack = false;
        this.syncClient = true;
        return true;
    }

    public boolean hasMultipleOres() {
        return this.oreList != null && this.oreList.size() > 1;
    }

    public boolean hasPreferredOre() {
        return this.hasPreferredStack;
    }

    public void prevOre() {
        this.oreSelection += this.oreList.size() - 1;
        this.oreSelection %= this.oreList.size();
        this.lexiconInv.func_70299_a(0, this.oreList.get(this.oreSelection));
    }

    public void nextOre() {
        ++this.oreSelection;
        this.oreSelection %= this.oreList.size();
        this.lexiconInv.func_70299_a(0, this.oreList.get(this.oreSelection));
    }

    public void onSelectionChanged(String string) {
        this.oreList = OreDictionaryArbiter.getOres((String)string);
        System.out.println(string);
        this.oreSelection = 0;
        this.lexiconInv.func_70299_a(0, this.oreList.get(this.oreSelection));
        PacketTFBase.sendLexiconStudySelectPacketToServer(4, string);
    }

    public void handlePacket(PacketTFBase packetTFBase) {
        switch (packetTFBase.getByte()) {
            case 0: {
                this.prevOre();
                return;
            }
            case 1: {
                this.nextOre();
                return;
            }
            case 2: {
                this.doSetPreferred();
                return;
            }
            case 3: {
                this.doClearPreferred();
                return;
            }
            case 4: {
                String string = packetTFBase.getString();
                this.oreList = OreDictionaryArbiter.getOres((String)string);
                if (LexiconManager.hasPreferredStack(this.player, string)) {
                    ItemStack itemStack = LexiconManager.getPreferredStack(this.player, string);
                    this.lexiconInv.func_70299_a(0, itemStack);
                    for (int i = 0; i < this.oreList.size(); ++i) {
                        if (this.oreList.get(i) != itemStack) continue;
                        this.oreSelection = i;
                        break;
                    }
                    this.hasPreferredStack = true;
                } else {
                    this.lexiconInv.func_70299_a(0, (ItemStack)OreDictionaryArbiter.getOres((String)string).get(0));
                    this.oreSelection = 0;
                    this.hasPreferredStack = false;
                }
                this.syncClient = true;
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < ((Container)this).field_75149_d.size(); ++i) {
            if (!this.syncClient) continue;
            ((ICrafting)((Container)this).field_75149_d.get(i)).func_71112_a((Container)this, 0, this.hasPreferredStack ? 1 : 0);
            this.syncClient = false;
        }
    }

    public void func_75137_b(int n, int n2) {
        this.hasPreferredStack = n2 == 1;
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int n) {
        return null;
    }
}

