/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.LogHelper;
import com.rwtema.denseores.TextureOre;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockDenseOre
extends BlockOre {
    public DenseOre[] entry = new DenseOre[16];
    public Block[] baseBlocks = new Block[16];
    public boolean[] valid = new boolean[16];
    public boolean init = false;
    public IIcon[] icons = new IIcon[16];

    protected boolean func_149700_E() {
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (this.isValid(meta)) {
            return this.getBlock(meta).canHarvestBlock(player, this.getEntry((int)meta).metadata);
        }
        return super.canHarvestBlock(player, meta);
    }

    public int getHarvestLevel(int meta) {
        if (this.isValid(meta)) {
            return this.getBlock(meta).getHarvestLevel(this.getEntry((int)meta).metadata);
        }
        return super.getHarvestLevel(meta);
    }

    public String getHarvestTool(int meta) {
        if (this.isValid(meta)) {
            return this.getBlock(meta).getHarvestTool(this.getEntry((int)meta).metadata);
        }
        return super.getHarvestTool(meta);
    }

    public static Block getBlock(String name) {
        return (Block)GameData.getBlockRegistry().func_82594_a(name);
    }

    public static Block getBlock(DenseOre ore) {
        return ore != null ? BlockDenseOre.getBlock(ore.baseBlock) : null;
    }

    public void init() {
        this.init = true;
        for (int i = 0; i < 16; ++i) {
            this.baseBlocks[i] = BlockDenseOre.getBlock(this.entry[i]);
            this.valid[i] = this.baseBlocks[i] != null && this.baseBlocks[i] != Blocks.field_150350_a;
        }
    }

    public Block getBlock(int id) {
        if (!this.init) {
            this.init();
        }
        return this.baseBlocks[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int id = world.func_72805_g(x, y, z);
        if (!this.isValid(id)) {
            return;
        }
        try {
            world.func_147465_d(x, y, z, this.getBlock(id), this.getMetadata(id), 0);
            for (int i = 0; i < 1 + rand.nextInt(3); ++i) {
                this.getBlock(id).func_149734_b(world, x, y, z, rand);
            }
        }
        catch (Exception e) {
            world.func_147465_d(x, y, z, (Block)this, id, 0);
            throw new RuntimeException(e);
        }
        world.func_147465_d(x, y, z, (Block)this, id, 0);
    }

    public boolean isValid(int id) {
        if (!this.init) {
            this.init();
        }
        if (id < 0 || id >= 16) {
            return false;
        }
        return this.valid[id];
    }

    public void setEntry(int id, DenseOre ore) {
        this.entry[id] = ore;
    }

    public DenseOre getEntry(int id) {
        return this.entry[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 16; ++i) {
            if (!this.isValid(i)) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.isValid(meta)) {
            return this.icons[meta];
        }
        return this.getNullOverride((World)Minecraft.func_71410_x().field_71441_e).func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (this.isValid(meta)) {
            return this.icons[meta];
        }
        return this.getNullOverride((World)Minecraft.func_71410_x().field_71441_e, x, z).func_149691_a(0, 0);
    }

    public Block getNullOverride(World world, int x, int z) {
        if (world == null) {
            return Blocks.field_150348_b;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome == BiomeGenBase.field_76778_j) {
            return Blocks.field_150424_aL;
        }
        if (biome == BiomeGenBase.field_76779_k) {
            return Blocks.field_150377_bs;
        }
        return this.getNullOverride(world);
    }

    public Block getNullOverride(World world) {
        if (world.field_73011_w == null) {
            return Blocks.field_150348_b;
        }
        if (world.field_73011_w.field_76574_g == -1) {
            return Blocks.field_150424_aL;
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return Blocks.field_150377_bs;
        }
        return Blocks.field_150348_b;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureMap map = (TextureMap)register;
            for (int i = 0; i < 16; ++i) {
                if (!this.isValid(i)) continue;
                String name = TextureOre.getDerivedName(this.entry[i].texture);
                TextureAtlasSprite texture = map.getTextureExtry(name);
                if (texture == null) {
                    texture = new TextureOre(this.entry[i]);
                    map.setTextureEntry(name, texture);
                }
                this.icons[i] = map.getTextureExtry(name);
            }
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float p, int fortune) {
        Block base;
        if (world.field_72995_K) {
            return;
        }
        ArrayList<ItemStack> items = this.getDrops(world, x, y, z, metadata, fortune);
        p = ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)metadata, (int)fortune, (float)p, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        if (p == 0.0f) {
            return;
        }
        if (this.isValid(metadata) && (base = this.getBlock(metadata)) != null) {
            int m = this.getMetadata(metadata);
            p = ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)base, (int)x, (int)y, (int)z, (int)m, (int)fortune, (float)p, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        }
        if (p == 0.0f) {
            return;
        }
        for (ItemStack item : items) {
            if (p != 1.0f && !(world.field_73012_v.nextFloat() <= p)) continue;
            this.func_149642_a(world, x, y, z, item);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.isValid(metadata)) {
            Block base = this.getBlock(metadata);
            if (base == null) {
                return ret;
            }
            int m = this.getMetadata(metadata);
            for (int j = 0; j < 3; ++j) {
                ret.addAll(base.getDrops(world, x, y, z, m, fortune));
            }
        } else {
            return this.getNullOverride(world, x, z).getDrops(world, x, y, z, 0, fortune);
        }
        return ret;
    }

    private int getMetadata(int id) {
        return this.entry[id].metadata;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (this.isValid(metadata)) {
            Block base = this.getBlock(metadata);
            float t = this.field_149782_v;
            world.func_72921_c(x, y, z, this.getMetadata(metadata), 0);
            try {
                t = base.func_149712_f(world, x, y, z);
            }
            catch (Exception e) {
                LogHelper.error("The ore block " + this.entry[metadata].id + "(" + this.entry[metadata].baseBlock + ")" + " has thrown an error while getting the hardness value. It is likely not compatible with Dense ores", e);
                world.func_72921_c(x, y, z, this.getMetadata(metadata), 0);
                throw new RuntimeException(e);
            }
            world.func_72921_c(x, y, z, metadata, 0);
            return t;
        }
        return this.field_149782_v;
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        int result = 0;
        if (this.isValid(metadata)) {
            Block base = this.getBlock(metadata);
            if (base == null) {
                return 0;
            }
            int m = this.getMetadata(metadata);
            for (int i = 0; i < 3; ++i) {
                result += base.getExpDrop(world, m, fortune);
            }
        } else {
            return this.getNullOverride((World)world).getExpDrop(world, 0, fortune);
        }
        return result;
    }
}

