/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.inventory.LiquidInventory;
import com.rwtema.extrautils.item.ItemNodeUpgrade;
import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.InvCrafting;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeInventory;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.ItemBuffer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTransferNodeInventory
extends TileEntityTransferNode
implements INodeInventory,
ISidedInventory {
    private static final int[] contents = new int[]{0};
    private static final int[] nullcontents = new int[0];
    private static InvCrafting crafting = new InvCrafting(3, 3);
    private static ForgeDirection[] orthY = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UNKNOWN};
    private static ForgeDirection[] orthX = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UNKNOWN};
    private boolean hasCStoneGen = false;
    private int genCStoneCounter = 0;
    private long checkTimer = 0L;
    private boolean craft;
    private IRecipe cachedRecipe;
    private int prevStack;
    private boolean delay;
    private boolean isDirty;

    public TileEntityTransferNodeInventory() {
        super("Inv", new ItemBuffer());
        this.pr = 1.0f;
        this.pg = 0.0f;
        this.pb = 0.0f;
        this.craft = false;
        this.cachedRecipe = null;
        this.prevStack = 0;
        this.delay = false;
        this.isDirty = false;
    }

    public TileEntityTransferNodeInventory(String txt, INodeBuffer buffer) {
        super(txt, buffer);
        this.pr = 1.0f;
        this.pg = 0.0f;
        this.pb = 0.0f;
        this.craft = false;
        this.cachedRecipe = null;
        this.prevStack = 0;
        this.delay = false;
        this.isDirty = false;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting inv, World world) {
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe;
        }
        return null;
    }

    private static int getFirstExtractableItemStackSlot(IInventory inv, int side) {
        for (int i : XUHelper.getInventorySideSlots(inv, side)) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0 || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102008_b(i, item, side)) continue;
            if (item.func_77973_b().hasContainerItem(item)) {
                ItemStack t = item.func_77973_b().getContainerItem(item);
                for (int j : XUHelper.getInventorySideSlots(inv, side)) {
                    if ((j == i || inv.func_70301_a(j) != null) && (j != i || item.field_77994_a != 1) || !inv.func_94041_b(j, t) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102007_a(i, t, side)) continue;
                    return i;
                }
                continue;
            }
            return i;
        }
        return -1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
    }

    @Override
    public void processBuffer() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.coolDown > 0) {
                this.coolDown -= this.stepCoolDown;
            }
            if (this.checkRedstone()) {
                return;
            }
            this.startDelayMarkDirty();
            while (this.coolDown <= 0) {
                this.coolDown += baseMaxCoolDown;
                if (this.handleInventories()) {
                    this.advPipeSearch();
                }
                this.loadbuffer();
            }
            this.finishMarkDirty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadbuffer() {
        int j;
        IInventory inv;
        block15: {
            int[] aint;
            ISidedInventory invs;
            int dir;
            block14: {
                block12: {
                    block13: {
                        if (this.buffer.getBuffer() != null && ((ItemStack)this.buffer.getBuffer()).field_77994_a >= ((ItemStack)this.buffer.getBuffer()).func_77976_d()) {
                            return;
                        }
                        dir = this.func_145832_p() % 6;
                        inv = TNHelper.getInventory(this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[dir], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir]));
                        if (inv == null) break block12;
                        if (!(inv instanceof ISidedInventory)) break block13;
                        dir = Facing.field_71588_a[dir];
                        invs = (ISidedInventory)inv;
                        aint = invs.func_94128_d(dir);
                        break block14;
                    }
                    j = inv.func_70302_i_();
                    break block15;
                }
                if (this.upgradeNo(2) <= 0) return;
                if (this.genCobble()) {
                    return;
                }
                if (this.doCraft()) {
                    return;
                }
                this.suckItems();
                return;
            }
            for (int i = 0; i < aint.length && (this.buffer.getBuffer() == null || ((ItemStack)this.buffer.getBuffer()).field_77994_a < ((ItemStack)this.buffer.getBuffer()).func_77976_d()); ++i) {
                ItemStack itemstack = invs.func_70301_a(aint[i]);
                if (itemstack == null || itemstack.field_77994_a <= 0 || this.buffer.getBuffer() != null && !XUHelper.canItemsStack((ItemStack)this.buffer.getBuffer(), itemstack, false, true) || !invs.func_102008_b(aint[i], itemstack, dir)) continue;
                ItemStack itemstack1 = itemstack.func_77946_l();
                ItemStack itemstack2 = this.upgradeNo(3) == 0 ? XUHelper.invInsert((IInventory)this, invs.func_70298_a(aint[i], 1), -1) : XUHelper.invInsert((IInventory)this, invs.func_70301_a(aint[i]), -1);
                if (this.upgradeNo(3) == 0) {
                    if (itemstack2 == null) {
                        inv.func_70296_d();
                        return;
                    }
                    inv.func_70299_a(aint[i], itemstack1);
                } else {
                    inv.func_70299_a(aint[i], itemstack2);
                }
                inv.func_70296_d();
            }
            return;
        }
        for (int k = 0; k < j && (this.buffer.getBuffer() == null || ((ItemStack)this.buffer.getBuffer()).field_77994_a < ((ItemStack)this.buffer.getBuffer()).func_77976_d()); ++k) {
            ItemStack itemstack = inv.func_70301_a(k);
            if (itemstack == null || this.buffer.getBuffer() != null && !XUHelper.canItemsStack((ItemStack)this.buffer.getBuffer(), itemstack, false, true)) continue;
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = this.upgradeNo(3) == 0 ? XUHelper.invInsert((IInventory)this, inv.func_70298_a(k, 1), -1) : XUHelper.invInsert((IInventory)this, inv.func_70301_a(k), -1);
            if (itemstack2 != null && itemstack2.field_77994_a == 0) {
                itemstack2 = null;
            }
            if (this.upgradeNo(3) == 0) {
                if (itemstack2 == null) {
                    inv.func_70296_d();
                    return;
                }
                inv.func_70299_a(k, itemstack1);
            } else {
                inv.func_70299_a(k, itemstack2);
            }
            inv.func_70296_d();
        }
    }

    public void startDelayMarkDirty() {
        if (this.delay) {
            throw new RuntimeException("Tile Entity to be marked for delayMarkDirty is already marked as such");
        }
        this.delay = true;
        this.isDirty = false;
    }

    public void finishMarkDirty() {
        if (this.isDirty) {
            super.func_70296_d();
        }
        this.delay = false;
        this.isDirty = false;
    }

    @Override
    public void func_70296_d() {
        if (!this.delay) {
            this.isDirty = false;
            super.func_70296_d();
        } else {
            this.isDirty = true;
        }
    }

    private void suckItems() {
        if (this.buffer.getBuffer() == null || ((ItemStack)this.buffer.getBuffer()).field_77994_a < ((ItemStack)this.buffer.getBuffer()).func_77976_d()) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() % 6));
            double r = Math.log(this.upgradeNo(2)) / Math.log(2.0);
            if (r > 3.5) {
                r = 3.5;
            }
            for (Object o : this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72317_d((double)dir.offsetX * (1.0 + r), (double)dir.offsetY * (1.0 + r), (double)dir.offsetZ * (1.0 + r)).func_72314_b(r, r, r))) {
                EntityItem item = (EntityItem)o;
                ItemStack itemstack = item.func_92059_d();
                if (!item.func_70089_S() || itemstack == null || this.buffer.getBuffer() != null && !XUHelper.canItemsStack((ItemStack)this.buffer.getBuffer(), itemstack, false, true)) continue;
                ItemStack itemstack1 = itemstack.func_77946_l();
                if (this.upgradeNo(3) == 0) {
                    itemstack1.field_77994_a = 1;
                }
                int n = itemstack1.field_77994_a;
                if ((itemstack1 = XUHelper.invInsert((IInventory)this, itemstack1, -1)) != null) {
                    n -= itemstack1.field_77994_a;
                }
                if (n <= 0) continue;
                itemstack.field_77994_a -= n;
                if (itemstack.field_77994_a > 0) {
                    item.func_92058_a(itemstack);
                } else {
                    item.func_70106_y();
                }
                if (this.upgradeNo(3) != 0) continue;
                return;
            }
        }
    }

    private boolean doCraft() {
        if (this.buffer.getBuffer() == null || ((ItemStack)this.buffer.getBuffer()).field_77994_a < ((ItemStack)this.buffer.getBuffer()).func_77976_d()) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() % 6));
            boolean bl = this.craft = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) == Blocks.field_150462_ai;
            if (!this.craft) {
                return false;
            }
            ForgeDirection dirX = orthX[dir.ordinal()];
            ForgeDirection dirY = orthY[dir.ordinal()];
            int[] slots = new int[9];
            IInventory[] inventories = new IInventory[9];
            boolean isEmpty = true;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    boolean b;
                    TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX * 2 + dirX.offsetX * dx + dirY.offsetX * dy, this.field_145848_d + dir.offsetY * 2 + dirX.offsetY * dx + dirY.offsetY * dy, this.field_145849_e + dir.offsetZ * 2 + dirX.offsetZ * dx + dirY.offsetZ * dy);
                    int j = dx + 1 + 3 * (-dy + 1);
                    boolean a = tile instanceof IInventory;
                    boolean bl2 = b = a || tile instanceof IFluidHandler;
                    if (b) {
                        int i;
                        inventories[j] = a ? (IInventory)tile : new LiquidInventory((IFluidHandler)tile, dir.getOpposite());
                        slots[j] = i = TileEntityTransferNodeInventory.getFirstExtractableItemStackSlot(inventories[j], dir.getOpposite().ordinal());
                        if (i >= 0) {
                            ItemStack item = inventories[j].func_70301_a(i);
                            crafting.func_70299_a(j, item.func_77946_l());
                            isEmpty = false;
                            continue;
                        }
                        crafting.func_70299_a(j, null);
                        continue;
                    }
                    inventories[j] = null;
                    crafting.func_70299_a(j, null);
                }
            }
            if (isEmpty) {
                return true;
            }
            if (this.cachedRecipe == null || !this.cachedRecipe.func_77569_a((InventoryCrafting)crafting, this.field_145850_b) || this.cachedRecipe.func_77572_b((InventoryCrafting)crafting) == null) {
                int p = crafting.hashCode();
                if (p == this.prevStack && this.prevStack != 0 && this.rand.nextInt(10) > 0) {
                    return true;
                }
                this.prevStack = p;
                IRecipe r = TileEntityTransferNodeInventory.findMatchingRecipe(crafting, this.field_145850_b);
                if (r == null || r.func_77572_b((InventoryCrafting)crafting) == null || !this.func_94041_b(0, r.func_77572_b((InventoryCrafting)crafting))) {
                    return true;
                }
                this.cachedRecipe = r;
            }
            ItemStack stack = this.cachedRecipe.func_77572_b((InventoryCrafting)crafting);
            this.prevStack = 0;
            if (this.buffer.getBuffer() != null) {
                if (!XUHelper.canItemsStack(stack, (ItemStack)this.buffer.getBuffer(), false, true, false)) {
                    return true;
                }
                if (stack.field_77994_a + ((ItemStack)this.buffer.getBuffer()).field_77994_a > stack.func_77976_d()) {
                    return true;
                }
            }
            if (!this.func_94041_b(0, stack)) {
                return true;
            }
            ItemStack[] items = new ItemStack[9];
            for (int i = 0; i < 9; ++i) {
                ItemStack t;
                if (inventories[i] == null || slots[i] < 0) continue;
                ItemStack c = inventories[i].func_70301_a(slots[i]);
                boolean flag = false;
                if (c == null || !XUHelper.canItemsStack(crafting.func_70301_a(i), c)) {
                    flag = true;
                }
                if (!flag) {
                    items[i] = inventories[i].func_70298_a(slots[i], 1);
                    if (items[i] != null && items[i].field_77994_a != 1) {
                        flag = true;
                    }
                }
                if (flag) {
                    for (int j = 0; j <= i; ++j) {
                        if (items[j] == null || inventories[j] == null) continue;
                        items[j] = XUHelper.invInsert(inventories[j], items[j], dir.getOpposite().ordinal());
                        if (items[j] == null) continue;
                        XUHelper.dropItem(this.func_145831_w(), this.getNodeX(), this.getNodeY(), this.getNodeZ(), items[j]);
                    }
                    return true;
                }
                if (c == null || !c.func_77973_b().hasContainerItem(c) || (t = c.func_77973_b().getContainerItem(c)) == null || t.func_77984_f() && t.func_77960_j() > t.func_77958_k()) continue;
                XUHelper.invInsert(inventories[i], t, dir.getOpposite().ordinal());
            }
            XUHelper.invInsert((IInventory)this, stack, -1);
        }
        return true;
    }

    private boolean genCobble() {
        if (ExtraUtils.disableCobblegen) {
            return false;
        }
        if (this.buffer.getBuffer() == null || ((ItemStack)this.buffer.getBuffer()).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e) && ((ItemStack)this.buffer.getBuffer()).field_77994_a < 64) {
            int dir = this.func_145832_p() % 6;
            this.genCStoneCounter = (this.genCStoneCounter + 1) % (1 + this.upgradeNo(0));
            if (this.genCStoneCounter != 0) {
                return false;
            }
            if (this.field_145850_b.func_82737_E() - this.checkTimer > 100L) {
                this.checkTimer = this.field_145850_b.func_82737_E();
                this.hasCStoneGen = false;
                if (this.field_145850_b.func_147439_a(this.field_145851_c + Facing.field_71586_b[dir], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir]) == Blocks.field_150347_e) {
                    boolean hasLava = false;
                    boolean hasWater = false;
                    for (int i = 2; !(hasWater && hasLava || i >= 6); hasWater |= this.field_145850_b.func_147439_a(this.field_145851_c + Facing.field_71586_b[dir] + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir] + Facing.field_71585_d[i]).func_149688_o() == Material.field_151586_h, hasLava |= this.field_145850_b.func_147439_a(this.field_145851_c + Facing.field_71586_b[dir] + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir] + Facing.field_71585_d[i]).func_149688_o() == Material.field_151587_i, ++i) {
                    }
                    if (hasWater && hasLava) {
                        this.hasCStoneGen = true;
                    }
                }
            }
            if (this.hasCStoneGen) {
                if (this.buffer.getBuffer() == null) {
                    this.buffer.setBuffer(new ItemStack(Blocks.field_150347_e, this.upgradeNo(2)));
                } else {
                    ((ItemStack)this.buffer.getBuffer()).field_77994_a += 1 + this.upgradeNo(2);
                    if (((ItemStack)this.buffer.getBuffer()).field_77994_a > 64) {
                        ((ItemStack)this.buffer.getBuffer()).field_77994_a = 64;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return (ItemStack)this.buffer.getBuffer();
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i != 0) {
            return null;
        }
        if (this.buffer.getBuffer() != null) {
            if (((ItemStack)this.buffer.getBuffer()).field_77994_a <= j) {
                ItemStack itemstack = (ItemStack)this.buffer.getBuffer();
                this.buffer.setBuffer(null);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.buffer.getBuffer()).func_77979_a(j);
            if (((ItemStack)this.buffer.getBuffer()).field_77994_a == 0) {
                this.buffer.setBuffer(null);
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (i != 0) {
            return null;
        }
        if (this.buffer.getBuffer() != null) {
            ItemStack itemstack = (ItemStack)this.buffer.getBuffer();
            this.buffer.setBuffer(null);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.buffer.setBuffer(itemstack);
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "gui.transferNode";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        for (int j = 0; j < this.upgrades.func_70302_i_(); ++j) {
            ItemStack upgrade = this.upgrades.func_70301_a(j);
            if (upgrade == null || !ItemNodeUpgrade.isFilter(upgrade) || ItemNodeUpgrade.matchesFilterItem(itemstack, upgrade)) continue;
            return false;
        }
        return true;
    }

    public int[] func_94128_d(int j) {
        if (j < 0 || j >= 6 || j == this.func_145832_p() % 6) {
            return contents;
        }
        return nullcontents;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return (j < 0 || j >= 6 || j == this.func_145832_p() % 6) && this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public TileEntityTransferNodeInventory getNode() {
        return this;
    }

    @Override
    public BoxModel getModel(ForgeDirection dir) {
        BoxModel boxes = new BoxModel();
        float w = 0.125f;
        boxes.add(new Box(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.0625f, 0.9375f).rotateToSide(dir).setTextureSides(dir.ordinal(), BlockTransferNode.nodeBase));
        boxes.add(new Box(0.1875f, 0.0625f, 0.1875f, 0.8125f, 0.25f, 0.8125f).rotateToSide(dir));
        boxes.add(new Box(0.3125f, 0.25f, 0.3125f, 0.6875f, 0.375f, 0.6875f).rotateToSide(dir));
        boxes.add(new Box(0.375f, 0.25f, 0.375f, 0.625f, 0.375f, 0.625f).rotateToSide(dir).setTexture(BlockTransferNode.nodeBase).setAllSideInvisible().setSideInvisible(dir.getOpposite().ordinal(), false));
        return boxes;
    }
}

