/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.modintegration;

import com.google.common.base.Throwables;
import com.rwtema.extrautils.modintegration.TConTextureResourcePackBase;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;

public class TConTextureResourcePackBedrockium
extends TConTextureResourcePackBase {
    static BufferedImage bedrockImage = null;

    public TConTextureResourcePackBedrockium(String name) {
        super(name);
    }

    @Override
    public BufferedImage modifyImage(BufferedImage image) {
        BufferedImage bedrockImage = TConTextureResourcePackBedrockium.getBedrockImage();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int c = image.getRGB(x, y);
                if (c == 0 || rgb.getAlpha(c) < 16) {
                    image.setRGB(x, y, 0);
                    continue;
                }
                float b = (float)this.brightness(c) / 255.0f;
                int dx = x * bedrockImage.getWidth() / image.getWidth();
                int dy = y * bedrockImage.getHeight() / image.getHeight();
                int col = bedrockImage.getRGB(dx, dy);
                image.setRGB(x, y, rgb.getAlpha(c) << 24 | (int)((float)rgb.getRed(col) * b) << 16 | (int)((float)rgb.getGreen(col) * b) << 8 | (int)((float)rgb.getBlue(col) * b));
            }
        }
        return image;
    }

    public static BufferedImage getBedrockImage() {
        if (bedrockImage == null) {
            ResourceLocation bedrockLocation = new ResourceLocation("minecraft", "textures/blocks/bedrock.png");
            try {
                DefaultResourcePack mcDefaultResourcePack = (DefaultResourcePack)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"field_110450_ap", "mcDefaultResourcePack"});
                InputStream inputStream = mcDefaultResourcePack.func_110590_a(bedrockLocation);
                List t = Minecraft.func_71410_x().func_110438_M().func_110613_c();
                for (ResourcePackRepository.Entry entry2 : t) {
                    IResourcePack resourcePack = entry2.func_110514_c();
                    if (!resourcePack.func_110589_b(bedrockLocation)) continue;
                    inputStream = resourcePack.func_110590_a(bedrockLocation);
                }
                bedrockImage = ImageIO.read(inputStream);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return bedrockImage;
    }

    @Override
    public void func_110549_a(IResourceManager p_110549_1_) {
        super.func_110549_a(p_110549_1_);
        bedrockImage = null;
    }
}

