/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib.enderwizards.sandstone.init.ContentHandler;
import lib.enderwizards.sandstone.mod.ModIntegration;
import lib.enderwizards.sandstone.mod.ModRegistry;
import lib.enderwizards.sandstone.mod.SandstoneMod;
import lib.enderwizards.sandstone.server.CommandDebug;
import lib.enderwizards.sandstone.util.LanguageHelper;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="libsandstone", name="libsandstone", version="1.0.0")
public class Sandstone {
    private static Map<String, List<ModIntegration>> modIntegrations = new HashMap<String, List<ModIntegration>>();
    public static Logger LOGGER = LogManager.getLogger((String)"libSandstone");

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        LanguageHelper.globals.put("colors.black", "\u00a70");
        LanguageHelper.globals.put("colors.navy", "\u00a71");
        LanguageHelper.globals.put("colors.green", "\u00a72");
        LanguageHelper.globals.put("colors.blue", "\u00a73");
        LanguageHelper.globals.put("colors.red", "\u00a74");
        LanguageHelper.globals.put("colors.purple", "\u00a75");
        LanguageHelper.globals.put("colors.gold", "\u00a76");
        LanguageHelper.globals.put("colors.light_gray", "\u00a77");
        LanguageHelper.globals.put("colors.gray", "\u00a78");
        LanguageHelper.globals.put("colors.dark_purple", "\u00a79");
        LanguageHelper.globals.put("colors.light_green", "\u00a7a");
        LanguageHelper.globals.put("colors.light_blue", "\u00a7b");
        LanguageHelper.globals.put("colors.rose", "\u00a7c");
        LanguageHelper.globals.put("colors.light_purple", "\u00a7d");
        LanguageHelper.globals.put("colors.yellow", "\u00a7e");
        LanguageHelper.globals.put("colors.white", "\u00a7f");
        LanguageHelper.globals.put("colors.reset", EnumChatFormatting.RESET.toString());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        CommandHandler handler = (CommandHandler)MinecraftServer.func_71276_C().func_71187_D();
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            handler.func_71560_a((ICommand)new CommandDebug());
        }
    }

    public static void preInit() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            return;
        }
        ModContainer mod = Loader.instance().activeModContainer();
        SandstoneMod smod = Loader.instance().activeModContainer().getMod().getClass().getAnnotation(SandstoneMod.class);
        if (smod.basePackage().equals("")) {
            LOGGER.error("SandstoneMod " + Loader.instance().activeModContainer().getModId() + "didn't have a basePackage! Ignoring!");
            return;
        }
        ModRegistry.put(mod, smod);
        ClassLoader classLoader = Loader.instance().activeModContainer().getMod().getClass().getClassLoader();
        try {
            ContentHandler.init(classLoader, smod.basePackage() + "." + smod.itemsLocation());
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, Loader.instance().activeModContainer().getModId() + " failed to initiate items.", true);
        }
        try {
            ContentHandler.init(classLoader, smod.basePackage() + "." + smod.blocksLocation());
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, Loader.instance().activeModContainer().getModId() + " failed to initiate blocks.", true);
        }
    }

    public static void postInit() {
        if (!Loader.instance().isInState(LoaderState.POSTINITIALIZATION)) {
            return;
        }
        String modId = Loader.instance().activeModContainer().getModId();
        if (modIntegrations.containsKey(modId)) {
            for (ModIntegration mod : modIntegrations.get(modId)) {
                mod.onLoad(Loader.isModLoaded((String)mod.modId));
            }
        }
    }

    public static boolean addModIntegration(ModIntegration modIntegration) {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION) && !Loader.instance().isInState(LoaderState.INITIALIZATION)) {
            return false;
        }
        String modId = Loader.instance().activeModContainer().getModId();
        if (!modIntegrations.containsKey(modId)) {
            modIntegrations.put(modId, new ArrayList());
        }
        return modIntegrations.get(modId).add(modIntegration);
    }
}

