/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockNewSapling;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ForestryPlugin {
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;

    public static void preInit() {
    }

    public static void init() {
        if (!ForestryPlugin.isEnabled()) {
            return;
        }
        ForestryPlugin.addFarmableSaplings();
    }

    public static boolean isEnabled() {
        return Extrabiomes.proxy.isModLoaded("Forestry");
    }

    public static void postInit() {
        if (!ForestryPlugin.isEnabled()) {
            return;
        }
        ForestryPlugin.addForestrySoils();
        ForestryPlugin.addFlowers();
        ForestryPlugin.addBackpaclItems();
        ForestryPlugin.addRedrockCarpenterRecipes();
        ForestryPlugin.addSaplingRecipes();
    }

    private static void addForestrySoils() {
        Block soil = (Block)GameData.getBlockRegistry().func_82594_a("Forestry:soil");
        if (soil == null || soil == Blocks.field_150350_a) {
            LogHelper.info("Unable to find forestry soil block", new Object[0]);
            return;
        }
        TreeSoilRegistry.addValidSoil(soil);
        BlockCustomSapling.setForestrySoil(soil);
        BlockNewSapling.setForestrySoil(soil);
    }

    private static void addFarmableSaplings() {
        for (ItemStack sapling : ForestryModHelper.getSaplings()) {
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.%s", GameData.getBlockRegistry().func_148750_c((Object)Block.func_149634_a((Item)sapling.func_77973_b())), sapling.func_77960_j()));
        }
    }

    private static void addBackpaclItems() {
        try {
            Collection<ItemStack> items = ForestryModHelper.getForesterBackPackItems();
            for (ItemStack item : items) {
                BackpackManager.backpackItems[2].add(item);
            }
            items = ForestryModHelper.getDiggerBackPackItems();
            for (ItemStack item : items) {
                BackpackManager.backpackItems[1].add(item);
            }
            if (Stuff.quickSand.isPresent()) {
                BackpackManager.backpackItems[1].add(new ItemStack((Block)Stuff.quickSand.get()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addFlowers() {
        for (ItemStack flower : ForestryModHelper.getBasicFlowers()) {
            FlowerManager.plainFlowers.add(flower);
        }
    }

    private static void addRedrockCarpenterRecipes() {
        try {
            RecipeManagers.carpenterManager.addRecipe(10, ForestryPlugin.getFluidStack("water", 3000), null, new ItemStack(Items.field_151119_aD, 4), new Object[]{"#", Character.valueOf('#'), Element.RED_COBBLE.get()});
        }
        catch (Exception e) {
            LogHelper.severe("The forestry API changed in reguards to fluids/liquids.", new Object[0]);
        }
    }

    private static void addSaplingRecipes() {
        int amnt = ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling");
        for (ItemStack sapling : ForestryModHelper.getSaplings()) {
            try {
                RecipeManagers.fermenterManager.addRecipe(sapling, amnt, 1.0f, ForestryPlugin.getFluidStack("biomass"), ForestryPlugin.getFluidStack("water"));
                RecipeManagers.fermenterManager.addRecipe(sapling, amnt, 1.5f, ForestryPlugin.getFluidStack("biomass"), ForestryPlugin.getFluidStack("juice"));
                RecipeManagers.fermenterManager.addRecipe(sapling, amnt, 1.5f, ForestryPlugin.getFluidStack("biomass"), ForestryPlugin.getFluidStack("honey"));
            }
            catch (Exception e) {
                LogHelper.severe("The forestry API changed in reguards to fluids/liquids.", new Object[0]);
            }
        }
    }

    private static FluidStack getFluidStack(String name) throws Exception {
        return ForestryPlugin.getFluidStack(name, 1000);
    }

    private static FluidStack getFluidStack(String name, int ammount) throws Exception {
        return FluidRegistry.getFluidStack((String)name, (int)ammount);
    }

    private class EbXLSapling
    implements IFarmable {
        Block block = null;
        int metadata = 0;
        ItemStack itemSapling = null;

        public EbXLSapling(ItemStack item) {
            this.block = Block.func_149634_a((Item)item.func_77973_b());
            this.metadata = item.func_77960_j();
            this.itemSapling = item.func_77946_l();
        }

        public boolean isSaplingAt(World world, int x, int y, int z) {
            return world.func_147439_a(x, y, z) == this.block && world.func_72805_g(x, y, z) == this.metadata;
        }

        public ICrop getCropAt(World world, int x, int y, int z) {
            return null;
        }

        public boolean isGermling(ItemStack itemstack) {
            return this.itemSapling.equals(itemstack);
        }

        public boolean isWindfall(ItemStack itemstack) {
            return this.itemSapling.equals(itemstack);
        }

        public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
            return true;
        }

        @Deprecated
        public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
            return true;
        }
    }
}

