/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public abstract class WorldGenNewTreeBase
extends WorldGenAbstractTree {
    int leafCount = 0;

    public WorldGenNewTreeBase(boolean par1) {
        super(par1);
    }

    public boolean check1x1Trunk(int x, int y, int z, int height, ItemStack logs, World world) {
        for (int y1 = y + 1; y1 < y + height; ++y1) {
            if (world.func_147437_c(x, y1, z)) continue;
            return false;
        }
        return true;
    }

    public boolean place1x1Trunk(int x, int y, int z, int height, ItemStack logs, World world) {
        Block logBlock = Block.func_149634_a((Item)logs.func_77973_b());
        for (int y1 = y; y1 < y + height; ++y1) {
            this.func_150516_a(world, x, y1, z, logBlock, logs.func_77960_j());
        }
        return true;
    }

    public boolean place2x2Trunk(int x, int y, int z, int height, ItemStack logs, World world) {
        Block logBlock = Block.func_149634_a((Item)logs.func_77973_b());
        for (int y1 = y; y1 < y + height; ++y1) {
            this.func_150516_a(world, x, y1, z, logBlock, 0);
            this.func_150516_a(world, x + 1, y1, z, logBlock, 1);
            this.func_150516_a(world, x, y1, z + 1, logBlock, 3);
            this.func_150516_a(world, x + 1, y1, z + 1, logBlock, 2);
        }
        return true;
    }

    public boolean check2x2Trunk(int x, int y, int z, int height, ItemStack logs, World world, boolean inWater) {
        if (inWater) {
            for (int y1 = y + 1; y1 < y + height; ++y1) {
                Block b00 = world.func_147439_a(x, y1, z);
                Block b10 = world.func_147439_a(x + 1, y1, z);
                Block b01 = world.func_147439_a(x, y1, z + 1);
                Block b11 = world.func_147439_a(x + 1, y1, z + 1);
                if (b00 != null && !b00.equals(Blocks.field_150355_j) && !b00.isReplaceable((IBlockAccess)world, x, y1, z)) {
                    return false;
                }
                if (b01 != null && !b01.equals(Blocks.field_150355_j) && !b01.isReplaceable((IBlockAccess)world, x + 1, y1, z)) {
                    return false;
                }
                if (b10 != null && !b10.equals(Blocks.field_150355_j) && !b10.isReplaceable((IBlockAccess)world, x, y1, z + 1)) {
                    return false;
                }
                if (b11 == null || b11.equals(Blocks.field_150355_j) || b11.isReplaceable((IBlockAccess)world, x + 1, y1, z + 1)) continue;
                return false;
            }
        } else {
            for (int y1 = y + 1; y1 < y + height; ++y1) {
                if (!world.func_147437_c(x, y1, z)) {
                    return false;
                }
                if (!world.func_147437_c(x + 1, y1, z)) {
                    return false;
                }
                if (!world.func_147437_c(x, y1, z + 1)) {
                    return false;
                }
                if (world.func_147437_c(x + 1, y1, z + 1)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean placeKnee(int x, int y, int z, int height, int direction, ItemStack logs, ItemStack knees, World world) {
        Block block;
        int y1;
        Block logBlock = Block.func_149634_a((Item)logs.func_77973_b());
        if (direction > 3) {
            return false;
        }
        int orientation = 0;
        switch (direction) {
            case 0: {
                orientation = 4;
                break;
            }
            case 1: {
                orientation = 9;
                break;
            }
            case 2: {
                orientation = 5;
                break;
            }
            case 3: {
                orientation = 8;
                break;
            }
        }
        for (y1 = y - 1; y1 > 1 && ((block = world.func_147439_a(x, y1, z)) == null || block.canBeReplacedByLeaves((IBlockAccess)world, x, y1, z)); --y1) {
            this.func_150516_a(world, x, y1, z, logBlock, logs.func_77960_j());
        }
        for (y1 = y; y1 < y + height - 1; ++y1) {
            this.func_150516_a(world, x, y1, z, logBlock, logs.func_77960_j());
        }
        this.func_150516_a(world, x, y + height - 1, z, Block.func_149634_a((Item)knees.func_77973_b()), orientation);
        return true;
    }

    public boolean checkBlockLine(int[] start, int[] end, ItemStack logs, World world) {
        if (start.length != 3 || end.length != 3) {
            return false;
        }
        int[] direction = new int[]{start[0] - end[0], start[1] - end[1], start[2] - end[2]};
        if (Math.abs(direction[2]) > Math.abs(direction[1]) && Math.abs(direction[2]) > Math.abs(direction[0])) {
            if (direction[2] >= 0) {
                for (int z = start[2]; z >= end[2]; --z) {
                    double m = (double)(z - start[2]) / (double)direction[2];
                    int x = (int)((double)start[0] + (double)direction[0] * m);
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    if (world.func_147437_c(x, y, z)) continue;
                    return false;
                }
            } else {
                for (int z = start[2]; z <= end[2]; ++z) {
                    double m = (double)(z - start[2]) / (double)direction[2];
                    int x = (int)((double)start[0] + (double)direction[0] * m);
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    if (world.func_147437_c(x, y, z)) continue;
                    return false;
                }
            }
        } else if (Math.abs(direction[0]) > Math.abs(direction[1])) {
            if (direction[0] >= 0) {
                for (int x = start[0]; x >= end[0]; --x) {
                    double m = (double)(x - start[0]) / (double)direction[0];
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    int z = (int)((double)start[2] + (double)direction[2] * m);
                    if (world.func_147437_c(x, y, z)) continue;
                    return false;
                }
            } else {
                for (int x = start[0]; x <= end[0]; ++x) {
                    double m = (double)(x - start[0]) / (double)direction[0];
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    int z = (int)((double)start[2] + (double)direction[2] * m);
                    if (world.func_147437_c(x, y, z)) continue;
                    return false;
                }
            }
        } else if (direction[1] >= 0) {
            for (int y = start[1]; y >= end[1]; --y) {
                double m = (double)(y - start[1]) / (double)direction[1];
                int x = (int)((double)start[0] + (double)direction[0] * m);
                int z = (int)((double)start[2] + (double)direction[2] * m);
                if (world.func_147437_c(x, y, z)) continue;
                return false;
            }
        } else {
            for (int y = start[1]; y <= end[1]; ++y) {
                double m = (double)(y - start[1]) / (double)direction[1];
                int x = (int)((double)start[0] + (double)direction[0] * m);
                int z = (int)((double)start[2] + (double)direction[2] * m);
                if (world.func_147437_c(x, y, z)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean placeBlockLine(int[] start, int[] end, ItemStack logs, World world) {
        Block logBlock = Block.func_149634_a((Item)logs.func_77973_b());
        if (start.length != 3 || end.length != 3) {
            return false;
        }
        int[] direction = new int[]{start[0] - end[0], start[1] - end[1], start[2] - end[2]};
        if (Math.abs(direction[2]) > Math.abs(direction[1]) && Math.abs(direction[2]) > Math.abs(direction[0])) {
            if (direction[2] >= 0) {
                for (int z = start[2]; z >= end[2]; --z) {
                    double m = (double)(z - start[2]) / (double)direction[2];
                    int x = (int)((double)start[0] + (double)direction[0] * m);
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    if (!world.func_147437_c(x, y, z)) continue;
                    this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 8);
                }
            } else {
                for (int z = start[2]; z <= end[2]; ++z) {
                    double m = (double)(z - start[2]) / (double)direction[2];
                    int x = (int)((double)start[0] + (double)direction[0] * m);
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    if (!world.func_147437_c(x, y, z)) continue;
                    this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 8);
                }
            }
        } else if (Math.abs(direction[0]) > Math.abs(direction[1])) {
            if (direction[0] >= 0) {
                for (int x = start[0]; x >= end[0]; --x) {
                    double m = (double)(x - start[0]) / (double)direction[0];
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    int z = (int)((double)start[2] + (double)direction[2] * m);
                    if (!world.func_147437_c(x, y, z)) continue;
                    this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 4);
                }
            } else {
                for (int x = start[0]; x <= end[0]; ++x) {
                    double m = (double)(x - start[0]) / (double)direction[0];
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    int z = (int)((double)start[2] + (double)direction[2] * m);
                    if (!world.func_147437_c(x, y, z)) continue;
                    this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 4);
                }
            }
        } else if (direction[1] >= 0) {
            for (int y = start[1]; y >= end[1]; --y) {
                double m = (double)(y - start[1]) / (double)direction[1];
                int x = (int)((double)start[0] + (double)direction[0] * m);
                int z = (int)((double)start[2] + (double)direction[2] * m);
                if (!world.func_147437_c(x, y, z)) continue;
                this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j());
            }
        } else {
            for (int y = start[1]; y <= end[1]; ++y) {
                double m = (double)(y - start[1]) / (double)direction[1];
                int x = (int)((double)start[0] + (double)direction[0] * m);
                int z = (int)((double)start[2] + (double)direction[2] * m);
                if (!world.func_147437_c(x, y, z)) continue;
                this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j());
            }
        }
        return true;
    }

    public boolean placeThinBlockLine(int[] start, int[] end, ItemStack logs, World world) {
        Block logBlock = Block.func_149634_a((Item)logs.func_77973_b());
        if (start.length != 3 || end.length != 3) {
            return false;
        }
        int[] last = new int[]{start[0], start[1], start[2]};
        int[] direction = new int[]{start[0] - end[0], start[1] - end[1], start[2] - end[2]};
        if (Math.abs(direction[2]) > Math.abs(direction[1]) && Math.abs(direction[2]) > Math.abs(direction[0])) {
            if (direction[2] >= 0) {
                int z = start[2];
                while (z >= end[2]) {
                    int dist;
                    double m = (double)(z - start[2]) / (double)direction[2];
                    int x = (int)((double)start[0] + (double)direction[0] * m);
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    if (world.func_147437_c(x, y, z)) {
                        this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 8);
                    }
                    if ((dist = Math.abs(last[0] - x) + Math.abs(last[1] - y) + Math.abs(last[2] - z)) == 2) {
                        this.func_150516_a(world, last[0], last[1], z, logBlock, logs.func_77960_j() | 8);
                    } else if (dist == 3) {
                        if (direction[0] > 0) {
                            this.func_150516_a(world, x, last[1], last[2], logBlock, logs.func_77960_j() | 8);
                            this.func_150516_a(world, x, y, last[2], logBlock, logs.func_77960_j() | 8);
                        } else {
                            this.func_150516_a(world, last[0], y, last[2], logBlock, logs.func_77960_j() | 8);
                            this.func_150516_a(world, x, y, last[2], logBlock, logs.func_77960_j() | 8);
                        }
                    }
                    last[0] = x;
                    last[1] = y;
                    last[2] = z--;
                }
            } else {
                int z = start[2];
                while (z <= end[2]) {
                    int dist;
                    double m = (double)(z - start[2]) / (double)direction[2];
                    int x = (int)((double)start[0] + (double)direction[0] * m);
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    if (world.func_147437_c(x, y, z)) {
                        this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 8);
                    }
                    if ((dist = Math.abs(last[0] - x) + Math.abs(last[1] - y) + Math.abs(last[2] - z)) == 2) {
                        this.func_150516_a(world, last[0], last[1], z, logBlock, logs.func_77960_j() | 8);
                    } else if (dist == 3) {
                        if (direction[0] > 0) {
                            this.func_150516_a(world, x, last[1], last[2], logBlock, logs.func_77960_j() | 8);
                            this.func_150516_a(world, x, y, last[2], logBlock, logs.func_77960_j() | 8);
                        } else {
                            this.func_150516_a(world, last[0], y, last[2], logBlock, logs.func_77960_j() | 8);
                            this.func_150516_a(world, x, y, last[2], logBlock, logs.func_77960_j() | 8);
                        }
                    }
                    last[0] = x;
                    last[1] = y;
                    last[2] = z++;
                }
            }
        } else if (Math.abs(direction[0]) > Math.abs(direction[1])) {
            if (direction[0] >= 0) {
                int x = start[0];
                while (x >= end[0]) {
                    int dist;
                    double m = (double)(x - start[0]) / (double)direction[0];
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    int z = (int)((double)start[2] + (double)direction[2] * m);
                    if (world.func_147437_c(x, y, z)) {
                        this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 4);
                    }
                    if ((dist = Math.abs(last[0] - x) + Math.abs(last[1] - y) + Math.abs(last[2] - z)) == 2) {
                        this.func_150516_a(world, x, last[1], last[2], logBlock, logs.func_77960_j() | 4);
                    } else if (dist == 3) {
                        if (direction[2] > 0) {
                            this.func_150516_a(world, last[0], last[1], z, logBlock, logs.func_77960_j() | 4);
                            this.func_150516_a(world, last[0], y, z, logBlock, logs.func_77960_j() | 4);
                        } else {
                            this.func_150516_a(world, last[0], y, last[2], logBlock, logs.func_77960_j() | 4);
                            this.func_150516_a(world, last[0], y, z, logBlock, logs.func_77960_j() | 4);
                        }
                    }
                    last[0] = x--;
                    last[1] = y;
                    last[2] = z;
                }
            } else {
                int x = start[0];
                while (x <= end[0]) {
                    int dist;
                    double m = (double)(x - start[0]) / (double)direction[0];
                    int y = (int)((double)start[1] + (double)direction[1] * m);
                    int z = (int)((double)start[2] + (double)direction[2] * m);
                    if (world.func_147437_c(x, y, z)) {
                        this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j() | 4);
                    }
                    if ((dist = Math.abs(last[0] - x) + Math.abs(last[1] - y) + Math.abs(last[2] - z)) == 2) {
                        this.func_150516_a(world, x, last[1], last[2], logBlock, logs.func_77960_j() | 4);
                    } else if (dist == 3) {
                        if (direction[2] > 0) {
                            this.func_150516_a(world, last[0], last[1], z, logBlock, logs.func_77960_j() | 4);
                            this.func_150516_a(world, last[0], y, z, logBlock, logs.func_77960_j() | 4);
                        } else {
                            this.func_150516_a(world, last[0], y, last[2], logBlock, logs.func_77960_j() | 4);
                            this.func_150516_a(world, last[0], y, z, logBlock, logs.func_77960_j() | 4);
                        }
                    }
                    last[0] = x++;
                    last[1] = y;
                    last[2] = z;
                }
            }
        } else if (direction[1] >= 0) {
            int y = start[1];
            while (y >= end[1]) {
                int dist;
                double m = (double)(y - start[1]) / (double)direction[1];
                int x = (int)((double)start[0] + (double)direction[0] * m);
                int z = (int)((double)start[2] + (double)direction[2] * m);
                if (world.func_147437_c(x, y, z)) {
                    this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j());
                }
                if ((dist = Math.abs(last[0] - x) + Math.abs(last[1] - y) + Math.abs(last[2] - z)) == 2) {
                    this.func_150516_a(world, last[0], y, last[2], logBlock, logs.func_77960_j());
                } else if (dist == 3) {
                    if (direction[2] > 0) {
                        this.func_150516_a(world, last[0], last[1], z, logBlock, logs.func_77960_j());
                        this.func_150516_a(world, x, last[1], z, logBlock, logs.func_77960_j());
                    } else {
                        this.func_150516_a(world, x, last[1], last[2], logBlock, logs.func_77960_j());
                        this.func_150516_a(world, x, last[1], z, logBlock, logs.func_77960_j());
                    }
                }
                last[0] = x;
                last[1] = y--;
                last[2] = z;
            }
        } else {
            int y = start[1];
            while (y <= end[1]) {
                int dist;
                double m = (double)(y - start[1]) / (double)direction[1];
                int x = (int)((double)start[0] + (double)direction[0] * m);
                int z = (int)((double)start[2] + (double)direction[2] * m);
                if (world.func_147437_c(x, y, z)) {
                    this.func_150516_a(world, x, y, z, logBlock, logs.func_77960_j());
                }
                if ((dist = Math.abs(last[0] - x) + Math.abs(last[1] - y) + Math.abs(last[2] - z)) == 2) {
                    this.func_150516_a(world, last[0], y, last[2], logBlock, logs.func_77960_j());
                } else if (dist == 3) {
                    if (direction[2] > 0) {
                        this.func_150516_a(world, last[0], last[1], z, logBlock, logs.func_77960_j());
                        this.func_150516_a(world, x, last[1], z, logBlock, logs.func_77960_j());
                    } else {
                        this.func_150516_a(world, x, last[1], last[2], logBlock, logs.func_77960_j());
                        this.func_150516_a(world, x, last[1], z, logBlock, logs.func_77960_j());
                    }
                }
                last[0] = x;
                last[1] = y++;
                last[2] = z;
            }
        }
        return true;
    }

    public boolean checkLeavesCircle(double x, int y, double z, double r, World world) {
        double dist = r * r;
        for (double z1 = Math.floor(-r); z1 < r + 1.0; z1 += 1.0) {
            for (double x1 = Math.floor(-r); x1 < r + 1.0; x1 += 1.0) {
                int x2 = (int)(x1 + x);
                int z2 = (int)(z1 + z);
                Block block = world.func_147439_a(x2, y, z2);
                if (!(x1 * x1 + z1 * z1 <= dist) || block == null || block.isAir((IBlockAccess)world, x2, y, z2)) continue;
                return false;
            }
        }
        return true;
    }

    public void placeLeavesCircle(double x, int y, double z, double r, ItemStack leaves, World world) {
        double dist = r * r;
        for (double z1 = Math.floor(-r); z1 < r + 1.0; z1 += 1.0) {
            for (double x1 = Math.floor(-r); x1 < r + 1.0; x1 += 1.0) {
                int x2 = (int)(x1 + x);
                int z2 = (int)(z1 + z);
                Block block = world.func_147439_a(x2, y, z2);
                if (!(x1 * x1 + z1 * z1 <= dist) || block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x2, y, z2)) continue;
                this.setLeafBlock(world, x2, y, z2, leaves);
            }
        }
    }

    public void setLeafBlock(World world, int x, int y, int z, ItemStack leaves) {
        ++this.leafCount;
        this.func_150516_a(world, x, y, z, Block.func_149634_a((Item)leaves.func_77973_b()), leaves.func_77960_j());
    }

    public boolean checkLeafCluster(World world, int x, int y, int z, int height, int radius) {
        for (int layer = -height; layer <= height; ++layer) {
            if (this.checkLeavesCircle(x, y + layer, z, (double)radius * Math.cos((double)layer / ((double)height / 1.3)), world)) continue;
            return false;
        }
        return true;
    }

    public void generateLeafCluster(World world, int x, int y, int z, int height, int radius, ItemStack leaves) {
        for (int layer = -height; layer <= height; ++layer) {
            this.placeLeavesCircle(x, y + layer, z, (double)radius * Math.cos((double)layer / ((double)height / 1.3)), leaves, world);
        }
    }
}

