/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenFirTreeHuge
extends WorldGenAbstractTree {
    private static long lastSeed = 0L;

    private static void setBlockandMetadataIfChunkExists(World world, int x, int y, int z, Block block, int metadata) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                world.func_147465_d(x, y, z, block, metadata, 3);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public WorldGenFirTreeHuge(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z);
    }

    public boolean generate(World world, long seed, int x, int y, int z) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z);
    }

    private boolean generateTree(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(16) + 32;
        int j = 1 + rand.nextInt(12);
        int k = height - j;
        int l = 2 + rand.nextInt(9);
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y1 = y; y1 <= y + 1 + height; ++y1) {
            if (y1 < 0 && y1 >= 256) {
                return false;
            }
            int k1 = 1;
            k1 = y1 - y < j ? 0 : l;
            for (int x1 = x - k1; x1 <= x + k1; ++x1) {
                for (int z1 = z - k1; z1 <= z + k1; ++z1) {
                    if (!world.func_72863_F().func_73149_a(x1 >> 4, z1 >> 4)) {
                        return false;
                    }
                    Block block = world.func_147439_a(x1, y1, z1);
                    if (block == null || block.isLeaves((IBlockAccess)world, x1, y1, z1) || block.isReplaceable((IBlockAccess)world, x1, y1, z1)) continue;
                    return false;
                }
            }
        }
        if (!TreeSoilRegistry.isValidSoil(world.func_147439_a(x, y - 1, z)) || y >= 256 - height - 1) {
            return false;
        }
        world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
        world.func_147449_b(x - 1, y - 1, z, Blocks.field_150346_d);
        world.func_147449_b(x, y - 1, z - 1, Blocks.field_150346_d);
        world.func_147449_b(x - 1, y - 1, z - 1, Blocks.field_150346_d);
        int l1 = rand.nextInt(2);
        int j2 = 1;
        boolean flag1 = false;
        for (int i3 = 0; i3 <= k; ++i3) {
            int k3 = y + height - i3;
            for (int i4 = x - l1; i4 <= x + l1; ++i4) {
                int k4 = i4 - x;
                for (int l4 = z - l1; l4 <= z + l1; ++l4) {
                    int i5 = l4 - z;
                    if (Math.abs(k4) == l1 && Math.abs(i5) == l1 && l1 > 0) continue;
                    Block block = world.func_147439_a(i4, k3, l4);
                    if (block.isAir((IBlockAccess)world, i4, k3, l4) || block.canBeReplacedByLeaves((IBlockAccess)world, i4, k3, l4)) {
                        WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4, k3, l4, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((block = world.func_147439_a(i4 - 1, k3, l4)).isAir((IBlockAccess)world, i4 - 1, k3, l4) || block.canBeReplacedByLeaves((IBlockAccess)world, i4 - 1, k3, l4)) {
                        WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4 - 1, k3, l4, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((block = world.func_147439_a(i4, k3, l4 - 1)).isAir((IBlockAccess)world, i4, k3, l4 - 1) || block.canBeReplacedByLeaves((IBlockAccess)world, i4, k3, l4 - 1)) {
                        WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4, k3, l4 - 1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                    }
                    if (!(block = world.func_147439_a(i4 - 1, k3, l4 - 1)).isAir((IBlockAccess)world, i4 - 1, k3, l4 - 1) && !block.canBeReplacedByLeaves((IBlockAccess)world, i4 - 1, k3, l4 - 1)) continue;
                    WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4 - 1, k3, l4 - 1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                }
            }
            if (l1 >= j2) {
                l1 = flag1 ? 1 : 0;
                flag1 = true;
                if (++j2 <= l) continue;
                j2 = l;
                continue;
            }
            ++l1;
        }
        int j3 = rand.nextInt(3);
        for (int l3 = 0; l3 < height - j3; ++l3) {
            Block block = world.func_147439_a(x, y + l3, z);
            if (block != null && !block.isLeaves((IBlockAccess)world, x, y + l3, z) && !block.isReplaceable((IBlockAccess)world, x, y + l3, z)) continue;
            this.func_150516_a(world, x, y + l3, z, TreeBlock.TRUNK.getBlock(), 2);
            this.func_150516_a(world, x - 1, y + l3, z, TreeBlock.TRUNK.getBlock(), 3);
            this.func_150516_a(world, x, y + l3, z - 1, TreeBlock.TRUNK.getBlock(), 1);
            this.func_150516_a(world, x - 1, y + l3, z - 1, TreeBlock.TRUNK.getBlock(), 0);
        }
        return true;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Blocks.field_150362_t, 1, 1)),
        TRUNK(new ItemStack(Blocks.field_150364_r, 1, 1));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_FIR.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_FIR.get();
            }
            if (Element.LOG_QUARTER_FIR.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_QUARTER_FIR.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ItemStack stack) {
            this.stack = stack;
        }

        public Block getBlock() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return Block.func_149634_a((Item)this.stack.func_77973_b());
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

