/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenAutumnTree
extends WorldGenAbstractTree {
    private static Block trunkBlock = Blocks.field_150364_r;
    private static int trunkMetadata = 1;
    private static final int BASE_HEIGHT = 4;
    private static final int CANOPY_HEIGHT = 3;
    private static final int CANOPY_RADIUS_EXTRA_RADIUS = 0;
    private static final int MAX_VARIANCE_HEIGHT = 2;
    protected final AutumnTreeType type;
    private static long lastSeed = 0L;

    private static boolean isBlockSuitableForGrowing(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return TreeSoilRegistry.isValidSoil(block);
    }

    private static boolean isRoomToGrow(World world, int x, int y, int z, int height) {
        for (int i = y; i <= y + 1 + height; ++i) {
            if (i < 0 || i >= 256) {
                return false;
            }
            int radius = 1;
            if (i == y) {
                radius = 0;
            }
            if (i >= y + 1 + height - 2) {
                radius = 2;
            }
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    Block block = world.func_147439_a(x1, i, z1);
                    if (block == null || block.isLeaves((IBlockAccess)world, x1, i, z1) || block.equals(Blocks.field_150349_c) || block.isWood((IBlockAccess)world, x1, i, z1) || block.isReplaceable((IBlockAccess)world, x1, i, z1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void setTrunkBlock(Block block, int metadata) {
        trunkBlock = block;
        trunkMetadata = metadata;
    }

    public WorldGenAutumnTree(boolean doBlockNotify, AutumnTreeType type) {
        super(doBlockNotify);
        this.type = type;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z);
    }

    public boolean generate(World world, long seed, int x, int y, int z) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z);
    }

    private boolean generateTree(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(3) + 4;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        if (!WorldGenAutumnTree.isBlockSuitableForGrowing(world, x, y - 1, z)) {
            return false;
        }
        if (!WorldGenAutumnTree.isRoomToGrow(world, x, y, z, height)) {
            return false;
        }
        world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
        this.growLeaves(world, rand, x, y, z, height, this.type.getBlock(), this.type.getMetadata());
        this.growTrunk(world, x, y, z, height, trunkBlock, trunkMetadata);
        return true;
    }

    private void growLeaves(World world, Random rand, int x, int y, int z, int height, Block leaf, int leafMeta) {
        for (int y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int canopyRow = y1 - (y + height);
            int radius = 1 - canopyRow / 2;
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                int xDistanceFromTrunk = x1 - x;
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    int zDistanceFromTrunk = z1 - z;
                    Block block = world.func_147439_a(x1, y1, z1);
                    if (Math.abs(xDistanceFromTrunk) == radius && Math.abs(zDistanceFromTrunk) == radius && (rand.nextInt(2) == 0 || canopyRow == 0) || block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x1, y1, z1)) continue;
                    this.func_150516_a(world, x1, y1, z1, leaf, leafMeta);
                }
            }
        }
    }

    private void growTrunk(World world, int x, int y, int z, int height, Block wood, int woodMeta) {
        for (int y1 = 0; y1 < height; ++y1) {
            Block block = world.func_147439_a(x, y + y1, z);
            if (block != null && !block.isReplaceable((IBlockAccess)world, x, y + y1, z) && !block.isLeaves((IBlockAccess)world, x, y + y1, z)) continue;
            this.func_150516_a(world, x, y + y1, z, wood, woodMeta);
        }
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    public static enum AutumnTreeType {
        BROWN,
        ORANGE,
        PURPLE,
        YELLOW;

        private ItemStack leaves = new ItemStack((Block)Blocks.field_150362_t);
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_AUTUMN_BROWN.isPresent()) {
                AutumnTreeType.BROWN.leaves = Element.LEAVES_AUTUMN_BROWN.get();
            }
            if (Element.LEAVES_AUTUMN_ORANGE.isPresent()) {
                AutumnTreeType.ORANGE.leaves = Element.LEAVES_AUTUMN_ORANGE.get();
            }
            if (Element.LEAVES_AUTUMN_PURPLE.isPresent()) {
                AutumnTreeType.PURPLE.leaves = Element.LEAVES_AUTUMN_PURPLE.get();
            }
            if (Element.LEAVES_AUTUMN_YELLOW.isPresent()) {
                AutumnTreeType.YELLOW.leaves = Element.LEAVES_AUTUMN_YELLOW.get();
            }
            loadedCustomBlocks = true;
        }

        public Item getItem() {
            if (!loadedCustomBlocks) {
                AutumnTreeType.loadCustomBlocks();
            }
            return this.leaves.func_77973_b();
        }

        public Block getBlock() {
            return Block.func_149634_a((Item)this.getItem());
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                AutumnTreeType.loadCustomBlocks();
            }
            return this.leaves.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

