/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import extrabiomes.blocks.BlockCustomVine;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.worldgen.WorldGenCustomVine;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VineGenerator
implements IWorldGenerator {
    private final WorldGenerator vineGen;
    private final BiomeSettings[] biomeList;
    private final BiomeSettings[] DEFAULT_BIOME_LIST = new BiomeSettings[]{BiomeSettings.GREENSWAMP, BiomeSettings.MINIJUNGLE};

    public VineGenerator(BlockCustomVine block) {
        this(block, null);
    }

    public VineGenerator(BlockCustomVine block, BiomeSettings[] biomeList) {
        this.vineGen = new WorldGenCustomVine(block);
        this.biomeList = biomeList == null ? this.DEFAULT_BIOME_LIST : biomeList;
    }

    private boolean biomeCheck(BiomeGenBase biome) {
        BiomeSettings settings = BiomeSettings.findBiomeSettings(biome.field_76756_M);
        if (settings != null) {
            for (BiomeSettings goodBiome : this.biomeList) {
                if (settings != goodBiome) continue;
                return settings.getBiome().isPresent() && biome == settings.getBiome().get();
            }
        }
        return false;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase biome = world.func_72807_a(chunkX <<= 4, chunkZ <<= 4);
        if (!this.biomeCheck(biome)) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            int x = chunkX + rand.nextInt(16) + 8;
            int z = chunkZ + rand.nextInt(16) + 8;
            int y = world.func_72976_f(x, z);
            this.vineGen.func_76484_a(world, rand, x, y, z);
        }
    }
}

