/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.IWorldGenerator;
import extrabiomes.Extrabiomes;
import extrabiomes.blocks.BlockCustomFlower;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.DecorationSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.biome.ExtrabiomeGenBase;
import extrabiomes.module.summa.worldgen.WorldGenMetadataFlowers;
import extrabiomes.module.summa.worldgen.WorldGenRoot;
import extrabiomes.module.summa.worldgen.WorldGenTinyCactus;
import extrabiomes.proxy.CommonProxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FlowerGenerator
implements IWorldGenerator {
    private final Map<BlockCustomFlower.BlockType, WorldGenerator> flowerGens = Maps.newHashMap();
    private final Map<BiomeSettings, List<BlockCustomFlower.BlockType>> flowerMaps = Maps.newHashMap();
    private final Map<Element, WorldGenerator> cropGens = Maps.newHashMap();
    private static FlowerGenerator INSTANCE;

    public static FlowerGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FlowerGenerator();
        }
        return INSTANCE;
    }

    private FlowerGenerator() {
        this.registerFlower(BiomeSettings.ALPINE, BlockCustomFlower.BlockType.BLUE_POPPY);
        this.registerFlower(BiomeSettings.ALPINE, BlockCustomFlower.BlockType.HYDRANGEA);
        this.registerFlower(BiomeSettings.ALPINE, BlockCustomFlower.BlockType.IRIS_BLUE);
        this.registerFlower(BiomeSettings.ALPINE, BlockCustomFlower.BlockType.IRIS_PURPLE);
        this.registerFlower(BiomeSettings.ALPINE, BlockCustomFlower.BlockType.PANSY);
        this.registerFlower(BiomeSettings.ALPINE, BlockCustomFlower.BlockType.VIOLET);
        this.registerFlower(BiomeSettings.AUTUMNWOODS, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.AUTUMNWOODS, BlockCustomFlower.BlockType.REDROVER);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.BUTTERCUP);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.HYDRANGEA);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.PANSY);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.REDROVER);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.TULIP);
        this.registerFlower(BiomeSettings.BIRCHFOREST, BlockCustomFlower.BlockType.VIOLET);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.BELLADONNA);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.GARDENIA);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.GERBERA_ORANGE);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.GERBERA_PINK);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.GERBERA_RED);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.GERBERA_YELLOW);
        this.registerFlower(BiomeSettings.EXTREMEJUNGLE, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.HYDRANGEA);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.IRIS_BLUE);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.IRIS_PURPLE);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.LAVENDER);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.LILY);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.TULIP);
        this.registerFlower(BiomeSettings.FORESTEDHILLS, BlockCustomFlower.BlockType.VIOLET);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.BLUE_POPPY);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.IRIS_BLUE);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.IRIS_PURPLE);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.LAVENDER);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.LILY);
        this.registerFlower(BiomeSettings.FORESTEDISLAND, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.BACHELORS_BUTTON);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.BLUE_POPPY);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.IRIS_BLUE);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.IRIS_PURPLE);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.LILY);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.TULIP);
        this.registerFlower(BiomeSettings.GREENHILLS, BlockCustomFlower.BlockType.VIOLET);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.BELLADONNA);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.BLUE_POPPY);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.BUTTERCUP);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.LILY);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.MARSH_MARIGOLD);
        this.registerFlower(BiomeSettings.GREENSWAMP, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.BACHELORS_BUTTON);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.BUTTERCUP);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.GERBERA_ORANGE);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.GERBERA_PINK);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.GERBERA_RED);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.GERBERA_YELLOW);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.HYDRANGEA);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.POPPY);
        this.registerFlower(BiomeSettings.MEADOW, BlockCustomFlower.BlockType.YARROW);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.BELLADONNA);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.BLUE_POPPY);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.GARDENIA);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.GERBERA_ORANGE);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.GERBERA_PINK);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.GERBERA_RED);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.GERBERA_YELLOW);
        this.registerFlower(BiomeSettings.MINIJUNGLE, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.MOUNTAINTAIGA, BlockCustomFlower.BlockType.PANSY);
        this.registerFlower(BiomeSettings.PINEFOREST, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.PINEFOREST, BlockCustomFlower.BlockType.BUTTERCUP);
        this.registerFlower(BiomeSettings.PINEFOREST, BlockCustomFlower.BlockType.PANSY);
        this.registerFlower(BiomeSettings.PINEFOREST, BlockCustomFlower.BlockType.REDROVER);
        this.registerFlower(BiomeSettings.PINEFOREST, BlockCustomFlower.BlockType.TULIP);
        this.registerFlower(BiomeSettings.PINEFOREST, BlockCustomFlower.BlockType.VIOLET);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.BELLADONNA);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.GARDENIA);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.GERBERA_ORANGE);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.GERBERA_PINK);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.GERBERA_RED);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.GERBERA_YELLOW);
        this.registerFlower(BiomeSettings.RAINFOREST, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.REDWOODLUSH, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.REDWOODLUSH, BlockCustomFlower.BlockType.TULIP);
        this.registerFlower(BiomeSettings.REDWOODLUSH, BlockCustomFlower.BlockType.VIOLET);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.AMARYLLIS_PINK);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.AMARYLLIS_RED);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.AMARYLLIS_WHITE);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.BELLS_OF_IRELAND);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.CALLA_BLACK);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.CALLA_WHITE);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.GERBERA_ORANGE);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.GERBERA_PINK);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.GERBERA_RED);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.GERBERA_YELLOW);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.HYDRANGEA);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.LAVENDER);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.POPPY);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.SNAPDRAGON);
        this.registerFlower(BiomeSettings.SAVANNA, BlockCustomFlower.BlockType.YARROW);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.BACHELORS_BUTTON);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.GERBERA_ORANGE);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.GERBERA_PINK);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.GERBERA_RED);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.GERBERA_YELLOW);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.HYDRANGEA);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.SNAPDRAGON);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.TULIP);
        this.registerFlower(BiomeSettings.SHRUBLAND, BlockCustomFlower.BlockType.YARROW);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.ALLIUM);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.BACHELORS_BUTTON);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.BLUEBELL);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.BLUE_POPPY);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.DAISY);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.DANDELION);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.IRIS_BLUE);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.IRIS_PURPLE);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.LAVENDER);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.LILY);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.ORIENTAL_PINK_LILY);
        this.registerFlower(BiomeSettings.WOODLANDS, BlockCustomFlower.BlockType.TULIP);
    }

    public void registerBlock(Block block, Collection<BlockCustomFlower.BlockType> types) {
        for (BlockCustomFlower.BlockType type : types) {
            WorldGenerator gen;
            switch (type) {
                case ROOT: {
                    gen = new WorldGenRoot(block, type.metadata());
                    break;
                }
                case TINY_CACTUS: {
                    gen = new WorldGenTinyCactus(block, type.metadata());
                    break;
                }
                default: {
                    gen = new WorldGenMetadataFlowers(block, type.metadata());
                }
            }
            this.flowerGens.put(type, gen);
        }
    }

    public void registerCrop(Element element) {
        if (element.isPresent()) {
            WorldGenMetadataFlowers gen = new WorldGenMetadataFlowers(Block.func_149634_a((Item)element.get().func_77973_b()), 7);
            this.cropGens.put(element, gen);
        }
    }

    protected void registerFlower(BiomeSettings settings, BlockCustomFlower.BlockType type) {
        List<Object> list;
        if (!settings.getBiome().isPresent()) {
            return;
        }
        BiomeGenBase biome = (BiomeGenBase)settings.getBiome().get();
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.addGrassPlant(type.block(), type.metadata(), type.weight(), biome);
        if (this.flowerMaps.containsKey((Object)settings)) {
            list = this.flowerMaps.get((Object)settings);
        } else {
            list = Lists.newArrayList();
            this.flowerMaps.put(settings, (List<BlockCustomFlower.BlockType>)list);
        }
        list.add((Object)type);
    }

    protected int applyGenerator(BlockCustomFlower.BlockType type, World world, int chunkX, int chunkZ, Random rand, int times) {
        WorldGenerator gen = this.flowerGens.get((Object)type);
        int count = 0;
        if (gen != null) {
            for (int i = 0; i < times; ++i) {
                int z;
                int y;
                int x = chunkX + rand.nextInt(16) + 8;
                if (!gen.func_76484_a(world, rand, x, y = rand.nextInt(128), z = chunkZ + rand.nextInt(16) + 8)) continue;
                ++count;
            }
        }
        return count;
    }

    protected boolean applyGenerator(BlockCustomFlower.BlockType type, World world, int chunkX, int chunkZ, Random rand) {
        WorldGenerator gen = this.flowerGens.get((Object)type);
        if (gen != null) {
            return this.applyGenerator(gen, world, chunkX, chunkZ, rand);
        }
        return false;
    }

    protected boolean applyGenerator(WorldGenerator gen, World world, int chunkX, int chunkZ, Random rand) {
        if (gen != null) {
            int x = chunkX + rand.nextInt(16) + 8;
            int y = rand.nextInt(128);
            int z = chunkZ + rand.nextInt(16) + 8;
            return gen.func_76484_a(world, rand, x, y, z);
        }
        return false;
    }

    protected boolean biomeCheck(BiomeSettings settings, BiomeGenBase biome) {
        return settings.getBiome().isPresent() && biome == settings.getBiome().get();
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ExtrabiomeGenBase eBiome;
        int maxFlowers;
        BiomeGenBase biome = world.func_72807_a(chunkX <<= 4, chunkZ <<= 4);
        BiomeSettings settings = BiomeSettings.findBiomeSettings(biome.field_76756_M);
        if (settings != null && this.biomeCheck(settings, biome) && this.flowerMaps.containsKey((Object)settings) && (maxFlowers = (eBiome = (ExtrabiomeGenBase)biome).getDecorationSettings().getSetting(DecorationSettings.Decoration.NEW_FLOWERS)) > 0) {
            List<BlockCustomFlower.BlockType> map = this.flowerMaps.get((Object)settings);
            for (int flowers = 0; flowers < maxFlowers; ++flowers) {
                int idx = rand.nextInt(map.size());
                BlockCustomFlower.BlockType type = map.get(idx);
                this.applyGenerator(type, world, chunkX, chunkZ, rand);
            }
        }
        if (this.biomeCheck(BiomeSettings.MOUNTAINDESERT, biome) || this.biomeCheck(BiomeSettings.MOUNTAINRIDGE, biome)) {
            this.applyGenerator(BlockCustomFlower.BlockType.TINY_CACTUS, world, chunkX, chunkZ, rand, 64);
        }
        if (this.biomeCheck(BiomeSettings.AUTUMNWOODS, biome) || this.biomeCheck(BiomeSettings.PINEFOREST, biome) || this.biomeCheck(BiomeSettings.TEMPORATERAINFOREST, biome)) {
            this.applyGenerator(BlockCustomFlower.BlockType.TOADSTOOL, world, chunkX, chunkZ, rand, 2);
        }
        if (this.biomeCheck(BiomeSettings.GREENHILLS, biome) || this.biomeCheck(BiomeSettings.FORESTEDHILLS, biome) || this.biomeCheck(BiomeSettings.FORESTEDISLAND, biome) || this.biomeCheck(BiomeSettings.BIRCHFOREST, biome) || this.biomeCheck(BiomeSettings.PINEFOREST, biome) || this.biomeCheck(BiomeSettings.MEADOW, biome) || this.biomeCheck(BiomeSettings.WOODLANDS, biome)) {
            WorldGenerator gen = this.cropGens.get((Object)Element.PLANT_STRAWBERRY);
            for (int x = 0; x < 4; ++x) {
                this.applyGenerator(gen, world, chunkX, chunkZ, rand);
            }
        }
    }
}

