/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.fabrica.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomFence;
import extrabiomes.blocks.BlockCustomFenceGate;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.helpers.LogHelper;
import extrabiomes.items.ItemCustomDoor;
import extrabiomes.items.ItemCustomFence;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.module.fabrica.block.BlockCustomStairs;
import extrabiomes.module.fabrica.block.BlockCustomWall;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import extrabiomes.module.fabrica.block.BlockCustomWoodDoor;
import extrabiomes.module.fabrica.block.BlockCustomWoodSlab;
import extrabiomes.module.fabrica.block.BlockNewWoodSlab;
import extrabiomes.module.fabrica.block.BlockRedRockSlab;
import extrabiomes.module.fabrica.block.BlockWoodStairs;
import extrabiomes.module.fabrica.block.FuelHandlerWoodSlabs;
import extrabiomes.module.fabrica.block.ItemNewWoodSlab;
import extrabiomes.module.fabrica.block.ItemRedRockSlab;
import extrabiomes.module.fabrica.block.ItemWoodSlab;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.renderers.CustomDoorRender;
import extrabiomes.renderers.CustomFenceRender;
import extrabiomes.utility.MultiItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum BlockManager {
    PLANKS(Stuff.planks, true){

        @Override
        protected void create() {
            Stuff.planks = Optional.of((Object)((Object)new BlockCustomWood()));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.PLANKS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.planks.get();
            thisBlock.func_149663_c("extrabiomes.planks");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class, "planks");
            for (BlockCustomWood.BlockType type : BlockCustomWood.BlockType.values()) {
            }
            proxy.registerOreInAllSubblocks("plankWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.PlankActiveEvent(thisBlock));
        }
    }
    ,
    NEWWOODSLAB(Stuff.newslabWood, true){

        @Override
        protected void create() {
            Stuff.newslabWood = Optional.of((Object)((Object)new BlockNewWoodSlab(this.getSettings(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.NEWWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.newslabWood.get();
            thisBlock.func_149663_c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock));
        }
    }
    ,
    NEWDOUBLEWOODSLAB(Stuff.newslabWoodDouble, true){

        @Override
        protected void create() {
            Stuff.newslabWoodDouble = Optional.of((Object)((Object)new BlockNewWoodSlab(this.getSettings(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.NEWDOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.newslabWoodDouble.get();
            thisBlock.func_149663_c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemNewWoodSlab.setSlabs((BlockSlab)Stuff.newslabWood.get(), (BlockSlab)Stuff.newslabWoodDouble.get());
            proxy.registerBlock((Block)Stuff.newslabWood.get(), ItemNewWoodSlab.class, "woodslab2");
            proxy.registerBlock(thisBlock, ItemNewWoodSlab.class, "double_woodslab2");
            proxy.registerOreInAllSubblocks("slabWood", (Block)Stuff.newslabWood.get());
            Extrabiomes.postInitEvent(new BlockActiveEvent.NewWoodSlabActiveEvent((Block)Stuff.newslabWood.get()));
        }
    }
    ,
    WOODSLAB(Stuff.slabWood, true){

        @Override
        protected void create() {
            Stuff.slabWood = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabWood.get();
            thisBlock.func_149663_c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock));
        }
    }
    ,
    DOUBLEWOODSLAB(Stuff.slabWoodDouble, true){

        @Override
        protected void create() {
            Stuff.slabWoodDouble = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabWoodDouble.get();
            thisBlock.func_149663_c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemWoodSlab.setSlabs((BlockSlab)Stuff.slabWood.get(), (BlockSlab)Stuff.slabWoodDouble.get());
            proxy.registerBlock((Block)Stuff.slabWood.get(), ItemWoodSlab.class, "woodslab");
            proxy.registerBlock(thisBlock, ItemWoodSlab.class, "double_woodslab");
            LogHelper.info("Name: %s", Block.field_149771_c.func_148750_c((Object)thisBlock));
            proxy.registerOreInAllSubblocks("slabWood", (Block)Stuff.slabWood.get());
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodSlabActiveEvent((Block)Stuff.slabWood.get()));
        }
    }
    ,
    REDWOODSTAIRS(Stuff.stairsRedwood, true){

        @Override
        protected void create() {
            Stuff.stairsRedwood = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.REDWOOD.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDWOODSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRedwood.get();
            thisBlock.func_149663_c("extrabiomes.stairs.redwood");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.redwood");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedwoodStairsActiveEvent(thisBlock));
        }
    }
    ,
    FIRSTAIRS(Stuff.stairsFir, true){

        @Override
        protected void create() {
            Stuff.stairsFir = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.FIR.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.FIRSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsFir.get();
            thisBlock.func_149663_c("extrabiomes.stairs.fir");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.fir");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.FirStairsActiveEvent(thisBlock));
        }
    }
    ,
    ACACIASTAIRS(Stuff.stairsAcacia, true){

        @Override
        protected void create() {
            Stuff.stairsAcacia = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.ACACIA.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.ACACIASTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsAcacia.get();
            thisBlock.func_149663_c("extrabiomes.stairs.acacia");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.acacia");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AcaciaStairsActiveEvent(thisBlock));
        }
    }
    ,
    RAINBOWEUCALYPTUSSTAIRS(Stuff.stairsRainbowEucalyptus, true){

        @Override
        protected void create() {
            Stuff.stairsRainbowEucalyptus = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.RAINBOW_EUCALYPTUS.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.RAINBOWEUCALYPTUSSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRainbowEucalyptus.get();
            thisBlock.func_149663_c("extrabiomes.stairs.rainboweucalyptus");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.rainboweucalyptus");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RainbowEucalyptusStairsActiveEvent(thisBlock));
        }
    }
    ,
    CYPRESSSTAIRS(Stuff.stairsCypress, true){

        @Override
        protected void create() {
            Stuff.stairsCypress = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.CYPRESS.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.CYPRESSSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsCypress.get();
            thisBlock.func_149663_c("extrabiomes.stairs.cypress");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.cypress");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.CypressStairsActiveEvent(thisBlock));
        }
    }
    ,
    BALDCYPRESSSTAIRS(Stuff.stairsBaldCypress, true){

        @Override
        protected void create() {
            Stuff.stairsBaldCypress = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.BALD_CYPRESS.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.BALDCYPRESSSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsBaldCypress.get();
            thisBlock.func_149663_c("extrabiomes.stairs.baldcypress");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.baldcypress");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.BaldCypressStairsActiveEvent(thisBlock));
        }
    }
    ,
    JAPANESEMAPLESTAIRS(Stuff.stairsJapaneseMaple, true){

        @Override
        protected void create() {
            Stuff.stairsJapaneseMaple = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.JAPANESE_MAPLE.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.JAPANESEMAPLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsJapaneseMaple.get();
            thisBlock.func_149663_c("extrabiomes.stairs.japanesemaple");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.japanesemaple");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.JapaneseMapleStairsActiveEvent(thisBlock));
        }
    }
    ,
    AUTUMNSTAIRS(Stuff.stairsAutumn, true){

        @Override
        protected void create() {
            Stuff.stairsAutumn = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.AUTUMN.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.AUTUMNSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsAutumn.get();
            thisBlock.func_149663_c("extrabiomes.stairs.autumn");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.autumn");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AutumnStairsActiveEvent(thisBlock));
        }
    }
    ,
    SAKURABLOSSOMSTAIRS(Stuff.stairsSakuraBlossom, true){

        @Override
        protected void create() {
            Stuff.stairsSakuraBlossom = Optional.of((Object)((Object)new BlockWoodStairs((Block)Stuff.planks.get(), BlockCustomWood.BlockType.SAKURA_BLOSSOM.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsSakuraBlossom.get();
            thisBlock.func_149663_c("extrabiomes.stairs.sakurablossom");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "stairs.sakurablossom");
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.SakuraBlossomStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKSLAB(Stuff.slabRedRock, false){

        @Override
        protected void create() {
            Stuff.slabRedRock = Optional.of((Object)((Object)new BlockRedRockSlab(false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabRedRock.get();
            thisBlock.func_149663_c("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
        }
    }
    ,
    DOUBLEREDROCKSLAB(Stuff.slabRedRockDouble, false){

        @Override
        protected void create() {
            Stuff.slabRedRockDouble = Optional.of((Object)((Object)new BlockRedRockSlab(true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEREDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabRedRockDouble.get();
            thisBlock.func_149663_c("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            ItemRedRockSlab.setSlabs((BlockSlab)Stuff.slabRedRock.get(), (BlockSlab)Stuff.slabRedRockDouble.get());
            proxy.registerBlock((Block)Stuff.slabRedRock.get(), ItemRedRockSlab.class, "slabRedRock");
            proxy.registerBlock(thisBlock, ItemRedRockSlab.class, "double_slabRedRock");
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockSlabActiveEvent((Block)Stuff.slabRedRock.get()));
        }
    }
    ,
    REDCOBBLESTAIRS(Stuff.stairsRedCobble, false){

        @Override
        protected void create() {
            Stuff.stairsRedCobble = Optional.of((Object)((Object)new BlockCustomStairs(Block.func_149634_a((Item)Element.RED_COBBLE.get().func_77973_b()), Element.RED_COBBLE.get().func_77960_j())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDCOBBLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRedCobble.get();
            thisBlock.func_149663_c("extrabiomes.stairs.redcobble");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, "stairsRedCobble");
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedCobbleStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKBRICKSTAIRS(Stuff.stairsRedRockBrick, false){

        @Override
        protected void create() {
            Stuff.stairsRedRockBrick = Optional.of((Object)((Object)new BlockCustomStairs(Block.func_149634_a((Item)Element.RED_ROCK_BRICK.get().func_77973_b()), Element.RED_ROCK_BRICK.get().func_77960_j())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKBRICKSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRedRockBrick.get();
            thisBlock.func_149663_c("extrabiomes.stairs.redrockbrick");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, "redrockbrick");
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockBrickStairsActiveEvent(thisBlock));
        }
    }
    ,
    WALL(Stuff.wall, false){

        @Override
        protected void create() {
            Stuff.wall = Optional.of((Object)((Object)new BlockCustomWall()));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WALL;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.wall.get();
            thisBlock.func_149663_c("extrabiomes.wall");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class, "wall");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WallActiveEvent(thisBlock));
        }
    }
    ,
    FENCE(Stuff.fence, false){

        @Override
        protected void create() {
            Stuff.fence = Optional.of((Object)((Object)new BlockCustomFence()));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WALL;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.fence.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomFence.class, "fence");
            ((BlockCustomFence)thisBlock).setRenderId(Extrabiomes.proxy.registerBlockHandler(new CustomFenceRender()));
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceActiveEvent(thisBlock));
        }
    }
    ,
    ACACIADOOR(Stuff.doorAcacia, true){

        @Override
        protected void create() {
            Stuff.doorAcacia = Optional.of((Object)((Object)new BlockCustomWoodDoor("acacia")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.ACACIADOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorAcacia.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_acacia");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorAcacia.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.ACACIA.metadata())));
        }
    }
    ,
    AUTUMNDOOR(Stuff.doorAutumn, true){

        @Override
        protected void create() {
            Stuff.doorAutumn = Optional.of((Object)((Object)new BlockCustomWoodDoor("autumn")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.AUTUMNDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorAutumn.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_autumn");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorAutumn.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.AUTUMN.metadata())));
        }
    }
    ,
    BALDCYPRESSDOOR(Stuff.doorBaldcypress, true){

        @Override
        protected void create() {
            Stuff.doorBaldcypress = Optional.of((Object)((Object)new BlockCustomWoodDoor("baldcypress")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.BALDCYPRESSDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorBaldcypress.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_baldcypress");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorBaldcypress.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.BALD_CYPRESS.metadata())));
        }
    }
    ,
    CYPRESSDOOR(Stuff.doorCypress, true){

        @Override
        protected void create() {
            Stuff.doorCypress = Optional.of((Object)((Object)new BlockCustomWoodDoor("cypress")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.CYPRESSDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorCypress.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_cypress");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorCypress.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.CYPRESS.metadata())));
        }
    }
    ,
    FIRDOOR(Stuff.doorFir, true){

        @Override
        protected void create() {
            Stuff.doorFir = Optional.of((Object)((Object)new BlockCustomWoodDoor("fir")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.FIRDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorFir.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_fir");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorFir.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.FIR.metadata())));
        }
    }
    ,
    JAPANESEMAPLEDOOR(Stuff.doorJapaneseMaple, true){

        @Override
        protected void create() {
            Stuff.doorJapaneseMaple = Optional.of((Object)((Object)new BlockCustomWoodDoor("japanesemaple")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.JAPANESEMAPLEDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorJapaneseMaple.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_japanesemaple");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorJapaneseMaple.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.JAPANESE_MAPLE.metadata())));
        }
    }
    ,
    RAINBOWEUCALYPTUSDOOR(Stuff.doorRainbowEucalyptus, true){

        @Override
        protected void create() {
            Stuff.doorRainbowEucalyptus = Optional.of((Object)((Object)new BlockCustomWoodDoor("rainboweucalyptus")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.RAINBOWEUCALYPTUSDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorRainbowEucalyptus.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_rainboweucalyptus");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorRainbowEucalyptus.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.RAINBOW_EUCALYPTUS.metadata())));
        }
    }
    ,
    REDWOODDOOR(Stuff.doorRedwood, true){

        @Override
        protected void create() {
            Stuff.doorRedwood = Optional.of((Object)((Object)new BlockCustomWoodDoor("redwood")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDWOODDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorRedwood.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_redwood");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorRedwood.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.REDWOOD.metadata())));
        }
    }
    ,
    SAKURADOOR(Stuff.doorSakura, true){

        @Override
        protected void create() {
            Stuff.doorSakura = Optional.of((Object)((Object)new BlockCustomWoodDoor("sakura")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMDOOR;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.doorSakura.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, ItemCustomDoor.class, "door_sakura");
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodDoorActiveEvent(new ItemStack((Block)Stuff.doorSakura.get(), GeneralSettings.useMC18Doors ? 3 : 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.SAKURA_BLOSSOM.metadata())));
        }
    }
    ,
    ACACIAGATE(Stuff.gateAcacia, true){

        @Override
        protected void create() {
            Stuff.gateAcacia = Optional.of((Object)((Object)new BlockCustomFenceGate("acacia")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateAcacia.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_acacia");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateAcacia.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.ACACIA.metadata())));
        }
    }
    ,
    AUTUMNGATE(Stuff.gateAutumn, true){

        @Override
        protected void create() {
            Stuff.gateAutumn = Optional.of((Object)((Object)new BlockCustomFenceGate("autumn")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateAutumn.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_autumn");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateAutumn.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.AUTUMN.metadata())));
        }
    }
    ,
    BALDCYPRESSGATE(Stuff.gateSakura, true){

        @Override
        protected void create() {
            Stuff.gateBaldcypress = Optional.of((Object)((Object)new BlockCustomFenceGate("baldcypress")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateBaldcypress.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_baldcypress");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateBaldcypress.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.BALD_CYPRESS.metadata())));
        }
    }
    ,
    CYPRESSGATE(Stuff.gateCypress, true){

        @Override
        protected void create() {
            Stuff.gateCypress = Optional.of((Object)((Object)new BlockCustomFenceGate("cypress")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateCypress.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_cypress");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateCypress.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.CYPRESS.metadata())));
        }
    }
    ,
    FIRGATE(Stuff.gateFir, true){

        @Override
        protected void create() {
            Stuff.gateFir = Optional.of((Object)((Object)new BlockCustomFenceGate("fir")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateFir.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_fir");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateFir.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.FIR.metadata())));
        }
    }
    ,
    JAPANESEMAPLEGATE(Stuff.gateJapaneseMaple, true){

        @Override
        protected void create() {
            Stuff.gateJapaneseMaple = Optional.of((Object)((Object)new BlockCustomFenceGate("japanesemaple")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateJapaneseMaple.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_japanesemaple");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateJapaneseMaple.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.JAPANESE_MAPLE.metadata())));
        }
    }
    ,
    RAINBOWEUCALYPTUSGATE(Stuff.gateRainbowEucalyptus, true){

        @Override
        protected void create() {
            Stuff.gateRainbowEucalyptus = Optional.of((Object)((Object)new BlockCustomFenceGate("rainboweucalyptus")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateRainbowEucalyptus.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_rainboweucalyptus");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateRainbowEucalyptus.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.RAINBOW_EUCALYPTUS.metadata())));
        }
    }
    ,
    REDWOODGATE(Stuff.gateRedwood, true){

        @Override
        protected void create() {
            Stuff.gateRedwood = Optional.of((Object)((Object)new BlockCustomFenceGate("redwood")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateRedwood.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_redwood");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateRedwood.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.REDWOOD.metadata())));
        }
    }
    ,
    SAKURAGATE(Stuff.gateSakura, true){

        @Override
        protected void create() {
            Stuff.gateSakura = Optional.of((Object)((Object)new BlockCustomFenceGate("sakura")));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMGATE;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.gateSakura.get();
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, "fencegate_sakura");
            Extrabiomes.postInitEvent(new BlockActiveEvent.FenceGateActiveEvent(new ItemStack((Block)Stuff.gateSakura.get(), 1), new ItemStack((Block)Stuff.planks.get(), 1, BlockCustomWood.BlockType.SAKURA_BLOSSOM.metadata())));
        }
    };

    private boolean blockCreated = false;
    private Block _block = null;
    private boolean _flammable = false;
    private Optional _stuff = null;

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (!block.getSettings().getEnabled()) continue;
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
            if (!block._flammable || !block._stuff.isPresent()) continue;
            try {
                block._block = (Block)block._stuff.get();
                Blocks.field_150480_ab.setFireInfo(block._block, 5, 20);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LogHelper.severe("Unable to set " + (Object)((Object)block) + " flammable", e);
                block._flammable = false;
            }
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
        BlockCustomWoodDoor.setRenderId(Extrabiomes.proxy.registerBlockHandler(new CustomDoorRender()));
    }

    private BlockManager(Optional stuff, boolean flammable) {
        this._stuff = stuff;
        this._flammable = flammable;
    }

    protected abstract BlockSettings getSettings();

    protected abstract void create();

    protected abstract void prepare();
}

