/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.fabrica.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.BlockSettings;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockCustomWoodSlab
extends BlockWoodSlab {
    private BlockSettings settings;
    private static Block singleSlab = null;
    private IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null};

    public BlockCustomWoodSlab(BlockSettings settings, boolean isDouble) {
        super(isDouble);
        if (!isDouble) {
            singleSlab = this;
        }
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149713_g(0);
        this.func_149647_a(Extrabiomes.tabsEBXL);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures[0] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksredwood");
        this.textures[1] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksfir");
        this.textures[2] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksacacia");
        this.textures[3] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "plankscypress");
        this.textures[4] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksjapanesemaple");
        this.textures[5] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksrainboweucalyptus");
        this.textures[6] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksautumn");
        this.textures[7] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planksbaldcypress");
    }

    protected ItemStack func_149644_j(int damage) {
        return new ItemStack(singleSlab, 2, damage & 7);
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.textures[metadata & 7];
    }

    public String func_150002_b(int metadata) {
        String woodType;
        switch (metadata & 7) {
            case 1: {
                woodType = BlockType.FIR.toString();
                break;
            }
            case 2: {
                woodType = BlockType.ACACIA.toString();
                break;
            }
            case 3: {
                woodType = BlockType.CYPRESS.toString();
                break;
            }
            case 4: {
                woodType = BlockType.JAPANESE_MAPLE.toString();
                break;
            }
            case 5: {
                woodType = BlockType.RAINBOW_EUCALYPTUS.toString();
                break;
            }
            case 6: {
                woodType = BlockType.AUTUMN.toString();
                break;
            }
            case 7: {
                woodType = BlockType.BALD_CYPRESS.toString();
                break;
            }
            default: {
                woodType = BlockType.REDWOOD.toString();
            }
        }
        return super.func_149739_a() + "." + woodType;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List itemList) {
        if (this == singleSlab) {
            for (BlockType type : BlockType.values()) {
                itemList.add(new ItemStack(item, 1, type.metadata()));
            }
        }
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return ItemBlock.func_150898_a((Block)singleSlab);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    public static enum BlockType {
        REDWOOD(0),
        FIR(1),
        ACACIA(2),
        CYPRESS(3),
        JAPANESE_MAPLE(4),
        RAINBOW_EUCALYPTUS(5),
        AUTUMN(6),
        BALD_CYPRESS(7);

        private final int metadata;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

