/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.cautia.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BlockSettings;
import extrabiomes.module.cautia.block.BlockQuicksand;
import extrabiomes.module.cautia.worldgen.QuicksandGenerator;
import extrabiomes.proxy.CommonProxy;
import net.minecraft.block.Block;

public enum BlockManager {
    QUICKSAND{

        @Override
        protected void create() {
            Stuff.quickSand = Optional.of((Object)((Object)new BlockQuicksand()));
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.quickSand.get();
            thisBlock.func_149663_c("extrabiomes.quicksand");
            proxy.setBlockHarvestLevel(thisBlock, "shovel", 0);
            proxy.registerBlock(thisBlock, "quicksand");
            proxy.registerWorldGenerator(new QuicksandGenerator(thisBlock));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.QUICKSAND;
        }
    };

    private boolean blockCreated = false;

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (!block.getSettings().getEnabled()) {
                LogHelper.fine("Skipping registration of disabled block " + (Object)((Object)block), new Object[0]);
                continue;
            }
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
    }

    protected abstract void create();

    protected abstract BlockSettings getSettings();

    protected abstract void prepare();
}

