/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.newdawn;

import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.amica.newdawn.NewDawnPluginImpl;
import extrabiomes.module.amica.newdawn.NewDawnSettings;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;

public class EBXLDampSelector
extends NewDawnBiomeSelector {
    protected static final NewDawnBiome biomeExtremeJungle = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.EXTREMEJUNGLE);
    protected static final NewDawnBiome biomeGreenHills = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.GREENHILLS);
    protected static final NewDawnBiome biomeGreenSwamp = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.GREENSWAMP);
    protected static final NewDawnBiome biomeMiniJungle = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.MINIJUNGLE);
    protected static final NewDawnBiome biomeRainforest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.RAINFOREST);
    protected static final NewDawnBiome biomeRedwoodForest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.REDWOODFOREST);
    protected static final NewDawnBiome biomeRedwoodLush = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.REDWOODLUSH);
    protected static final NewDawnBiome biomeSnowRainforest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.SNOWYRAINFOREST);
    protected static final NewDawnBiome biomeTemperateRainforest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.TEMPORATERAINFOREST);
    protected NoiseStretch stretchExtremeJungle;
    protected NoiseStretch stretchGreen;
    protected NoiseStretch stretchMiniJungle;
    protected NoiseStretch stretchRainforest;
    protected NoiseStretch stretchRedwood;

    public EBXLDampSelector(SimplexNoise worldNoise, int priority) {
        super(worldNoise, priority);
        this.stretchMiniJungle = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.MINI_JUNGLE.getStretchSize(), worldNoise);
        this.stretchExtremeJungle = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.EXTREME_JUNGLE.getStretchSize(), worldNoise);
        this.stretchRedwood = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.REDWOOD.getStretchSize(), worldNoise);
        this.stretchGreen = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.GREEN.getStretchSize(), worldNoise);
        this.stretchRainforest = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.RAINFOREST.getStretchSize(), worldNoise);
    }

    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        boolean isLush;
        if (chunkInfo.isBelowGroundLevel(blockX, blockZ) || !chunkInfo.isHumidityWet(blockX, blockZ)) {
            return null;
        }
        boolean isMountain = chunkInfo.isMountain(blockX, blockZ);
        boolean isCold = chunkInfo.isTemperatureFreezing(blockX, blockZ);
        boolean isTemperate = chunkInfo.isTemperatureMedium(blockX, blockZ);
        boolean bl = isLush = (double)chunkInfo.getAverageHumidity() > 0.75;
        if (isMountain) {
            if (this.stretchExtremeJungle.getNoise((double)blockX, (double)blockZ) > 0.0) {
                return biomeExtremeJungle;
            }
        } else {
            if (this.stretchGreen.getNoise((double)blockX, (double)blockZ) > 0.0) {
                if (chunkInfo.isGroundLevelOrShallowWater(blockX, blockZ)) {
                    return biomeGreenSwamp;
                }
                return biomeGreenHills;
            }
            if (this.stretchRedwood.getNoise((double)blockX, (double)blockZ) > 0.0) {
                if (isLush) {
                    return biomeRedwoodLush;
                }
                return biomeRedwoodForest;
            }
            if (isLush) {
                if (this.stretchMiniJungle.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeMiniJungle;
                }
                if (this.stretchRainforest.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    if (isCold) {
                        return biomeSnowRainforest;
                    }
                    if (isTemperate) {
                        return biomeTemperateRainforest;
                    }
                    return biomeRainforest;
                }
            }
        }
        return null;
    }
}

