/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.newdawn;

import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.amica.newdawn.NewDawnPluginImpl;
import extrabiomes.module.amica.newdawn.NewDawnSettings;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;

public class EBXLAridSelector
extends NewDawnBiomeSelector {
    protected static final NewDawnBiome biomeAlpine = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.ALPINE);
    protected static final NewDawnBiome biomeGlacier = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.GLACIER);
    protected static final NewDawnBiome biomeMountainDesert = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.MOUNTAINDESERT);
    protected static final NewDawnBiome biomeMountainRidge = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.MOUNTAINRIDGE);
    protected static final NewDawnBiome biomeSavanna = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.SAVANNA);
    protected static final NewDawnBiome biomeTundra = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.TUNDRA);
    protected static final NewDawnBiome biomeWasteland = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.WASTELAND);
    protected static final NewDawnBiome biomeIceWasteland = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.ICEWASTELAND);
    protected NoiseStretch stretchAlpine;
    protected NoiseStretch stretchGlacier;
    protected NoiseStretch stretchMountain;
    protected NoiseStretch stretchSavanna;
    protected NoiseStretch stretchTundra;
    protected NoiseStretch stretchWasteland;

    public EBXLAridSelector(SimplexNoise worldNoise, int priority) {
        super(worldNoise, priority);
        this.stretchGlacier = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.GLACIER.getStretchSize(), worldNoise);
        this.stretchAlpine = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.ALPINE.getStretchSize(), worldNoise);
        this.stretchMountain = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.MOUNTAIN.getStretchSize(), worldNoise);
        this.stretchWasteland = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.WASTELAND.getStretchSize(), worldNoise);
        this.stretchSavanna = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.SAVANNA.getStretchSize(), worldNoise);
        this.stretchTundra = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.TUNDRA.getStretchSize(), worldNoise);
    }

    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (chunkInfo.isBelowGroundLevel(blockX, blockZ) || !chunkInfo.isHumiditySparse(blockX, blockZ)) {
            return null;
        }
        boolean isMountain = chunkInfo.isMountain(blockX, blockZ);
        boolean isFrigid = (double)chunkInfo.getAverageTemperature() < 0.25;
        boolean isCold = chunkInfo.isTemperatureFreezing(blockX, blockZ);
        if (isCold) {
            if (isMountain) {
                if (this.stretchAlpine.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeAlpine;
                }
                if (isFrigid && this.stretchGlacier.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeGlacier;
                }
            } else {
                if (this.stretchTundra.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeTundra;
                }
                if (this.stretchWasteland.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeIceWasteland;
                }
            }
        } else if (isMountain) {
            double noise = this.stretchMountain.getNoise((double)blockX, (double)blockZ);
            if (noise > 0.5) {
                return biomeMountainDesert;
            }
            if (noise > 0.0) {
                return biomeMountainRidge;
            }
        } else {
            if (this.stretchSavanna.getNoise((double)blockX, (double)blockZ) > 0.0) {
                return biomeSavanna;
            }
            if (this.stretchWasteland.getNoise((double)blockX, (double)blockZ) > 0.0) {
                return biomeWasteland;
            }
        }
        return null;
    }
}

