/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.forestry;

import com.google.common.base.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import extrabiomes.Extrabiomes;
import extrabiomes.api.PluginEvent;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockNewSapling;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ForestryPlugin {
    private Object fermenterManager;
    private Object carpenterManager;
    private static boolean enabled = true;
    private ArrayList plainFlowers;
    private ArrayList leafBlockIds;
    private ArrayList[] backpackItems;
    private Optional<Method> carpenterAddRecipe = Optional.absent();
    private Optional<Method> fermenterAddRecipe = Optional.absent();
    private Optional<Method> getForestryItem = Optional.absent();
    private static Optional<Method> getForestryBlock = Optional.absent();
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;
    private static final int BIOMASS_SAPLINGS = 250;

    static ItemStack getBlock(String name) {
        try {
            return (ItemStack)((Method)getForestryBlock.get()).invoke(null, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addBackPackItems() {
        Collection<ItemStack> items = ForestryModHelper.getForesterBackPackItems();
        for (ItemStack item : items) {
            this.backpackItems[2].add(item);
        }
        items = ForestryModHelper.getDiggerBackPackItems();
        for (ItemStack item : items) {
            this.backpackItems[1].add(item);
        }
        if (Stuff.quickSand.isPresent()) {
            this.backpackItems[1].add(new ItemStack((Block)Stuff.quickSand.get()));
        }
    }

    private void addBasicFlowers() {
        for (ItemStack flower : ForestryModHelper.getBasicFlowers()) {
            this.plainFlowers.add(flower);
        }
    }

    private void addFermenterRecipeSapling(ItemStack resource) throws Exception {
        for (String type : new String[]{"water", "biomass", "honey", "juice"}) {
            if (FluidRegistry.isFluidRegistered((String)type)) continue;
            LogHelper.warning("Unable to find fluid named '%s' when adding Forestry fermenter recipes.", type);
            return;
        }
        try {
            ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 250, Float.valueOf(1.0f), this.getFluidStack("biomass"), this.getFluidStack("water"));
            ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 250, Float.valueOf(1.5f), this.getFluidStack("biomass"), this.getFluidStack("juice"));
            ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 250, Float.valueOf(1.5f), this.getFluidStack("biomass"), this.getFluidStack("honey"));
        }
        catch (Exception e) {
            LogHelper.severe("The forestry API changed in reguards to fluids/liquids.", new Object[0]);
        }
    }

    private void addGlobals() {
        Collection<ItemStack> items = ForestryModHelper.getLeaves();
        for (ItemStack itemStack : items) {
        }
    }

    private void addRecipes() throws Exception {
        if (this.fermenterAddRecipe.isPresent() && this.getForestryItem.isPresent()) {
            for (ItemStack sapling : ForestryModHelper.getSaplings()) {
                this.addFermenterRecipeSapling(sapling);
            }
        }
        if (this.carpenterAddRecipe.isPresent() && Element.RED_COBBLE.isPresent()) {
            ((Method)this.carpenterAddRecipe.get()).invoke(this.carpenterManager, 10, this.getFluidStack("water", 3000), null, new ItemStack(Items.field_151119_aD, 4), new Object[]{"#", Character.valueOf('#'), Element.RED_COBBLE.get()});
        }
    }

    private void addSaplings() {
        Optional soil = Optional.fromNullable((Object)ForestryPlugin.getBlock("soil"));
        if (soil.isPresent()) {
            Block soilBlock = Block.func_149634_a((Item)((ItemStack)soil.get()).func_77973_b());
            TreeSoilRegistry.addValidSoil(soilBlock);
            BlockCustomSapling.setForestrySoil(soilBlock);
            BlockNewSapling.setForestrySoil(soilBlock);
        }
        for (ItemStack sapling : ForestryModHelper.getSaplings()) {
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.%s", sapling.func_77977_a(), sapling.func_77960_j()));
        }
    }

    private FluidStack getFluidStack(String name) throws Exception {
        return this.getFluidStack(name, 1000);
    }

    private FluidStack getFluidStack(String name, int ammount) throws Exception {
        return FluidRegistry.getFluidStack((String)name, (int)ammount);
    }

    @SubscribeEvent
    public void init(PluginEvent.Init event) throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.addSaplings();
        this.addBasicFlowers();
        this.addGlobals();
        this.addBackPackItems();
        this.addRecipes();
    }

    private boolean isEnabled() {
        return enabled && Extrabiomes.proxy.isModLoaded("Forestry");
    }

    @SubscribeEvent
    public void preInit(PluginEvent.Pre event) {
        if (!this.isEnabled()) {
            return;
        }
        LogHelper.fine("Initializing %s plugin.", "Forestry");
        try {
            Class<?> cls = Class.forName("forestry.api.core.ItemInterface");
            this.getForestryItem = Optional.fromNullable((Object)cls.getMethod("getItem", String.class));
            cls = Class.forName("forestry.api.core.BlockInterface");
            getForestryBlock = Optional.fromNullable((Object)cls.getMethod("getBlock", String.class));
            cls = Class.forName("forestry.api.recipes.RecipeManagers");
            Field fld = cls.getField("fermenterManager");
            this.fermenterManager = fld.get(null);
            fld = cls.getField("carpenterManager");
            this.carpenterManager = fld.get(null);
            cls = Class.forName("forestry.api.apiculture.FlowerManager");
            fld = cls.getField("plainFlowers");
            this.plainFlowers = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.storage.BackpackManager");
            fld = cls.getField("backpackItems");
            this.backpackItems = (ArrayList[])fld.get(null);
            cls = Class.forName("forestry.api.recipes.IFermenterManager");
            this.fermenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", ItemStack.class, Integer.TYPE, Float.TYPE, FluidStack.class, FluidStack.class));
            cls = Class.forName("forestry.api.recipes.ICarpenterManager");
            this.carpenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", Integer.TYPE, FluidStack.class, ItemStack.class, ItemStack.class, Object[].class));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogHelper.fine("Could not communicate with %s. Disabling plugin.", "Forestry");
            enabled = false;
        }
    }
}

