/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.lib;

import com.google.common.base.Optional;
import extrabiomes.helpers.LogHelper;
import extrabiomes.module.summa.biome.BiomeAlpine;
import extrabiomes.module.summa.biome.BiomeAutumnWoods;
import extrabiomes.module.summa.biome.BiomeBirchForest;
import extrabiomes.module.summa.biome.BiomeExtremeJungle;
import extrabiomes.module.summa.biome.BiomeForestedHills;
import extrabiomes.module.summa.biome.BiomeForestedIsland;
import extrabiomes.module.summa.biome.BiomeGlacier;
import extrabiomes.module.summa.biome.BiomeGreenHills;
import extrabiomes.module.summa.biome.BiomeGreenSwamp;
import extrabiomes.module.summa.biome.BiomeIceWasteland;
import extrabiomes.module.summa.biome.BiomeMarsh;
import extrabiomes.module.summa.biome.BiomeMeadow;
import extrabiomes.module.summa.biome.BiomeMiniJungle;
import extrabiomes.module.summa.biome.BiomeMountainDesert;
import extrabiomes.module.summa.biome.BiomeMountainRidge;
import extrabiomes.module.summa.biome.BiomeMountainTaiga;
import extrabiomes.module.summa.biome.BiomePineForest;
import extrabiomes.module.summa.biome.BiomeRainforest;
import extrabiomes.module.summa.biome.BiomeRedwoodForest;
import extrabiomes.module.summa.biome.BiomeRedwoodLush;
import extrabiomes.module.summa.biome.BiomeSavanna;
import extrabiomes.module.summa.biome.BiomeShrubland;
import extrabiomes.module.summa.biome.BiomeSnowForest;
import extrabiomes.module.summa.biome.BiomeSnowRainforest;
import extrabiomes.module.summa.biome.BiomeTemporateRainforest;
import extrabiomes.module.summa.biome.BiomeTundra;
import extrabiomes.module.summa.biome.BiomeWasteland;
import extrabiomes.module.summa.biome.BiomeWoodlands;
import extrabiomes.module.summa.biome.ExtrabiomeGenBase;
import extrabiomes.utility.EnhancedConfiguration;
import java.util.Locale;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.config.Property;

public enum BiomeSettings {
    DESERT,
    EXTREMEHILLS,
    FOREST,
    JUNGLE,
    PLAINS,
    SWAMPLAND,
    TAIGA,
    OCEAN,
    ALPINE(60, BiomeAlpine.class),
    AUTUMNWOODS(61, BiomeAutumnWoods.class),
    BIRCHFOREST(62, BiomeBirchForest.class),
    EXTREMEJUNGLE(63, BiomeExtremeJungle.class),
    FORESTEDHILLS(64, BiomeForestedHills.class),
    FORESTEDISLAND(65, BiomeForestedIsland.class),
    GLACIER(66, BiomeGlacier.class, Weights.LIGHT),
    GREENHILLS(67, BiomeGreenHills.class, Weights.HEAVY),
    GREENSWAMP(40, BiomeGreenSwamp.class, Weights.HEAVY),
    ICEWASTELAND(41, BiomeIceWasteland.class),
    MARSH(-1, BiomeMarsh.class, false),
    MEADOW(43, BiomeMeadow.class, Weights.HEAVY),
    MINIJUNGLE(44, BiomeMiniJungle.class, Weights.LIGHT),
    MOUNTAINDESERT(45, BiomeMountainDesert.class),
    MOUNTAINRIDGE(46, BiomeMountainRidge.class),
    MOUNTAINTAIGA(47, BiomeMountainTaiga.class),
    PINEFOREST(48, BiomePineForest.class),
    RAINFOREST(49, BiomeRainforest.class),
    REDWOODFOREST(50, BiomeRedwoodForest.class),
    REDWOODLUSH(51, BiomeRedwoodLush.class),
    SAVANNA(52, BiomeSavanna.class),
    SHRUBLAND(53, BiomeShrubland.class),
    SNOWYFOREST(54, BiomeSnowForest.class),
    SNOWYRAINFOREST(55, BiomeSnowRainforest.class),
    TEMPORATERAINFOREST(56, BiomeTemporateRainforest.class),
    TUNDRA(57, BiomeTundra.class),
    WASTELAND(58, BiomeWasteland.class, Weights.LIGHT),
    WOODLANDS(59, BiomeWoodlands.class, Weights.HEAVY);

    private final int defaultID;
    private int biomeID = 0;
    private int weight;
    private boolean enabled;
    private boolean allowVillages;
    private final Optional<? extends Class<? extends BiomeGenBase>> biomeClass;
    private Optional<? extends BiomeGenBase> biome;

    private BiomeSettings() {
        this(0, null);
    }

    private BiomeSettings(int defaultID, Class<? extends BiomeGenBase> biomeClass) {
        this.weight = Weights.NORMAL.value;
        this.enabled = true;
        this.allowVillages = true;
        this.biome = Optional.absent();
        this.biomeID = this.defaultID = defaultID;
        this.biomeClass = Optional.fromNullable(biomeClass);
    }

    private BiomeSettings(int defaultID, Class<? extends BiomeGenBase> biomeClass, Weights defaultWeight) {
        this(defaultID, biomeClass);
        this.weight = defaultWeight.value;
    }

    private BiomeSettings(int defaultID, Class<? extends BiomeGenBase> biomeClass, boolean defaultGen) {
        this(defaultID, biomeClass);
        this.enabled = defaultGen;
        if (!this.enabled) {
            this.weight = Weights.NONE.value;
        }
    }

    public static BiomeSettings findBiomeSettings(int id) {
        for (BiomeSettings settings : BiomeSettings.values()) {
            if (settings.biomeID != id) continue;
            return settings;
        }
        return null;
    }

    public boolean allowVillages() {
        return this.allowVillages;
    }

    public void createBiome() throws Exception {
        if (this.biomeClass.isPresent() && !this.biome.isPresent()) {
            this.biome = Optional.of(((Class)this.biomeClass.get()).newInstance());
        }
    }

    public void postLoad() {
        if (!this.isVanilla() && this.biome.isPresent()) {
            ExtrabiomeGenBase egb = (ExtrabiomeGenBase)((Object)this.biome.get());
            BiomeDictionary.registerBiomeType((BiomeGenBase)egb, (BiomeDictionary.Type[])egb.getBiomeTypeFlags());
            LogHelper.fine("registering " + this.name() + " with dictionary", new Object[0]);
            BiomeManager.BiomeEntry entry = new BiomeManager.BiomeEntry((BiomeGenBase)egb, this.weight);
            if (egb.field_76750_F > 0.5f) {
                if (egb.func_76736_e()) {
                    BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)entry);
                } else {
                    BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)entry);
                }
            } else if (egb.func_76746_c()) {
                BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)entry);
            } else {
                BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)entry);
            }
        } else {
            LogHelper.fine("NOT registering " + this.name() + " with dictionary, biome = " + this.biome, new Object[0]);
        }
    }

    public Optional<? extends BiomeGenBase> getBiome() {
        return this.biome;
    }

    public int getID() {
        return this.biomeID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVanilla() {
        return !this.biomeClass.isPresent();
    }

    private String keyWeight() {
        return this.keyVanillaPrefix() + this.toString() + ".weight";
    }

    private String keyAllowVillages() {
        return this.keyVanillaPrefix() + this.toString() + ".allowvillages";
    }

    private String keyEnabled() {
        return this.keyVanillaPrefix() + this.toString() + ".enablegeneration";
    }

    private String keyID() {
        return this.toString() + ".id";
    }

    private String keyVanillaPrefix() {
        return this.isVanilla() ? "vanilla." : "";
    }

    public void load(EnhancedConfiguration configuration) {
        Property property;
        if (!this.isVanilla()) {
            property = configuration.getBiome(this.keyID(), this.biomeID);
            this.biomeID = property.getInt(0);
        }
        property = configuration.get("biome", this.keyEnabled(), this.enabled);
        if (!this.isVanilla() && this.biomeID < 1) {
            property.set(Boolean.toString(false));
        }
        this.enabled = property.getBoolean(false);
        if (!this.isVanilla() && this.biomeID > -1) {
            property = configuration.get("biome", this.keyWeight(), this.weight);
            this.weight = property.getInt(Weights.NONE.value);
        }
        if (this.enabled) {
            property = configuration.get("biome", this.keyAllowVillages(), this.allowVillages);
            if (!this.isVanilla() && this.biomeID < 1) {
                property.set(Boolean.toString(false));
            }
            this.allowVillages = property.getBoolean(false);
        }
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        BiomeSettings.EXTREMEJUNGLE.allowVillages = false;
        BiomeSettings.GLACIER.allowVillages = false;
        BiomeSettings.RAINFOREST.allowVillages = false;
        BiomeSettings.REDWOODFOREST.allowVillages = false;
        BiomeSettings.REDWOODLUSH.allowVillages = false;
        BiomeSettings.SNOWYRAINFOREST.allowVillages = false;
        BiomeSettings.TEMPORATERAINFOREST.allowVillages = false;
    }

    private static enum Weights {
        NONE(0),
        LIGHT(5),
        NORMAL(10),
        HEAVY(20);

        public int value;

        private Weights(int value) {
            this.value = value;
        }
    }
}

