/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToolTipStringFormatter {
    private static String defaultColorVal = "7";
    private static String colorVal = "7";
    private static boolean obfuscated = false;
    private static boolean bold = false;
    private static boolean strikethrough = false;
    private static boolean underline = false;
    private static boolean italic = false;
    private static String unicodeControlCode = "\u00a7";
    private static Pattern controlCode = Pattern.compile("\\\\");
    private static Pattern codes = Pattern.compile("\\\\.");
    private static Pattern resetCode = Pattern.compile("\\\\r");
    private static Pattern codesGood = Pattern.compile("\\\\[0123456789abcdefklmnor]");
    private static Pattern codesBad = Pattern.compile("\\\\[^0123456789abcdefklmnor]");
    private static Pattern codeObf = Pattern.compile("\\\\k");
    private static Pattern codeBold = Pattern.compile("\\\\l");
    private static Pattern codeStrike = Pattern.compile("\\\\m");
    private static Pattern codeUnder = Pattern.compile("\\\\n");
    private static Pattern codeItilic = Pattern.compile("\\\\o");
    private static Pattern codeReset = Pattern.compile("\\\\r");

    public static List Format(String text) {
        ArrayList tmp = new ArrayList();
        ToolTipStringFormatter.Format(text, tmp);
        return tmp;
    }

    public static void Format(String text, List lines) {
        ToolTipStringFormatter.Format(text, lines, 20);
    }

    public static void Format(String text, List lines, int targetLength) {
        String format = "7";
        if (text.length() > 0 && text.charAt(0) == '\\') {
            format = String.valueOf(text.charAt(1));
            text = text.substring(2);
        }
        ToolTipStringFormatter.Format(text, lines, targetLength, format);
    }

    public static void Format(String text, List lines, String color) {
        ToolTipStringFormatter.Format(text, lines, 20, color);
    }

    public static void Format(String text, List lines, int targetLength, String color) {
        String[] wordArray = text.split(" ");
        int words = wordArray.length;
        int curLineLength = 0;
        int wordLength = 0;
        int maxLength = targetLength + 5;
        String curLine = "";
        defaultColorVal = colorVal = color;
        for (int word = 0; word < words; ++word) {
            wordLength = ToolTipStringFormatter.WordLength(wordArray[word]);
            if (curLineLength == 0) {
                curLine = ToolTipStringFormatter.LineFormatHeader() + ToolTipStringFormatter.ParseTags(wordArray[word]);
                curLineLength = wordLength;
                continue;
            }
            if (curLineLength >= targetLength || curLineLength + wordLength >= maxLength) {
                lines.add(curLine);
                curLine = ToolTipStringFormatter.LineFormatHeader() + ToolTipStringFormatter.ParseTags(wordArray[word]);
                curLineLength = wordLength;
                continue;
            }
            curLine = curLine + " " + ToolTipStringFormatter.ParseTags(wordArray[word]);
            curLineLength += 1 + wordLength;
        }
        if (curLineLength > 0) {
            lines.add(curLine + unicodeControlCode + "r");
        }
    }

    private static int WordLength(String word) {
        return codes.matcher(word).replaceAll("").length();
    }

    private static String LineFormatHeader() {
        String tmp = unicodeControlCode + colorVal;
        if (obfuscated) {
            tmp = tmp + unicodeControlCode + "k";
        }
        if (bold) {
            tmp = tmp + unicodeControlCode + "l";
        }
        if (strikethrough) {
            tmp = tmp + unicodeControlCode + "m";
        }
        if (underline) {
            tmp = tmp + unicodeControlCode + "n";
        }
        if (italic) {
            tmp = tmp + unicodeControlCode + "o";
        }
        return tmp;
    }

    private static String ParseTags(String word) {
        word = codesBad.matcher(word).replaceAll("");
        Matcher matcher = codesGood.matcher(word);
        block7: while (matcher.find()) {
            char code = word.charAt(matcher.end() - 1);
            if (code > 'j') {
                switch (code) {
                    case 'k': {
                        obfuscated = true;
                        continue block7;
                    }
                    case 'l': {
                        bold = true;
                        continue block7;
                    }
                    case 'm': {
                        strikethrough = true;
                        continue block7;
                    }
                    case 'n': {
                        underline = true;
                        continue block7;
                    }
                    case 'o': {
                        italic = true;
                        continue block7;
                    }
                }
                colorVal = defaultColorVal;
                obfuscated = false;
                bold = false;
                strikethrough = false;
                underline = false;
                italic = false;
                continue;
            }
            colorVal = String.valueOf(code);
        }
        word = resetCode.matcher(word).replaceAll(unicodeControlCode + "r" + unicodeControlCode + defaultColorVal);
        return controlCode.matcher(word).replaceAll(unicodeControlCode);
    }
}

