/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.helpers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.Event;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.DiscoverWorldTypesEvent;
import extrabiomes.lib.BiomeSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeManager;

public abstract class BiomeHelper {
    private static final Set<WorldType> worldTypes = new HashSet<WorldType>();
    private static Optional<? extends ArrayList<BiomeGenBase>> activeBiomes = Optional.absent();

    public static void addTerrainBlockstoBiome(BiomeSettings biome, Block topBlock, Block fillerBlock) {
        if (!biome.getBiome().isPresent()) {
            return;
        }
        BiomeGenBase baseBiome = (BiomeGenBase)biome.getBiome().get();
        baseBiome.field_76752_A = topBlock;
        baseBiome.field_76753_B = fillerBlock;
    }

    public static void createBiome(BiomeSettings setting) throws Exception {
        if (BiomeGenBase.func_150565_n()[setting.getID()] != null) {
            throw new IllegalArgumentException(String.format("Biome id %d is already in use by %s when adding %s. Please review the configuration file.", setting.getID(), BiomeGenBase.func_150565_n()[setting.getID()].field_76791_y, setting.toString()));
        }
        setting.createBiome();
    }

    public static Set<WorldType> discoverWorldTypes() {
        if (worldTypes.isEmpty()) {
            worldTypes.add(WorldType.field_77137_b);
            worldTypes.add(WorldType.field_77135_d);
            DiscoverWorldTypesEvent event = new DiscoverWorldTypesEvent(worldTypes);
            Api.getExtrabiomesXLEventBus().post((Event)event);
        }
        return ImmutableSet.copyOf(worldTypes);
    }

    public static void enableBiome(Set<WorldType> worldTypes, BiomeGenBase biome) {
        Extrabiomes.proxy.addBiome(worldTypes, biome);
        BiomeManager.addSpawnBiome((BiomeGenBase)biome);
        BiomeManager.addStrongholdBiome((BiomeGenBase)biome);
    }

    public static Collection<BiomeGenBase> getActiveBiomes() {
        if (!activeBiomes.isPresent()) {
            activeBiomes = Optional.of(new ArrayList(BiomeSettings.values().length));
            for (BiomeSettings setting : BiomeSettings.values()) {
                if (!setting.getBiome().isPresent() || setting.isVanilla()) continue;
                ((ArrayList)activeBiomes.get()).add(setting.getBiome().get());
            }
            ((ArrayList)activeBiomes.get()).trimToSize();
        }
        return ImmutableSet.copyOf((Collection)((Collection)activeBiomes.get()));
    }

    public static BiomeGenBase settingToBiomeGenBase(BiomeSettings setting) {
        switch (setting) {
            case DESERT: {
                return BiomeGenBase.field_76769_d;
            }
            case EXTREMEHILLS: {
                return BiomeGenBase.field_76770_e;
            }
            case FOREST: {
                return BiomeGenBase.field_76767_f;
            }
            case JUNGLE: {
                return BiomeGenBase.field_76782_w;
            }
            case SWAMPLAND: {
                return BiomeGenBase.field_76780_h;
            }
            case TAIGA: {
                return BiomeGenBase.field_76768_g;
            }
            case PLAINS: {
                return BiomeGenBase.field_76772_c;
            }
            case OCEAN: {
                return BiomeGenBase.field_76771_b;
            }
        }
        if (setting.getBiome().isPresent()) {
            return (BiomeGenBase)setting.getBiome().get();
        }
        return null;
    }

    public static void addWeightedGrassGen(Optional<? extends BiomeGenBase> biome, WorldGenerator grassGen, int weight) {
        if (!biome.isPresent()) {
            return;
        }
        extrabiomes.api.BiomeManager.addWeightedGrassGenForBiome((BiomeGenBase)biome.get(), grassGen, weight);
    }
}

