/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.handlers.GenesisBiomeOverrideHandler;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.GenesisChunkProvider;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.tuple.Pair;

public class BlockMachine
extends Block {
    static boolean doingGenesis = false;

    public BlockMachine() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        System.out.println("Registering IIcon for " + ((Object)((Object)this)).getClass().getName());
        this.field_149761_L = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "genesis");
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.field_149761_L;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!doingGenesis && !world.field_72995_K && this.canDoGenesis(world, x, y, z, 3, player)) {
            doingGenesis = true;
            this.doGenesis(world, x, y, z, 3, player);
            doingGenesis = false;
        }
        return false;
    }

    public boolean canDoGenesis(World world, int x, int y, int z, int range, EntityPlayer sender) {
        if (sender.field_71093_bK != 0) {
            return false;
        }
        Integer chunkX = x >> 4;
        Integer chunkZ = z >> 4;
        for (int x1 = chunkX - range; x1 <= chunkX + range; ++x1) {
            for (int z1 = chunkZ - range; z1 <= chunkZ + range; ++z1) {
                ChunkCoordinates chunkcoordinates = world.func_72861_E();
                int k = x1 * 16 + 8 - chunkcoordinates.field_71574_a;
                int l = z1 * 16 + 8 - chunkcoordinates.field_71573_c;
                int short1 = 128;
                if (k < -short1 || k > short1 || l < -short1 || l > short1) continue;
                return false;
            }
        }
        return true;
    }

    public void doGenesis(World world, int x, int y, int z, int range, EntityPlayer sender) {
        int x1;
        WorldServer worldObj;
        LogHelper.info("Starting genesis at " + x + "," + z, new Object[0]);
        BiomeSettings[] biomes = BiomeSettings.values();
        BiomeGenBase oldBiome = world.func_72807_a(x, z);
        BiomeGenBase newBiome = null;
        do {
            Optional<? extends BiomeGenBase> opt;
            if (!(opt = biomes[world.field_73012_v.nextInt(biomes.length)].getBiome()).isPresent()) continue;
            newBiome = (BiomeGenBase)opt.get();
        } while (oldBiome == newBiome || newBiome == null);
        LogHelper.info("Old biome was " + oldBiome, new Object[0]);
        LogHelper.info("New biome will be " + newBiome, new Object[0]);
        GenesisBiomeOverrideHandler.enable(newBiome.field_76756_M);
        Integer dimension = null;
        Integer chunkX = sender.func_82114_b().field_71574_a >> 4;
        Integer chunkZ = sender.func_82114_b().field_71573_c >> 4;
        dimension = sender.field_71093_bK;
        if (chunkX == null || chunkZ == null) {
            chunkX = (int)sender.field_70165_t >> 4;
            chunkZ = (int)sender.field_70161_v >> 4;
        }
        if ((worldObj = DimensionManager.getWorld((int)0)) == null) {
            LogHelper.warning("Target dimension 0 is not loaded for genesis?!", new Object[0]);
        }
        ChunkProviderServer providerServer = (ChunkProviderServer)worldObj.func_72863_F();
        GenesisChunkProvider providerGenesis = new GenesisChunkProvider(world, newBiome);
        ArrayList players = new ArrayList();
        HashMap<EntityPlayerMP, Vec3> playerOrigPositions = new HashMap<EntityPlayerMP, Vec3>();
        players.addAll(worldObj.field_73010_i);
        int safePad = 2;
        double safeX = (double)(chunkX - range - 2 << 4) - 8.0;
        double safeZ = (double)(chunkZ - range - 2 << 4) - 8.0;
        LogHelper.info("Safe position = " + safeX + "," + safeZ, new Object[0]);
        HashMap<Pair, Chunk> chunks = new HashMap<Pair, Chunk>();
        for (int x12 = chunkX - range; x12 <= chunkX + range; ++x12) {
            for (int z1 = chunkZ - range; z1 <= chunkZ + range; ++z1) {
                for (EntityPlayerMP player : players) {
                    if (!worldObj.func_73040_p().func_72694_a(player, x12, z1) || playerOrigPositions.containsKey(player)) continue;
                    Vec3 origPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
                    playerOrigPositions.put(player, origPosition);
                    LogHelper.info("Moving player " + player, new Object[0]);
                    player.func_70012_b(safeX, player.field_70163_u, safeZ, 0.0f, 0.0f);
                    worldObj.func_72866_a((Entity)player, true);
                }
                Chunk chunk = world.func_72938_d(x, z);
                chunks.put(Pair.of((Object)x12, (Object)z1), chunk);
                providerServer.func_73241_b(x12, z1);
            }
        }
        int lastloaded = 0;
        while (providerServer.func_73152_e() != lastloaded) {
            lastloaded = providerServer.func_73152_e();
            providerServer.func_73156_b();
            for (Pair coord2 : chunks.keySet()) {
                Chunk chunk = (Chunk)chunks.get(coord2);
                if (chunk == null || !chunk.field_76636_d) continue;
                LogHelper.warning("Failed to unload chunk @ " + coord2, new Object[0]);
            }
        }
        chunks.clear();
        LogHelper.info(providerServer.func_73148_d(), new Object[0]);
        IChunkLoader chunkloader = providerServer.field_73247_e;
        providerServer.field_73247_e = null;
        for (x1 = chunkX - range; x1 <= chunkX + range; ++x1) {
            for (int z1 = chunkZ - range; z1 <= chunkZ + range; ++z1) {
                Chunk chunk = providerServer.func_73158_c(x1, z1);
                byte[] chunkBiomes = chunk.func_76605_m();
                for (int k = 0; k < chunkBiomes.length; ++k) {
                    chunkBiomes[k] = (byte)newBiome.field_76756_M;
                }
                chunk.func_76616_a(chunkBiomes);
                chunk.func_76630_e();
            }
        }
        providerServer.field_73247_e = chunkloader;
        for (x1 = chunkX - range; x1 <= chunkX + range; ++x1) {
            for (int z1 = chunkZ - range; z1 <= chunkZ + range; ++z1) {
            }
        }
        GenesisBiomeOverrideHandler.disable();
        for (EntityPlayerMP player : players) {
            LogHelper.info(player.toString(), new Object[0]);
        }
    }
}

