/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.BiomeSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IShearable;

public class BlockCustomTallGrass
extends BlockFlower
implements IShearable {
    private IIcon[] textures = new IIcon[]{null, null, null, null, null};

    public BlockCustomTallGrass(int index, Material material) {
        super(0);
        float var3 = 0.4f;
        this.func_149676_a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegistry) {
        this.textures[0] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "browngrasstall");
        this.textures[1] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "browngrassshort");
        this.textures[2] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "deadgrassshort");
        this.textures[3] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "deadgrasstall");
        this.textures[4] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "deadgrassyellow");
    }

    protected boolean func_149854_a(Block block) {
        return BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent() && block.equals(((BiomeGenBase)BiomeSettings.MOUNTAINRIDGE.getBiome().get()).field_76752_A) || BiomeSettings.WASTELAND.getBiome().isPresent() && block.equals(((BiomeGenBase)BiomeSettings.WASTELAND.getBiome().get()).field_76752_A) || super.func_149854_a(block);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double temperature = 0.5;
        double hunmidity = 1.0;
        return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int rarity = 8;
        if (metadata == BlockType.DEAD.metadata() || metadata == BlockType.DEAD_TALL.metadata() || metadata == BlockType.DEAD_YELLOW.metadata()) {
            rarity *= 2;
        }
        if (world.field_73012_v.nextInt(rarity) != 0) {
            return ret;
        }
        Optional<ItemStack> item = Extrabiomes.proxy.getGrassSeed(world);
        if (item.isPresent()) {
            ret.add((ItemStack)item.get());
        }
        return ret;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (metadata < 0 || metadata > 4) {
            metadata = 0;
        }
        return this.textures[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (BlockType type : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, type.metadata()));
        }
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        return ret;
    }

    public int func_149679_a(int i, Random rand) {
        return 1 + rand.nextInt(i * 2 + 1);
    }

    public static enum BlockType {
        BROWN(0),
        SHORT_BROWN(1),
        DEAD(2),
        DEAD_TALL(3),
        DEAD_YELLOW(4);

        private final int metadata;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }
    }
}

