/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.helpers.LogHelper;
import extrabiomes.helpers.ToolTipStringFormatter;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.proxy.CommonProxy;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockCustomFlower
extends Block
implements IPlantable {
    public static int NUM_GROUPS = 2;
    public final int group;
    private final Map<Integer, BlockType> groupMap;

    public BlockCustomFlower(int group, Material material) {
        super(material);
        float offset = 0.2f;
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 0.6f, 0.7f);
        this.group = group;
        this.groupMap = Maps.newHashMap();
        CommonProxy proxy = Extrabiomes.proxy;
        for (BlockType type : BlockType.values()) {
            if (type.group != this.group) continue;
            this.groupMap.put(type.metadata, type);
            if (type.weight <= 0) continue;
            proxy.addGrassPlant(this, type.metadata, type.weight);
        }
    }

    public Collection<BlockType> getGroupTypes() {
        return this.groupMap.values();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        LogHelper.fine(((Object)((Object)this)).toString() + ": registerIcons", new Object[0]);
        for (BlockType type : this.groupMap.values()) {
            IIcon IIcon2 = type.registerIcon(iconRegister);
            if (IIcon2 == null) {
                LogHelper.warning("No IIcon found for " + (Object)((Object)type) + " (" + type.group + "," + type.metadata + ")", new Object[0]);
                continue;
            }
            LogHelper.fine(((Object)((Object)this)).toString() + ": " + (Object)((Object)type) + " = " + IIcon2, new Object[0]);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z));
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z));
    }

    private boolean canThisPlantGrowOnThisBlock(Block block) {
        return block.equals(Blocks.field_150349_c) || block.equals(Blocks.field_150346_d) || block.equals(Blocks.field_150458_ak) || block.equals(Blocks.field_150354_m) || BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent() && block.equals(((BiomeGenBase)BiomeSettings.MOUNTAINRIDGE.getBiome().get()).field_76752_A);
    }

    private void checkFlowerChange(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        BlockType type = this.groupMap.get(metadata);
        if (type != null) {
            return type.getIcon();
        }
        return null;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == BlockType.TINY_CACTUS.metadata()) {
            return EnumPlantType.Desert;
        }
        return EnumPlantType.Plains;
    }

    public int func_149645_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == BlockType.TINY_CACTUS.metadata()) {
            return super.func_149633_g(world, x, y, z);
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((double)y + this.field_149756_F), (double)(z + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (BlockType type : this.groupMap.values()) {
            if (this.group == 0 && !(type.metadata() != 0 & type.metadata() != 5)) continue;
            itemList.add(new ItemStack((Block)this, 1, type.metadata()));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.checkFlowerChange(world, x, y, z);
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkFlowerChange(world, x, y, z);
    }

    public void addInformation(int metaData, List listOfLines) {
        String line;
        if (this.groupMap.containsKey(metaData) && !(line = LanguageRegistry.instance().getStringLocalization(this.func_149739_a() + "." + this.groupMap.get(metaData).name().toLowerCase(Locale.ENGLISH) + ".description")).equals(this.func_149739_a() + "." + this.groupMap.get(metaData).name().toLowerCase(Locale.ENGLISH) + ".description")) {
            if (listOfLines.size() > 0 && ((String)listOfLines.get(0)).length() > 20) {
                ToolTipStringFormatter.Format(line, listOfLines, ((String)listOfLines.get(0)).length() + 5);
            } else {
                ToolTipStringFormatter.Format(line, listOfLines);
            }
        }
    }

    public String getUnlocalizedName(int metaData) {
        if (this.groupMap.containsKey(metaData)) {
            return this.func_149739_a() + "." + this.groupMap.get(metaData).name().toLowerCase(Locale.ENGLISH);
        }
        return "";
    }

    public static enum BlockType {
        AUTUMN_SHRUB(0, 0, "autumnshrub", 0, -1, new String[0]),
        HYDRANGEA(0, 1, "hydrangea", 2, 12, new String[0]),
        BUTTERCUP(0, 2, "buttercup", 5, 11, new String[0]),
        LAVENDER(0, 3, "lavender", 5, 5, new String[0]),
        TINY_CACTUS(0, 4, "tinycactus", 5, -1, new String[0]),
        ROOT(0, 5, "root", 0, -1, new String[0]),
        TOADSTOOL(0, 6, "toadstools", 0, -1, new String[0]),
        CALLA_WHITE(0, 7, "calla_white", 5, 7, new String[0]),
        ALLIUM(1, 0, "allium", 3, 13, new String[0]),
        AMARYLLIS_PINK(1, 1, "amaryllis_pink", 3, 9, new String[0]),
        AMARYLLIS_RED(1, 2, "amaryllis_red", 3, 1, new String[0]),
        AMARYLLIS_WHITE(1, 3, "amaryllis_white", 3, 15, new String[0]),
        BACHELORS_BUTTON(1, 4, "bachelorsbutton_blue", 3, 4, new String[0]),
        BELLS_OF_IRELAND(1, 5, "bellsofireland", 3, 10, new String[0]),
        BLUEBELL(1, 6, "bluebell", 3, 12, new String[0]),
        CALLA_BLACK(1, 7, "calla_black", 3, 0, new String[0]),
        DAISY(1, 8, "daisy", 3, 15, new String[0]),
        DANDELION(1, 9, "dandelion", 3, -1, new String[0]),
        GARDENIA(1, 11, "gardenia", 3, 7, new String[0]),
        GERBERA_ORANGE(1, 12, "gerbera_orange", 3, 14, new String[0]),
        GERBERA_PINK(1, 13, "gerbera_pink", 3, 9, new String[0]),
        GERBERA_RED(1, 14, "gerbera_red", 3, 1, new String[0]),
        GERBERA_YELLOW(1, 15, "gerbera_yellow", 3, 11, new String[0]),
        ORIENTAL_PINK_LILY(2, 0, "orientalpinklily", 3, 9, new String[0]),
        IRIS_BLUE(2, 1, "iris_blue", 3, 4, new String[0]),
        IRIS_PURPLE(2, 2, "iris_purple", 3, 5, new String[0]),
        LILY(2, 3, "lily", 3, 13, new String[0]),
        MARSH_MARIGOLD(2, 4, "marshmarigold", 3, 11, new String[0]),
        PANSY(2, 5, "pansy", 3, 11, new String[0]),
        POPPY(2, 6, "poppy", 3, 1, new String[0]),
        REDROVER(2, 7, "redrover", 3, 1, new String[0]),
        SNAPDRAGON(2, 8, "snapdragon", 3, 14, new String[0]),
        TULIP(2, 9, "tulips", 3, 14, new String[0]),
        VIOLET(2, 10, "violet", 3, 5, new String[0]),
        YARROW(2, 11, "yarrow", 3, 11, new String[0]),
        BELLADONNA(2, 12, "belladonna", 3, 4, new String[0]),
        BLUE_POPPY(2, 13, "himalayanbluepoppy", 3, 6, new String[0]);

        private Block block;
        private final int group;
        private final int metadata;
        private final int weight;
        private final String texture;
        private final int color;
        private final String[] toolTipText;
        private IIcon IIcon;

        private BlockType(int group, int metadata, String texture, int weight, int color, String[] toolTip) {
            this.group = group;
            this.metadata = metadata;
            this.texture = texture;
            this.weight = weight;
            this.color = color;
            this.toolTipText = toolTip;
        }

        public int color() {
            return this.color;
        }

        public int group() {
            return this.group;
        }

        public int metadata() {
            return this.metadata;
        }

        public IIcon getIcon() {
            return this.IIcon;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon registerIcon(IIconRegister iconRegister) {
            this.IIcon = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + this.texture);
            return this.IIcon;
        }

        public String[] getToolTipText() {
            return this.toolTipText;
        }

        public Block block() {
            return this.block;
        }

        public void setBlock(Block block) {
            this.block = block;
        }

        public int weight() {
            return this.weight;
        }
    }
}

