/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCustomFence
extends BlockFence {
    private IIcon[] textures;
    private int renderId;

    public BlockCustomFence() {
        super("fence", Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("extrabiomes.fence");
        this.func_149649_H();
        this.func_149647_a(Extrabiomes.tabsEBXL);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[BlockType.values().length];
        for (BlockType blockType : BlockType.values()) {
            blockType.texture = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "planks" + blockType.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public IIcon func_149691_a(int side, int metadata) {
        return BlockType.values()[metadata].texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void setRenderId(int renderId) {
        this.renderId = renderId;
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public boolean func_149826_e(IBlockAccess blockAccess, int x, int y, int z) {
        boolean flag;
        Block block = blockAccess.func_147439_a(x, y, z);
        boolean bl = flag = !(block instanceof BlockFenceGate);
        return block != this && flag ? (block.func_149688_o().func_76218_k() && block.func_149686_d() ? block.func_149688_o() != Material.field_151572_C : false) : true;
    }

    public int func_149692_a(int metaData) {
        if (BlockType.values().length <= metaData) {
            return 0;
        }
        return metaData;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public static enum BlockType {
        Acacia(2),
        Autumn(6),
        Baldcypress(7),
        Cypress(3),
        Fir(1),
        JapaneseMaple(4),
        RainbowEucalyptus(5),
        Redwood(0),
        Sakura(8);

        private final int metadata;
        public IIcon texture = null;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }
    }
}

