/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes;

import com.google.common.base.Optional;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import extrabiomes.Module;
import extrabiomes.PluginManager;
import extrabiomes.biomes.BiomeManagerImpl;
import extrabiomes.events.ModuleEvent;
import extrabiomes.events.ModulePreInitEvent;
import extrabiomes.handlers.BiomeHandler;
import extrabiomes.handlers.BlockHandler;
import extrabiomes.handlers.CanMobSpawnHandler;
import extrabiomes.handlers.ConfigurationHandler;
import extrabiomes.handlers.CropHandler;
import extrabiomes.handlers.EBXLCommandHandler;
import extrabiomes.handlers.ItemHandler;
import extrabiomes.handlers.RecipeHandler;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.module.amica.treecapitator.TreecapitatorPlugin;
import extrabiomes.module.fabrica.recipe.RecipeManager;
import extrabiomes.plugins.ForestryPlugin;
import extrabiomes.plugins.PluginThaumcraft4;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.CreativeTab;
import extrabiomes.utility.EnhancedConfiguration;
import java.io.File;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="ExtrabiomesXL", name="ExtrabiomesXL", version="3.16.2", dependencies="")
public class Extrabiomes {
    @Mod.Instance(value="ExtrabiomesXL")
    public static Extrabiomes instance;
    @SidedProxy(clientSide="extrabiomes.proxy.ClientProxy", serverSide="extrabiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs tabsEBXL;
    public static final String TEXTURE_PATH;
    private static Optional<EventBus> initBus;

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) throws InstantiationException, IllegalAccessException {
        proxy.registerRenderInformation();
        TreecapitatorPlugin.init();
        ForestryPlugin.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        PluginManager.activatePlugins();
        RecipeHandler.init();
        initBus = Optional.absent();
        Module.releaseStaticResources();
        if (PluginThaumcraft4.isEnabled()) {
            try {
                PluginThaumcraft4.postInit();
            }
            catch (Exception e) {
                LogHelper.warning("ExtrabiomesXL's Thaumcraft API implementaion is most likely out of date. Fell free to let us know.", new Object[0]);
            }
        }
        if (ForestryPlugin.isEnabled()) {
            ForestryPlugin.postInit();
        }
        LogHelper.info("Successfully Loaded.", new Object[0]);
    }

    public static boolean postInitEvent(Event event) {
        return initBus.isPresent() ? ((EventBus)initBus.get()).post(event) : false;
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) throws Exception {
        LogHelper.info("Initializing.", new Object[0]);
        MinecraftForge.EVENT_BUS.register((Object)CanMobSpawnHandler.INSTANCE);
        File test = new File(event.getModConfigurationDirectory(), "/extrabiomes/extrabiomes.cfg");
        if (test.exists()) {
            ConfigurationHandler.init(test, true);
            File newFile = new File(event.getModConfigurationDirectory(), "/extrabiomes/oldunusedconfig.cfg");
            if (!newFile.exists()) {
                test.renameTo(newFile);
            }
            LogHelper.info("Upgrading Configfile", new Object[0]);
        }
        EnhancedConfiguration config = ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "/extrabiomes.cfg"), false);
        BiomeHandler.init();
        BiomeManagerImpl.populateAPIBiomes();
        new BiomeManagerImpl();
        Extrabiomes.registerInitEventHandler(new RecipeManager());
        BlockHandler.createBlocks();
        ItemHandler.createItems();
        CropHandler.createCrops();
        BiomeHandler.registerWorldGenerators(config);
        BiomeHandler.enableBiomes();
        BiomeManagerImpl.buildWeightedFloraLists();
        Module.registerModules();
        Module.postEvent(new ModulePreInitEvent());
        Module.postEvent(new ModuleEvent.ModuleInitEvent());
        config.save();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        if (GeneralSettings.consoleCommandsDisabled) {
            return;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager serverCommand = (ServerCommandManager)command;
        serverCommand.func_71560_a((ICommand)new EBXLCommandHandler());
    }

    public static void registerInitEventHandler(Object target) {
        if (initBus.isPresent()) {
            ((EventBus)initBus.get()).register(target);
        }
    }

    static {
        tabsEBXL = new CreativeTab("extrabiomesTab");
        TEXTURE_PATH = "ExtrabiomesXL".toLowerCase(Locale.ENGLISH) + ":";
        initBus = Optional.of((Object)new EventBus());
    }
}

