/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.simple.BlockGlass;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalfoundation.item.TFItems;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SmelterManager {
    public static ItemStack blockSand = new ItemStack((Block)Blocks.field_150354_m);
    public static ItemStack blockSoulSand = new ItemStack(Blocks.field_150425_aM);
    private static Map<List<ComparableItemStackSmelter>, RecipeSmelter> recipeMap = new THashMap();
    private static Set<ComparableItemStackSmelter> validationSet = new THashSet();
    private static Set<ComparableItemStackSmelter> lockSet = new THashSet();
    private static ComparableItemStackSmelter query = new ComparableItemStackSmelter(new ItemStack(Blocks.field_150348_b));
    private static ComparableItemStackSmelter querySecondary = new ComparableItemStackSmelter(new ItemStack(Blocks.field_150348_b));
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 3200;
    private static int oreMultiplier = 2;
    private static int oreMultiplierSpecial = 3;
    private static ArrayList<String> blastList = new ArrayList();

    public static boolean isRecipeReversed(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        RecipeSmelter recipeSmelter = recipeMap.get(Arrays.asList(query.set(itemStack), querySecondary.set(itemStack2)));
        return recipeSmelter != null ? false : recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static RecipeSmelter getRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return null;
        }
        RecipeSmelter recipeSmelter = recipeMap.get(Arrays.asList(query.set(itemStack), querySecondary.set(itemStack2)));
        if (recipeSmelter == null) {
            recipeSmelter = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipeSmelter == null) {
            return null;
        }
        return recipeSmelter;
    }

    public static boolean recipeExists(ItemStack itemStack, ItemStack itemStack2) {
        return SmelterManager.getRecipe(itemStack, itemStack2) != null;
    }

    public static RecipeSmelter[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSmelter[0]);
    }

    public static boolean isItemValid(ItemStack itemStack) {
        return itemStack == null ? false : validationSet.contains((Object)query.set(itemStack));
    }

    public static boolean isItemFlux(ItemStack itemStack) {
        return itemStack == null ? false : lockSet.contains((Object)query.set(itemStack));
    }

    public static boolean isStandardOre(String string) {
        return ItemHelper.oreNameExists((String)string) && FurnaceManager.recipeExists((ItemStack)OreDictionary.getOres((String)string).get(0));
    }

    public static void addDefaultRecipes() {
        SmelterManager.addFlux(blockSand);
        SmelterManager.addFlux(blockSoulSand);
        SmelterManager.addFlux(TEItems.slagRich);
        SmelterManager.addFlux(TFItems.crystalCinnabar);
        SmelterManager.addFlux(TFItems.dustPyrotheum);
        SmelterManager.addTERecipe(4000, new ItemStack(Blocks.field_150347_e, 2), blockSand, new ItemStack(Blocks.field_150417_aV, 1), TEItems.slag, 100);
        SmelterManager.addTERecipe(4000, new ItemStack(Blocks.field_150450_ax), blockSand, new ItemStack(Blocks.field_150451_bX), TEItems.slagRich, 50);
        SmelterManager.addTERecipe(4000, new ItemStack(Blocks.field_150424_aL, 4), blockSoulSand, new ItemStack(Blocks.field_150385_bj, 2), TFItems.dustSulfur, 25);
        ItemStack itemStack = ItemHelper.cloneStack((ItemStack)BlockGlass.glassHardened, (int)2);
        SmelterManager.addAlloyRecipe(4000, "dustLead", 1, "dustObsidian", 4, itemStack);
        SmelterManager.addAlloyRecipe(4000, "ingotLead", 1, "dustObsidian", 4, itemStack);
        itemStack = ItemHelper.cloneStack((ItemStack)BlockGlass.glassHardenedIlluminated, (int)2);
        SmelterManager.addAlloyRecipe(4000, "dustLumium", 1, "dustObsidian", 4, itemStack);
        SmelterManager.addAlloyRecipe(4000, "ingotLumium", 1, "dustObsidian", 4, itemStack);
        SmelterManager.addDefaultOreDictionaryRecipe("oreIron", "dustIron", TFItems.ingotIron, TFItems.ingotNickel);
        SmelterManager.addDefaultOreDictionaryRecipe("oreGold", "dustGold", TFItems.ingotGold, null, 20, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("oreCopper", "dustCopper", TFItems.ingotCopper, TFItems.ingotGold);
        SmelterManager.addDefaultOreDictionaryRecipe("oreTin", "dustTin", TFItems.ingotTin, TFItems.ingotIron);
        SmelterManager.addDefaultOreDictionaryRecipe("oreSilver", "dustSilver", TFItems.ingotSilver, TFItems.ingotLead);
        SmelterManager.addDefaultOreDictionaryRecipe("oreLead", "dustLead", TFItems.ingotLead, TFItems.ingotSilver);
        SmelterManager.addDefaultOreDictionaryRecipe("oreNickel", "dustNickel", TFItems.ingotNickel, TFItems.ingotPlatinum, 15, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("orePlatinum", "dustPlatinum", TFItems.ingotPlatinum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustElectrum", TFItems.ingotElectrum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustInvar", TFItems.ingotInvar);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustBronze", TFItems.ingotBronze);
        ItemStack itemStack2 = ItemHelper.cloneStack((ItemStack)TFItems.ingotElectrum, (int)2);
        ItemStack itemStack3 = ItemHelper.cloneStack((ItemStack)TFItems.ingotInvar, (int)3);
        ItemStack itemStack4 = ItemHelper.cloneStack((ItemStack)TFItems.ingotBronze, (int)4);
        SmelterManager.addAlloyRecipe(1600, "dustSilver", 1, "dustGold", 1, itemStack2);
        SmelterManager.addAlloyRecipe(2400, "ingotSilver", 1, "ingotGold", 1, itemStack2);
        SmelterManager.addAlloyRecipe(1600, "dustNickel", 1, "dustIron", 2, itemStack3);
        SmelterManager.addAlloyRecipe(2400, "ingotNickel", 1, "ingotIron", 2, itemStack3);
        SmelterManager.addAlloyRecipe(1600, "dustTin", 1, "dustCopper", 3, itemStack4);
        SmelterManager.addAlloyRecipe(2400, "ingotTin", 1, "ingotCopper", 3, itemStack4);
    }

    public static void loadRecipes() {
        int n;
        ItemStack itemStack;
        String string = "RecipeManagers.Smelter.Recipes";
        boolean bl = ThermalExpansion.config.get(string, "Steel", true);
        if (ItemHelper.oreNameExists((String)"ingotSteel") && bl) {
            itemStack = ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1);
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "dustSteel", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "dustIron", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "ingotIron", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCharcoal", 4, "dustSteel", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCharcoal", 4, "dustIron", 1, itemStack);
            SmelterManager.addAlloyRecipe(8000, "dustCharcoal", 4, "ingotIron", 1, itemStack);
        }
        itemStack = OreDictionary.getOreNames();
        String string2 = "";
        for (n = 0; n < ((String[])itemStack).length; ++n) {
            if (itemStack[n].startsWith("ore")) {
                string2 = itemStack[n].substring(3, itemStack[n].length());
                if (!SmelterManager.isStandardOre((String)itemStack[n])) continue;
                SmelterManager.addDefaultOreDictionaryRecipe(string2);
                continue;
            }
            if (!itemStack[n].startsWith("dust")) continue;
            string2 = itemStack[n].substring(4, itemStack[n].length());
            if (!SmelterManager.isStandardOre((String)itemStack[n])) continue;
            SmelterManager.addDefaultOreDictionaryRecipe(string2);
        }
        for (n = 0; n < blastList.size(); ++n) {
            SmelterManager.addBlastOreRecipe(blastList.get(n));
        }
    }

    public static void refreshRecipes() {
        ComparableItemStackSmelter comparableItemStackSmelter;
        THashMap tHashMap = new THashMap(recipeMap.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<List<ComparableItemStackSmelter>, RecipeSmelter> object : recipeMap.entrySet()) {
            RecipeSmelter recipeSmelter = object.getValue();
            ComparableItemStackSmelter comparableItemStackSmelter2 = new ComparableItemStackSmelter(recipeSmelter.primaryInput);
            comparableItemStackSmelter = new ComparableItemStackSmelter(recipeSmelter.secondaryInput);
            tHashMap.put(Arrays.asList(comparableItemStackSmelter2, comparableItemStackSmelter), recipeSmelter);
            tHashSet.add(comparableItemStackSmelter2);
            tHashSet.add(comparableItemStackSmelter);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
        validationSet.clear();
        validationSet = tHashSet;
        THashSet tHashSet2 = new THashSet();
        for (ComparableItemStackSmelter comparableItemStackSmelter2 : lockSet) {
            comparableItemStackSmelter = new ComparableItemStackSmelter(new ItemStack(((ComparableItem)comparableItemStackSmelter2).item, comparableItemStackSmelter2.stackSize, ((ComparableItem)comparableItemStackSmelter2).metadata));
            tHashSet2.add(comparableItemStackSmelter);
        }
        lockSet.clear();
        lockSet = tHashSet2;
    }

    protected static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeSmelter recipeSmelter = new RecipeSmelter(itemStack, itemStack2, itemStack3, itemStack4, n2, n);
        recipeMap.put(Arrays.asList(new ComparableItemStackSmelter(itemStack), new ComparableItemStackSmelter(itemStack2)), recipeSmelter);
        validationSet.add(new ComparableItemStackSmelter(itemStack));
        validationSet.add(new ComparableItemStackSmelter(itemStack2));
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && SmelterManager.recipeExists(itemStack, itemStack2)) {
            return false;
        }
        RecipeSmelter recipeSmelter = new RecipeSmelter(itemStack, itemStack2, itemStack3, itemStack4, n2, n);
        recipeMap.put(Arrays.asList(new ComparableItemStackSmelter(itemStack), new ComparableItemStackSmelter(itemStack2)), recipeSmelter);
        validationSet.add(new ComparableItemStackSmelter(itemStack));
        validationSet.add(new ComparableItemStackSmelter(itemStack2));
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack, ItemStack itemStack2) {
        return recipeMap.remove(Arrays.asList(new ComparableItemStackSmelter(itemStack), new ComparableItemStackSmelter(itemStack2))) != null;
    }

    private static void addFlux(ItemStack itemStack) {
        lockSet.add(new ComparableItemStackSmelter(itemStack));
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2, ItemStack itemStack, ItemStack itemStack2, int n, int n2, int n3) {
        if (itemStack == null) {
            return;
        }
        if (string != null) {
            SmelterManager.addOreToIngotRecipe(string, ItemHelper.cloneStack((ItemStack)itemStack, (int)oreMultiplier), ItemHelper.cloneStack((ItemStack)itemStack, (int)oreMultiplierSpecial), ItemHelper.cloneStack((ItemStack)itemStack2, (int)1), n, n2);
        }
        if (string2 != null) {
            SmelterManager.addDustToIngotRecipe(string2, ItemHelper.cloneStack((ItemStack)itemStack, (int)2), n3);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String string) {
        SmelterManager.addDefaultOreDictionaryRecipe(string, "");
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2) {
        if (string.length() <= 0) {
            return;
        }
        String string3 = "ore" + StringHelper.titleCase((String)string);
        String string4 = "dust" + StringHelper.titleCase((String)string);
        String string5 = "ingot" + StringHelper.titleCase((String)string);
        ArrayList arrayList = OreDictionary.getOres((String)string3);
        ArrayList arrayList2 = OreDictionary.getOres((String)string4);
        ArrayList arrayList3 = OreDictionary.getOres((String)string5);
        ArrayList arrayList4 = new ArrayList();
        if (string2 != "") {
            String string6 = "ingot" + StringHelper.titleCase((String)string2);
            arrayList4 = OreDictionary.getOres((String)string6);
        }
        if (arrayList3.isEmpty()) {
            return;
        }
        if (arrayList.isEmpty()) {
            string3 = null;
        }
        if (arrayList2.isEmpty()) {
            string4 = null;
        }
        if (!arrayList4.isEmpty() && arrayList4.get(0) != null) {
            SmelterManager.addDefaultOreDictionaryRecipe(string3, string4, (ItemStack)arrayList3.get(0), (ItemStack)arrayList4.get(0), 5, 75, 25);
        } else {
            SmelterManager.addDefaultOreDictionaryRecipe(string3, string4, (ItemStack)arrayList3.get(0), null, 5, 75, 25);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2, ItemStack itemStack) {
        SmelterManager.addDefaultOreDictionaryRecipe(string, string2, itemStack, null, 5, 75, 25);
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2, ItemStack itemStack, ItemStack itemStack2) {
        SmelterManager.addDefaultOreDictionaryRecipe(string, string2, itemStack, itemStack2, 5, 75, 25);
    }

    public static void addOreToIngotRecipe(String string, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n, int n2) {
        ArrayList arrayList = OreDictionary.getOres((String)string);
        if (arrayList.size() > 0) {
            ItemStack itemStack4 = (ItemStack)arrayList.get(0);
            SmelterManager.addRecipe(3200, itemStack4, blockSand, itemStack, TEItems.slagRich, n);
            SmelterManager.addRecipe(4000, itemStack4, TEItems.slagRich, itemStack2, TEItems.slag, n2);
            SmelterManager.addRecipe(4000, itemStack4, TFItems.dustPyrotheum, itemStack, TEItems.slagRich, Math.min(60, n * 3));
            if (itemStack3 != null) {
                SmelterManager.addRecipe(4000, itemStack4, TFItems.crystalCinnabar, itemStack2, itemStack3, 100);
            } else {
                SmelterManager.addRecipe(4000, itemStack4, TFItems.crystalCinnabar, itemStack2, TEItems.slagRich, 75);
            }
        }
    }

    public static void addDustToIngotRecipe(String string, ItemStack itemStack, int n) {
        ArrayList arrayList = OreDictionary.getOres((String)string);
        if (arrayList.size() > 0) {
            SmelterManager.addRecipe(800, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)2), blockSand, itemStack, TEItems.slag, n);
        }
    }

    public static void addAlloyRecipe(int n, String string, int n2, String string2, int n3, ItemStack itemStack) {
        ArrayList arrayList = OreDictionary.getOres((String)string);
        ArrayList arrayList2 = OreDictionary.getOres((String)string2);
        if (arrayList.size() > 0 && arrayList2.size() > 0) {
            SmelterManager.addAlloyRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)n2), ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList2.get(0)), (int)n3), itemStack);
        }
    }

    public static void addAlloyRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        SmelterManager.addTERecipe(n, itemStack, itemStack2, itemStack3, null, 0);
    }

    public static void addBlastOreRecipe(String string) {
        String string2 = "ore" + StringHelper.titleCase((String)string);
        String string3 = "dust" + StringHelper.titleCase((String)string);
        String string4 = "ingot" + StringHelper.titleCase((String)string);
        ArrayList arrayList = OreDictionary.getOres((String)string2);
        ArrayList arrayList2 = OreDictionary.getOres((String)string3);
        ArrayList arrayList3 = OreDictionary.getOres((String)string4);
        if (arrayList3.isEmpty()) {
            return;
        }
        if (!arrayList.isEmpty()) {
            SmelterManager.addRecipe(12000, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)1), TFItems.dustPyrotheum, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList3.get(0)), (int)2));
        }
        if (!arrayList2.isEmpty()) {
            SmelterManager.addRecipe(8000, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList2.get(0)), (int)2), TFItems.dustPyrotheum, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList3.get(0)), (int)2));
        }
    }

    public static void addBlastOreName(String string) {
        blastList.add(StringHelper.camelCase((String)string));
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, boolean bl) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, null, 0, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, boolean bl) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, 100, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2) {
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Smelter", "AllowRecipeOverwrite", false);
        String string = "RecipeManagers.Smelter.Ore";
        String string2 = "This sets the default rate for Ore->Ingot conversion. This number is used in all automatically generated recipes.";
        oreMultiplier = MathHelper.clampI((int)ThermalExpansion.config.get(string, "DefaultMultiplier", oreMultiplier, string2), (int)1, (int)64);
        string2 = "This sets the boosted rate for Ore->Ingot conversion - when Rich Slag or Cinnabar Crystals are used. This number is used in all automatically generated recipes.";
        oreMultiplierSpecial = MathHelper.clampI((int)ThermalExpansion.config.get(string, "SpecialMultiplier", oreMultiplierSpecial, string2), (int)1, (int)64);
        blastList.add("mithril");
        blastList.add("enderium");
        blastList.add("aluminum");
        blastList.add("ardite");
        blastList.add("cobalt");
    }

    public static class ComparableItemStackSmelter
    extends ComparableItemStack {
        static final String BLOCK = "block";
        static final String ORE = "ore";
        static final String DUST = "dust";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String SAND = "sand";

        public static boolean safeOreType(String string) {
            return string.startsWith(BLOCK) || string.startsWith(ORE) || string.startsWith(DUST) || string.startsWith(INGOT) || string.startsWith(NUGGET) || string.equals(SAND);
        }

        public static int getOreID(ItemStack itemStack) {
            int n = ItemHelper.oreProxy.getOreID(itemStack);
            if (n == -1 || !ComparableItemStackSmelter.safeOreType(ItemHelper.oreProxy.getOreName(n))) {
                return -1;
            }
            return n;
        }

        public static int getOreID(String string) {
            if (!ComparableItemStackSmelter.safeOreType(string)) {
                return -1;
            }
            return ItemHelper.oreProxy.getOreID(string);
        }

        public ComparableItemStackSmelter(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackSmelter.getOreID(itemStack);
        }

        public ComparableItemStackSmelter(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackSmelter.getOreID(this.toItemStack());
        }

        public ComparableItemStackSmelter set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackSmelter.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipeSmelter {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSmelter(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n, int n2) {
            this.primaryInput = itemStack;
            this.secondaryInput = itemStack2;
            this.primaryOutput = itemStack3;
            this.secondaryOutput = itemStack4;
            this.secondaryChance = n;
            this.energy = n2;
            if (itemStack.field_77994_a <= 0) {
                itemStack.field_77994_a = 1;
            }
            if (itemStack2.field_77994_a <= 0) {
                itemStack2.field_77994_a = 1;
            }
            if (itemStack3.field_77994_a <= 0) {
                itemStack3.field_77994_a = 1;
            }
            if (itemStack4 != null && itemStack4.field_77994_a <= 0) {
                itemStack4.field_77994_a = 1;
            }
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput.func_77946_l();
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

