/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermalexpansion.block.TEBlocks;
import cofh.thermalexpansion.block.tank.BlockTank;
import cofh.thermalexpansion.block.tank.TileTank;
import cofh.thermalexpansion.core.TEProps;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderTank
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderTank instance = new RenderTank();
    static IIcon[] textureTop = new IIcon[BlockTank.Types.values().length * 2];
    static IIcon[] textureBottom = new IIcon[BlockTank.Types.values().length * 2];
    static IIcon[] textureSides = new IIcon[BlockTank.Types.values().length * 2];
    static CCModel[] modelFluid = new CCModel[128];
    static CCModel modelFrame = CCModel.quadModel((int)48);

    public static void initialize() {
        for (int i = 0; i < textureSides.length; ++i) {
            RenderTank.textureTop[i] = IconRegistry.getIcon((String)"TankTop", (int)i);
            RenderTank.textureBottom[i] = IconRegistry.getIcon((String)"TankBottom", (int)i);
            RenderTank.textureSides[i] = IconRegistry.getIcon((String)"TankSide", (int)i);
        }
    }

    private static void generateFluidModels() {
        double d = 0.1865234375;
        double d2 = 0.8134765625;
        double d3 = 0.0615234375;
        double d4 = 1.0 - d3;
        double d5 = (d4 - d3) / 128.0;
        for (int i = 1; i < 129; ++i) {
            double d6 = d3 + d5 * (double)i;
            RenderTank.modelFluid[i - 1] = CCModel.quadModel((int)24).generateBlock(0, d, d3, d, d2, d6, d2).computeNormals();
        }
    }

    public void renderFrame(int n, int n2, double d, double d2, double d3) {
        int n3;
        Translation translation = RenderUtils.getRenderVector((double)d, (double)d2, (double)d3).translation();
        modelFrame.render(0, 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureBottom[2 * n + n2])});
        modelFrame.render(24, 28, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureTop[2 * n + n2])});
        modelFrame.render(4, 8, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureTop[2 * n])});
        modelFrame.render(28, 32, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureBottom[2 * n])});
        for (n3 = 8; n3 < 24; n3 += 4) {
            modelFrame.render(n3, n3 + 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureSides[2 * n + n2])});
        }
        for (n3 = 32; n3 < 48; n3 += 4) {
            modelFrame.render(n3, n3 + 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)textureSides[2 * n + n2])});
        }
    }

    public void renderFluid(int n, FluidStack fluidStack, double d, double d2, double d3) {
        if (fluidStack == null || fluidStack.amount <= 0) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        RenderUtils.setFluidRenderColor((FluidStack)fluidStack);
        IIcon iIcon = RenderHelper.getFluidTexture((FluidStack)fluidStack);
        int n2 = 127;
        if (fluid.isGaseous(fluidStack)) {
            CCRenderState.alphaOverride = 32 + 192 * fluidStack.amount / TileTank.CAPACITY[n];
        } else {
            n2 = Math.min(127, fluidStack.amount * 128 / TileTank.CAPACITY[n]);
        }
        modelFluid[n2].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileTank)) {
            return false;
        }
        TileTank tileTank = (TileTank)tileEntity;
        RenderUtils.preWorldRender((IBlockAccess)iBlockAccess, (int)n, (int)n2, (int)n3);
        if (BlockCoFHBase.renderPass == 0) {
            this.renderFrame(tileTank.type, tileTank.mode, n, n2, n3);
        } else {
            if (tileTank.getTankFluid() == null) {
                return false;
            }
            this.renderFluid(tileTank.func_145832_p(), tileTank.getTankFluid(), n, n2, n3);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdTank;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        GL11.glPushMatrix();
        double d = -0.5;
        if (itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            d = 0.0;
        }
        FluidStack fluidStack = null;
        if (itemStack.field_77990_d != null) {
            fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"));
        }
        RenderUtils.preItemRender();
        CCRenderState.startDrawing();
        this.renderFluid(itemStack.func_77960_j(), fluidStack, d, d, d);
        CCRenderState.draw();
        CCRenderState.alphaOverride = -1;
        CCRenderState.startDrawing();
        this.renderFrame(itemStack.func_77960_j(), 0, d, d, d);
        CCRenderState.draw();
        RenderUtils.postItemRender();
        GL11.glPopMatrix();
    }

    static {
        TEProps.renderIdTank = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)TEBlocks.blockTank), (IItemRenderer)instance);
        RenderTank.generateFluidModels();
        Cuboid6 cuboid6 = new Cuboid6(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        double d = 0.0625;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, cuboid6);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            RenderTank.modelFrame.verts[i].vec.add(modelFrame.normals()[i].copy().multiply(d));
        }
        modelFrame.computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
    }
}

