/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.strongbox;

import cofh.core.enchantment.CoFHEnchantment;
import cofh.core.util.CoreUtils;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.strongbox.TileStrongbox;
import cofh.thermalexpansion.block.strongbox.TileStrongboxCreative;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockStrongbox
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 5.0f, 15.0f, 20.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack strongboxCreative;
    public static ItemStack strongboxBasic;
    public static ItemStack strongboxHardened;
    public static ItemStack strongboxReinforced;
    public static ItemStack strongboxResonant;

    public BlockStrongbox() {
        super(Material.field_151573_f);
        this.func_149711_c(20.0f);
        this.func_149752_b(120.0f);
        this.func_149663_c("thermalexpansion.strongbox");
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        if (n == Types.CREATIVE.ordinal()) {
            if (!enable[Types.CREATIVE.ordinal()]) {
                return null;
            }
            return new TileStrongboxCreative(n);
        }
        return new TileStrongbox(n);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (enable[0]) {
            list.add(new ItemStack(item, 1, 0));
        }
        for (int i = 1; i < Types.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (!enable[world.func_72805_g(n, n2, n3)]) {
            world.func_147468_f(n, n2, n3);
            return;
        }
        if (itemStack.field_77990_d != null) {
            TileStrongbox tileStrongbox = (TileStrongbox)world.func_147438_o(n, n2, n3);
            tileStrongbox.enchant = (byte)EnchantmentHelper.func_77506_a((int)CoFHEnchantment.holding.field_77352_x, (ItemStack)itemStack);
            tileStrongbox.createInventory();
            if (itemStack.field_77990_d.func_74764_b("Inventory")) {
                tileStrongbox.readInventoryFromNBT(itemStack.field_77990_d);
            }
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return HARDNESS[world.func_72805_g(n, n2, n3)];
    }

    public float getExplosionResistance(Entity entity, World world, int n, int n2, int n3, double d, double d2, double d3) {
        return RESISTANCE[world.func_72805_g(n, n2, n3)];
    }

    public int func_149645_b() {
        return -1;
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileStrongbox tileStrongbox = (TileStrongbox)world.func_147438_o(n, n2, n3);
        if (tileStrongbox != null) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            if (tileStrongbox.enchant > 0) {
                CoFHEnchantment.addEnchantment((NBTTagCompound)nBTTagCompound, (int)CoFHEnchantment.holding.field_77352_x, (int)tileStrongbox.enchant);
            }
            tileStrongbox.writeInventoryToNBT(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        NBTTagCompound nBTTagCompound = this.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileInventory) {
            ((TileInventory)tileEntity).inventory = new ItemStack[((TileInventory)tileEntity).inventory.length];
        }
        return super.dismantleBlock(entityPlayer, nBTTagCompound, world, n, n2, n3, bl, false);
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        if (world.func_72805_g(n, n2, n3) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)entityPlayer)) {
            return false;
        }
        return super.canDismantle(entityPlayer, world, n, n2, n3);
    }

    public boolean initialize() {
        TileStrongbox.initialize();
        TileStrongboxCreative.initialize();
        strongboxCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        strongboxBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        strongboxHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        strongboxReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        strongboxResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        GameRegistry.registerCustomItemStack((String)"strongboxCreative", (ItemStack)strongboxCreative);
        GameRegistry.registerCustomItemStack((String)"strongboxBasic", (ItemStack)strongboxBasic);
        GameRegistry.registerCustomItemStack((String)"strongboxHardened", (ItemStack)strongboxHardened);
        GameRegistry.registerCustomItemStack((String)"strongboxReinforced", (ItemStack)strongboxReinforced);
        GameRegistry.registerCustomItemStack((String)"strongboxResonant", (ItemStack)strongboxResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(strongboxBasic, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotTin", Character.valueOf('X'), Blocks.field_150486_ae}));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(strongboxHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), strongboxBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(strongboxHardened, new Object[]{"IYI", "YXY", "IYI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), Blocks.field_150486_ae, Character.valueOf('Y'), "ingotTin"}));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(strongboxReinforced, new Object[]{" G ", "GXG", " G ", Character.valueOf('X'), strongboxHardened, Character.valueOf('G'), "blockGlassHardened"}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(strongboxResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), strongboxReinforced}));
        }
        TECraftingHandler.addSecureRecipe(strongboxCreative);
        TECraftingHandler.addSecureRecipe(strongboxBasic);
        TECraftingHandler.addSecureRecipe(strongboxHardened);
        TECraftingHandler.addSecureRecipe(strongboxReinforced);
        TECraftingHandler.addSecureRecipe(strongboxResonant);
        return true;
    }

    static {
        String string = "Strongbox.";
        BlockStrongbox.enable[0] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[0]), "Enable", true);
        for (int i = 1; i < Types.values().length; ++i) {
            BlockStrongbox.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

