/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import cofh.core.network.PacketCoFHBase;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlateBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePlatePoweredBase
extends TilePlateBase
implements IEnergyReceiver {
    protected EnergyStorage storage;

    protected TilePlatePoweredBase(BlockPlate.Types types, int n) {
        super(types);
        this.storage = new EnergyStorage(n);
    }

    @Override
    public boolean setFacing(int n) {
        return false;
    }

    @Override
    void setAlignment(int n, float f, float f2, float f3) {
        this.alignment = (byte)n;
        this.direction = (byte)7;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.storage.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.storage.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.storage.getEnergyStored());
        return packetCoFHBase;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.storage.setEnergyStored(packetCoFHBase.getInt());
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return forgeDirection.ordinal() == this.alignment;
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.storage.receiveEnergy(n, bl);
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.storage.getMaxEnergyStored();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.storage;
    }
}

