/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.light;

import cofh.api.block.IBlockConfigGui;
import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.ColorHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.light.ItemBlockLight;
import cofh.thermalexpansion.block.light.TileLight;
import cofh.thermalexpansion.block.light.TileLightFalse;
import cofh.thermalexpansion.block.simple.BlockFrame;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.render.transformation.TorchTransformation;
import cofh.thermalexpansion.util.crafting.RecipeStyle;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockLight
extends BlockTEBase
implements IBlockConfigGui {
    public static Cuboid6[] models;
    public static final String[] NAMES;
    public static boolean[] enable;
    public static ItemStack illuminator;
    public static ItemStack lampLumiumRadiant;
    public static ItemStack lampLumium;

    public static Transformation getTransformation(int n, int n2) {
        Transformation transformation = TorchTransformation.sideTransformations[0];
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                transformation = Rotation.sideRotations[n2].at(Vector3.center);
                break;
            }
            case 4: {
                transformation = Rotation.quarterRotations[n2 >> 3].with(Rotation.sideRotations[n2 & 7]).at(Vector3.center);
                break;
            }
            case 5: {
                transformation = TorchTransformation.sideTransformations[n2];
                break;
            }
        }
        return transformation;
    }

    public BlockLight() {
        super(Material.field_151591_t);
        this.func_149711_c(3.0f);
        this.func_149752_b(150.0f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c("thermalexpansion.light");
        this.basicGui = false;
    }

    public TileEntity func_149915_a(World world, int n) {
        return new TileLight();
    }

    public boolean openConfigGui(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
        return ((TileLight)iBlockAccess.func_147438_o(n, n2, n3)).openGui(entityPlayer);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            for (int n = 0; n < models.length; n = (int)((byte)(n + 1))) {
                list.add(ItemBlockLight.setDefaultTag(new ItemStack(item, 1, i), n));
            }
        }
    }

    public AxisAlignedBB getBoundingBox(World world, int n, int n2, int n3) {
        TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
        switch (tileLight.style) {
            case 2: 
            case 5: {
                return null;
            }
        }
        Cuboid6 cuboid6 = models[tileLight.style].copy().apply(BlockLight.getTransformation(tileLight.style, tileLight.alignment));
        return cuboid6.add(new Vector3((double)n, (double)n2, (double)n3)).toAABB();
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileLight tileLight = (TileLight)iBlockAccess.func_147438_o(n, n2, n3);
        Cuboid6 cuboid6 = models[tileLight.style].copy().apply(BlockLight.getTransformation(tileLight.style, tileLight.alignment));
        block0 : switch (tileLight.style) {
            case 5: {
                switch (tileLight.alignment) {
                    case 2: 
                    case 3: {
                        cuboid6.expand(new Vector3(0.1, 0.0, 0.0));
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        cuboid6.expand(new Vector3(0.0, 0.0, 0.1));
                        break block0;
                    }
                }
                cuboid6.expand(0.05);
            }
        }
        cuboid6.setBlockBounds((Block)this);
    }

    public boolean func_149705_a(World world, int n, int n2, int n3, int n4, ItemStack itemStack) {
        if (super.func_149705_a(world, n, n2, n3, n4, itemStack)) {
            byte by;
            return itemStack.field_77990_d == null || (by = itemStack.field_77990_d.func_74771_c("Style")) != 5 || n4 != 0;
        }
        return false;
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
            if (itemStack.field_77990_d.func_74764_b("Color")) {
                tileLight.modified = true;
                tileLight.setColor(itemStack.field_77990_d.func_74762_e("Color"));
            }
            tileLight.dim = itemStack.field_77990_d.func_74767_n("Dim");
            tileLight.mode = itemStack.field_77990_d.func_74771_c("Mode");
            tileLight.style = itemStack.field_77990_d.func_74771_c("Style");
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public void onNeighborChange(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public boolean recolourBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
        if (ServerHelper.isServerWorld((World)world)) {
            return tileLight.setColor(ColorHelper.getDyeColor((int)(15 - n4)));
        }
        return false;
    }

    public boolean shouldCheckWeakPower(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return true;
    }

    public boolean func_149721_r() {
        return false;
    }

    public int func_149645_b() {
        return TEProps.renderIdLight;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149677_c(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileLight tileLight = (TileLight)iBlockAccess.func_147438_o(n, n2, n3);
        return iBlockAccess.func_72802_i(n, n2, n3, tileLight.getInternalLight());
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"Light0", (String)"thermalexpansion:light/Illuminator_Frame", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Light1", (String)"thermalexpansion:light/Lamp_Effect", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"LightEffect", (String)"thermalexpansion:light/Illuminator_Effect", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"LightHalo", (String)"thermalexpansion:light/Lamp_Halo", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        if (tileLight.modified) {
            nBTTagCompound.func_74768_a("Color", tileLight.color);
        }
        if (tileLight.dim) {
            nBTTagCompound.func_74757_a("Dim", tileLight.dim);
        }
        nBTTagCompound.func_74774_a("Mode", tileLight.mode);
        if (tileLight.style != 0) {
            nBTTagCompound.func_74774_a("Style", tileLight.style);
        }
        return nBTTagCompound.func_82582_d() ? null : nBTTagCompound;
    }

    public boolean initialize() {
        TileLight.initialize();
        TileLightFalse.initialize();
        illuminator = ItemBlockLight.setDefaultTag(new ItemStack((Block)this, 1, 0), 0);
        lampLumiumRadiant = ItemBlockLight.setDefaultTag(new ItemStack((Block)this, 1, 1), 0);
        lampLumium = ItemBlockLight.setDefaultTag(new ItemStack((Block)this, 1, 2), 0);
        GameRegistry.registerCustomItemStack((String)"illuminator", (ItemStack)illuminator);
        GameRegistry.registerCustomItemStack((String)"lampLumiumRadiant", (ItemStack)lampLumiumRadiant);
        GameRegistry.registerCustomItemStack((String)"lampLumium", (ItemStack)lampLumium);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.ILLUMINATOR.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, BlockFrame.frameIlluminator, illuminator, new FluidStack(TFFluids.fluidGlowstone, 500), false);
            BlockLight.addRecipes(illuminator);
        }
        if (enable[Types.LAMP_LUMIUM_RADIANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemHelper.cloneStack((ItemStack)lampLumiumRadiant, (int)4), new Object[]{" L ", "GLG", " S ", Character.valueOf('L'), "ingotLumium", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('S'), "ingotSignalum"}));
            BlockLight.addRecipes(lampLumiumRadiant);
        }
        if (enable[Types.LAMP_LUMIUM.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemHelper.cloneStack((ItemStack)lampLumium, (int)4), new Object[]{" L ", "GLG", " S ", Character.valueOf('L'), "dustLumium", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('S'), "ingotSignalum"}));
            BlockLight.addRecipes(lampLumium);
        }
        return true;
    }

    private static void addRecipes(ItemStack itemStack) {
        GameRegistry.addRecipe((IRecipe)new RecipeStyle(2, 1, itemStack, 0, ItemBlockLight.setDefaultTag(ItemHelper.cloneStack((ItemStack)itemStack, (int)2), 1)));
        GameRegistry.addRecipe((IRecipe)new RecipeStyle(1, 1, itemStack, 0, ItemBlockLight.setDefaultTag(ItemHelper.cloneStack((ItemStack)itemStack, (int)2), 2)));
        GameRegistry.addRecipe((IRecipe)new RecipeStyle(1, 2, itemStack, 2, ItemBlockLight.setDefaultTag(ItemHelper.cloneStack((ItemStack)itemStack, (int)2), 3)));
        GameRegistry.addRecipe((IRecipe)new RecipeStyle(3, 1, itemStack, 0, ItemBlockLight.setDefaultTag(ItemHelper.cloneStack((ItemStack)itemStack, (int)6), 4)));
        GameRegistry.addRecipe((IRecipe)new RecipeStyle(1, 2, itemStack, 0, ItemBlockLight.setDefaultTag(ItemHelper.cloneStack((ItemStack)itemStack, (int)4), 5)));
    }

    static {
        double d = 0.0;
        models = new Cuboid6[6];
        BlockLight.models[0] = new Cuboid6(d, d, d, 1.0 - d, 1.0 - d, 1.0 - d);
        double d2 = 0.0625;
        double d3 = 0.9375;
        double d4 = 0.125;
        BlockLight.models[1] = new Cuboid6(d2 + d, d, d2 + d, d3 - d, d4 - d, d3 - d);
        d2 = 0.375;
        d3 = 0.625;
        d4 = 0.125;
        BlockLight.models[2] = new Cuboid6(d2 + d, d, d2 + d, d3 - d, d4 - d, d3 - d);
        d2 = 0.3125;
        d3 = 0.6875;
        d4 = 0.4375;
        BlockLight.models[3] = new Cuboid6(d2 + d, d, d2 + d, d3 - d, d4 - d, d3 - d);
        d2 = 0.375;
        d3 = 0.625;
        d4 = 0.125;
        BlockLight.models[4] = new Cuboid6(d2 + d, d, d, d3 - d, d4 - d, 1.0 - d);
        d2 = 0.4375;
        d3 = 0.5625;
        d4 = 0.625;
        BlockLight.models[5] = new Cuboid6(d2 + d, d, d2 + d, d3 - d, d4 - d, d3 - d);
        NAMES = new String[]{"illuminator", "lampLumiumRadiant", "lampLumium"};
        enable = new boolean[Types.values().length];
        String string = "Light.";
        for (int i = 0; i < Types.values().length; ++i) {
            BlockLight.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        ILLUMINATOR,
        LAMP_LUMIUM_RADIANT,
        LAMP_LUMIUM;


        public static Types getType(int n) {
            Types[] typesArray = Types.values();
            return typesArray[n % typesArray.length];
        }
    }
}

