/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.Log;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MessageTileNBT
implements IMessage,
IMessageHandler<MessageTileNBT, IMessage> {
    TileEntity te;
    int x;
    int y;
    int z;
    NBTTagCompound tags;
    boolean renderOnUpdate = false;

    public MessageTileNBT() {
    }

    public MessageTileNBT(TileEntity te) {
        this.te = te;
        this.x = te.field_145851_c;
        this.y = te.field_145848_d;
        this.z = te.field_145849_e;
        this.tags = new NBTTagCompound();
        te.func_145841_b(this.tags);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        NetworkUtil.writeNBTTagCompound(this.tags, buffer);
    }

    public void fromBytes(ByteBuf dis) {
        this.x = dis.readInt();
        this.y = dis.readInt();
        this.z = dis.readInt();
        this.tags = NetworkUtil.readNBTTagCompound(dis);
    }

    public IMessage onMessage(MessageTileNBT msg, MessageContext ctx) {
        this.te = this.handle(ctx.getServerHandler().field_147369_b.field_70170_p);
        if (this.te != null && this.renderOnUpdate) {
            this.te.func_145831_w().func_147471_g(this.x, this.y, this.z);
        }
        return null;
    }

    private TileEntity handle(World world) {
        if (world == null) {
            Log.warn("PacketUtil.handleTileEntityPacket: TileEntity null world processing tile entity packet.");
            return null;
        }
        TileEntity te = world.func_147438_o(this.x, this.y, this.z);
        if (te == null) {
            Log.warn("PacketUtil.handleTileEntityPacket: TileEntity null when processing tile entity packet.");
            return null;
        }
        te.func_145839_a(this.tags);
        return te;
    }
}

