/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.api.client.render;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.RenderUtil;
import java.beans.ConstructorProperties;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public interface IWidgetMap {
    public int getSize();

    public ResourceLocation getTexture();

    public void render(IWidgetIcon var1, double var2, double var4);

    public void render(IWidgetIcon var1, double var2, double var4, boolean var6);

    public void render(IWidgetIcon var1, double var2, double var4, double var6, double var8, double var10, boolean var12);

    public void render(IWidgetIcon var1, double var2, double var4, double var6, double var8, double var10, boolean var12, boolean var13);

    public static class WidgetMapImpl
    implements IWidgetMap {
        private final int size;
        private final ResourceLocation res;

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public ResourceLocation getTexture() {
            return this.res;
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y) {
            this.render(widget, x, y, false);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, boolean doDraw) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), 0.0, doDraw);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw) {
            this.render(widget, x, y, width, height, zLevel, doDraw, false);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw, boolean flipY) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            if (doDraw) {
                RenderUtil.bindTexture(this.getTexture());
                tessellator.func_78382_b();
            }
            double minU = (double)widget.getX() / (double)this.getSize();
            double maxU = (double)(widget.getX() + widget.getWidth()) / (double)this.getSize();
            double minV = (double)widget.getY() / (double)this.getSize();
            double maxV = (double)(widget.getY() + widget.getHeight()) / (double)this.getSize();
            if (flipY) {
                tessellator.func_78374_a(x, y + height, zLevel, minU, minV);
                tessellator.func_78374_a(x + width, y + height, zLevel, maxU, minV);
                tessellator.func_78374_a(x + width, y + 0.0, zLevel, maxU, maxV);
                tessellator.func_78374_a(x, y + 0.0, zLevel, minU, maxV);
            } else {
                tessellator.func_78374_a(x, y + height, zLevel, minU, maxV);
                tessellator.func_78374_a(x + width, y + height, zLevel, maxU, maxV);
                tessellator.func_78374_a(x + width, y + 0.0, zLevel, maxU, minV);
                tessellator.func_78374_a(x, y + 0.0, zLevel, minU, minV);
            }
            if (widget.getOverlay() != null) {
                widget.getOverlay().getMap().render(widget.getOverlay(), x, y, width, height, zLevel, false, flipY);
            }
            if (doDraw) {
                tessellator.func_78381_a();
            }
        }

        @ConstructorProperties(value={"size", "res"})
        public WidgetMapImpl(int size, ResourceLocation res) {
            this.size = size;
            this.res = res;
        }
    }
}

