/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.other;

import extracells.network.AbstractPacket;
import extracells.network.packet.other.IFluidSlotGui;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.part.PartECBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;

public class PacketFluidSlot
extends AbstractPacket {
    private int index;
    private Fluid fluid;
    private IFluidSlotPartOrBlock partOrBlock;
    private List<Fluid> filterFluids;

    public PacketFluidSlot() {
    }

    public PacketFluidSlot(IFluidSlotPartOrBlock _partOrBlock, int _index, Fluid _fluid, EntityPlayer _player) {
        super(_player);
        this.mode = 0;
        this.partOrBlock = _partOrBlock;
        this.index = _index;
        this.fluid = _fluid;
    }

    public PacketFluidSlot(List<Fluid> _filterFluids) {
        this.mode = 1;
        this.filterFluids = _filterFluids;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.partOrBlock.setFluid(this.index, this.fluid, this.player);
                break;
            }
            case 1: {
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                if (!(gui instanceof IFluidSlotGui)) break;
                IFluidSlotGui partGui = (IFluidSlotGui)gui;
                partGui.updateFluids(this.filterFluids);
            }
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.partOrBlock = in.readBoolean() ? (IFluidSlotPartOrBlock)((Object)PacketFluidSlot.readPart(in)) : (IFluidSlotPartOrBlock)PacketFluidSlot.readTileEntity(in);
                this.index = in.readInt();
                this.fluid = PacketFluidSlot.readFluid(in);
                break;
            }
            case 1: {
                this.filterFluids = new ArrayList<Fluid>();
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    this.filterFluids.add(PacketFluidSlot.readFluid(in));
                }
                break;
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                if (this.partOrBlock instanceof PartECBase) {
                    out.writeBoolean(true);
                    PacketFluidSlot.writePart((PartECBase)((Object)this.partOrBlock), out);
                } else {
                    out.writeBoolean(false);
                    PacketFluidSlot.writeTileEntity((TileEntity)this.partOrBlock, out);
                }
                out.writeInt(this.index);
                PacketFluidSlot.writeFluid(this.fluid, out);
                break;
            }
            case 1: {
                out.writeInt(this.filterFluids.size());
                for (int i = 0; i < this.filterFluids.size(); ++i) {
                    PacketFluidSlot.writeFluid(this.filterFluids.get(i), out);
                }
                break;
            }
        }
    }
}

