/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class BeefGuiVerticalProgressBar
extends BeefGuiControlBase {
    private static final int controlWidth = 20;
    private static final int controlHeight = 64;
    protected ResourceLocation controlResource = new ResourceLocation("bigreactors:textures/gui/" + this.getBackgroundTexture());
    private double backgroundLeftU = this.getBackgroundLeftU();
    private double backgroundRightU = this.getBackgroundRightU();
    private double gradationLeftU = this.getGradationLeftU();
    private double gradationRightU = this.getGradationRightU();
    protected float barAbsoluteMaxHeight = this.height - 1;

    public BeefGuiVerticalProgressBar(BeefGuiBase container, int x, int y) {
        super(container, x, y, 20, 64);
    }

    protected boolean drawGradationMarks() {
        return false;
    }

    protected String getBackgroundTexture() {
        return "controls/FluidTank.png";
    }

    protected abstract float getProgress();

    protected abstract void drawProgressBar(Tessellator var1, TextureManager var2, int var3, int var4, int var5, int var6, int var7);

    protected double getBackgroundLeftU() {
        return 0.0;
    }

    protected double getBackgroundRightU() {
        return 0.32;
    }

    protected double getGradationLeftU() {
        return 0.77;
    }

    protected double getGradationRightU() {
        return 1.0;
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderEngine.func_110577_a(this.controlResource);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)this.absoluteX, (double)(this.absoluteY + this.height), 0.0, this.backgroundLeftU, 1.0);
        tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height), 0.0, this.backgroundRightU, 1.0);
        tessellator.func_78374_a((double)(this.absoluteX + this.width), (double)this.absoluteY, 0.0, this.backgroundRightU, 0.0);
        tessellator.func_78374_a((double)this.absoluteX, (double)this.absoluteY, 0.0, this.backgroundLeftU, 0.0);
        tessellator.func_78381_a();
        float progress = this.getProgress();
        if ((double)progress > 0.0) {
            int barHeight = Math.max(1, (int)Math.floor(progress * this.barAbsoluteMaxHeight));
            int barMinX = this.absoluteX + 1;
            int barMaxX = this.absoluteX + this.width - 4;
            int barMinY = this.absoluteY + this.height - barHeight;
            int barMaxY = this.absoluteY + this.height - 1;
            this.drawProgressBar(tessellator, renderEngine, barMinX, barMaxX, barMinY, barMaxY, 1);
        }
        if (this.drawGradationMarks()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            renderEngine.func_110577_a(this.controlResource);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)this.absoluteX, (double)(this.absoluteY + this.height), 2.0, this.gradationLeftU, 1.0);
            tessellator.func_78374_a((double)(this.absoluteX + this.width - 4), (double)(this.absoluteY + this.height), 2.0, this.gradationRightU, 1.0);
            tessellator.func_78374_a((double)(this.absoluteX + this.width - 4), (double)this.absoluteY, 2.0, this.gradationRightU, 0.0);
            tessellator.func_78374_a((double)this.absoluteX, (double)this.absoluteY, 2.0, this.gradationLeftU, 0.0);
            tessellator.func_78381_a();
        }
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
    }
}

