/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.ArsMagicaApi;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.buffs.BuffEffectTrueSight;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class TrueSight
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            int z;
            int y;
            int duration = SpellUtils.instance.getModifiedInt_Mul(600, stack, caster, target, world, 0, SpellModifiers.DURATION);
            duration = SpellUtils.instance.modifyDurationBasedOnArmor(caster, duration);
            int x = (int)Math.floor(target.field_70165_t);
            if (RitualShapeHelper.instance.checkForRitual(this, world, x, y = (int)Math.floor(target.field_70163_u), z = (int)Math.floor(target.field_70161_v)) != null) {
                duration += 3600 * (SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0) + 1);
                RitualShapeHelper.instance.consumeRitualReagents(this, world, x, y, z);
            }
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectTrueSight(duration, SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0)));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.1f, 2, false).setOrbitY(0.5).SetTargetDistance(1.0));
            particle.setMaxAge(40);
            particle.setParticleScale(0.2f);
            if (rand.nextBoolean()) {
                particle.setRGBColorF(0.7f, 0.1f, 0.7f);
            }
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 56;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 4);
        objectArray[2] = Blocks.field_150410_aZ;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        ItemStack[] itemStackArray = new ItemStack[1];
        itemStackArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 0);
        return itemStackArray;
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

