/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Fling
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        double velocity = SpellUtils.instance.getModifiedDouble_Add(0.85, stack, caster, target, world, 0, SpellModifiers.VELOCITY_ADDED);
        if (target instanceof EntityPlayer) {
            AMNetHandler.INSTANCE.sendVelocityAddPacket(world, (EntityLivingBase)((EntityPlayer)target), 0.0, velocity, 0.0);
        }
        target.func_70024_g(0.0, velocity, 0.0);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 20.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "wind", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.3f + rand.nextFloat() * 0.3f, 1, false));
            particle.setMaxAge(20);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.AIR);
    }

    @Override
    public int getID() {
        return 17;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 15);
        objectArray[1] = Blocks.field_150331_J;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

