/*
 * Decompiled with CFR 0.152.
 */
package am2.render3d;

import am2.AMCore;
import am2.render3d.OBJFace;
import am2.render3d.OBJNormal;
import am2.render3d.OBJTexCoord;
import am2.render3d.OBJVertex;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class OBJModel {
    private OBJTexCoord[] textureCoords;
    private OBJNormal[] normals;
    private OBJVertex[] vertices;
    private OBJFace[] faces;
    private boolean loaded;
    private boolean flatShading;
    private int cullMode;
    private int glCallList;

    public OBJModel(ResourceLocation objFile, boolean flatShading) {
        this.loaded = this.LoadOBJModel(objFile);
        if (!this.loaded) {
            // empty if block
        }
        this.flatShading = flatShading;
        this.cullMode = 1028;
    }

    private void createMissingModel() {
        this.vertices = new OBJVertex[8];
        this.vertices[0] = new OBJVertex(0.0f, 0.0f, 0.0f);
        this.vertices[1] = new OBJVertex(1.0f, 0.0f, 0.0f);
        this.vertices[2] = new OBJVertex(0.0f, 0.0f, 1.0f);
        this.vertices[3] = new OBJVertex(1.0f, 0.0f, 1.0f);
        this.vertices[4] = new OBJVertex(0.0f, 1.0f, 0.0f);
        this.vertices[5] = new OBJVertex(1.0f, 1.0f, 0.0f);
        this.vertices[6] = new OBJVertex(0.0f, 1.0f, 1.0f);
        this.vertices[7] = new OBJVertex(1.0f, 1.0f, 1.0f);
        this.textureCoords = new OBJTexCoord[1];
        this.textureCoords[0] = new OBJTexCoord(0.0f, 0.0f);
        this.faces = new OBJFace[6];
        this.faces[0] = new OBJFace(new int[0], new int[]{0}, new int[4]);
        this.calculateNormals();
    }

    public OBJModel(ResourceLocation objFile) {
        this(objFile, false);
    }

    public OBJModel SetBackCulling() {
        this.cullMode = 1029;
        return this;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    private InputStream getResourceAsStream(String resourceName) {
        return AMCore.class.getResourceAsStream(resourceName);
    }

    private boolean LoadOBJModel(ResourceLocation path) {
        InputStream stream = this.getResourceAsStream(path.func_110623_a());
        if (stream == null) {
            return false;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
            stream.close();
        }
        catch (Throwable t) {
            FMLLog.severe((String)"Error reading OBJ File Data!", (Object[])new Object[0]);
            return false;
        }
        return this.parseOBJFileLines(lines);
    }

    private boolean parseOBJFileLines(ArrayList<String> lines) {
        ArrayList<OBJTexCoord> textureCoords = new ArrayList<OBJTexCoord>();
        ArrayList<OBJNormal> normals = new ArrayList<OBJNormal>();
        ArrayList<OBJVertex> vertices = new ArrayList<OBJVertex>();
        ArrayList<OBJFace> faces = new ArrayList<OBJFace>();
        for (String line : lines) {
            String[] sections = line.split(" ");
            if (line.startsWith("vn ")) {
                normals.add(new OBJNormal(Float.parseFloat(sections[1]), Float.parseFloat(sections[2]), Float.parseFloat(sections[3])));
                continue;
            }
            if (line.startsWith("vt ")) {
                textureCoords.add(new OBJTexCoord(Float.parseFloat(sections[1]), Float.parseFloat(sections[2])));
                continue;
            }
            if (line.startsWith("v ")) {
                vertices.add(new OBJVertex(Float.parseFloat(sections[1]), Float.parseFloat(sections[2]), Float.parseFloat(sections[3])));
                continue;
            }
            if (!line.startsWith("f ")) continue;
            ArrayList<Integer> v = new ArrayList<Integer>();
            ArrayList<Integer> t = new ArrayList<Integer>();
            ArrayList<Integer> n = new ArrayList<Integer>();
            for (String s : sections) {
                if (s.equals("f")) continue;
                String[] vtn = s.split("/");
                v.add(Integer.parseInt(vtn[0]));
                if (vtn.length > 1) {
                    if (vtn[1].equals("")) {
                        t.add(0);
                    } else {
                        t.add(Integer.parseInt(vtn[1]));
                    }
                } else {
                    t.add(0);
                    n.add(0);
                }
                if (vtn.length > 2) {
                    n.add(Integer.parseInt(vtn[2]));
                    continue;
                }
                n.add(0);
            }
            int[] iv = this.toArray(v);
            int[] it = this.toArray(t);
            int[] in = this.toArray(n);
            faces.add(new OBJFace(iv, it, in));
        }
        this.textureCoords = new OBJTexCoord[textureCoords.size()];
        this.normals = new OBJNormal[normals.size()];
        this.vertices = new OBJVertex[vertices.size()];
        this.faces = new OBJFace[faces.size()];
        this.textureCoords = textureCoords.toArray(this.textureCoords);
        this.normals = normals.toArray(this.normals);
        this.vertices = vertices.toArray(this.vertices);
        this.faces = faces.toArray(this.faces);
        this.calculateNormals();
        this.PrepareGLCallList();
        return true;
    }

    private void calculateNormals() {
        for (OBJFace face : this.faces) {
            if (face.faceNormal != null) continue;
            OBJNormal faceNormal = this.calculateFaceNormal(face);
            face.setNormal(faceNormal);
        }
        if (!this.flatShading) {
            for (int i = 0; i < this.vertices.length; ++i) {
                this.calculateVertexNormal(i);
            }
        }
    }

    private OBJNormal calculateFaceNormal(OBJFace face) {
        OBJNormal normal = new OBJNormal(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < face.v.length; ++i) {
            OBJVertex v = this.vertices[face.v[i] - 1];
            OBJVertex vn = this.vertices[face.v[(i + 1) % face.v.length] - 1];
            normal.i += (v.y - vn.y) * (v.z - vn.z);
            normal.j += (v.z - vn.z) * (v.x - vn.x);
            normal.k += (v.x - vn.x) * (v.y - vn.y);
        }
        normal.normalize();
        return normal;
    }

    private OBJNormal calculateVertexNormal(int index) {
        int[] adjoiningFaces = new int[this.faces.length];
        int numAdjoiningFaces = 0;
        block0: for (int i = 0; i < this.faces.length; ++i) {
            OBJFace face = this.faces[i];
            for (int j = 0; j < face.v.length; ++j) {
                if (face.v[j] != index) continue;
                adjoiningFaces[numAdjoiningFaces++] = i;
                continue block0;
            }
        }
        OBJNormal normal = new OBJNormal(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < numAdjoiningFaces; ++i) {
            OBJFace face = this.faces[i];
            if (face.faceNormal == null) continue;
            normal.i += face.faceNormal.i;
            normal.j += face.faceNormal.j;
            normal.k += face.faceNormal.k;
        }
        normal.i /= (float)numAdjoiningFaces;
        normal.j /= (float)numAdjoiningFaces;
        normal.k /= (float)numAdjoiningFaces;
        normal.normalize();
        return normal;
    }

    private int[] toArray(ArrayList<Integer> iArr) {
        int[] arr = new int[iArr.size()];
        for (int i = 0; i < iArr.size(); ++i) {
            arr[i] = iArr.get(i);
        }
        return arr;
    }

    public void PrepareGLCallList() {
        this.glCallList = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.glCallList, (int)4864);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glMatrixMode((int)5890);
        GL11.glCullFace((int)1028);
        for (int i = 0; i < this.faces.length; ++i) {
            OBJFace face = this.faces[i];
            this.RenderFace(face);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)3042);
        GL11.glEndList();
    }

    public void RenderOBJModel(Tessellator t) {
        GL11.glCallList((int)this.glCallList);
    }

    private void RenderFace(OBJFace face) {
        int[] v = face.v;
        int[] tc = face.t;
        int[] n = face.n;
        boolean vertexNormals = true;
        GL11.glBegin((int)4);
        if (this.flatShading) {
            if (face.faceNormal != null) {
                OBJNormal normal = face.faceNormal;
                if (Float.isNaN(normal.i) || Float.isNaN(normal.j) || Float.isNaN(normal.k)) {
                    vertexNormals = true;
                } else {
                    GL11.glNormal3f((float)normal.i, (float)normal.j, (float)normal.k);
                    vertexNormals = false;
                }
            }
        } else {
            vertexNormals = true;
        }
        for (int i = 0; i < v.length; ++i) {
            OBJVertex vertex = this.vertices[v[i] - 1];
            OBJNormal normal = null;
            OBJTexCoord texCoord = null;
            if (tc[i] != 0) {
                texCoord = this.textureCoords[tc[i] - 1];
                GL11.glTexCoord2f((float)texCoord.u, (float)texCoord.v);
            }
            if (vertexNormals && n[i] != 0) {
                normal = this.normals[n[i] - 1];
                GL11.glNormal3f((float)normal.i, (float)normal.j, (float)normal.k);
            }
            GL11.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
        }
        GL11.glEnd();
    }
}

