/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy;

import am2.AMCore;
import am2.AMEventHandler;
import am2.AMWorldEventHandler;
import am2.EntityItemWatcher;
import am2.ItemFrameWatcher;
import am2.ObeliskFuelHelper;
import am2.PlayerTracker;
import am2.ShrinkHandler;
import am2.affinity.AffinityHelper;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.armor.ArmorEventHandler;
import am2.armor.infusions.DamageReductionImbuement;
import am2.armor.infusions.Dispelling;
import am2.armor.infusions.FallProtection;
import am2.armor.infusions.FireProtection;
import am2.armor.infusions.Freedom;
import am2.armor.infusions.GenericImbuement;
import am2.armor.infusions.Healing;
import am2.armor.infusions.HungerBoost;
import am2.armor.infusions.ImbuementRegistry;
import am2.armor.infusions.JumpBoost;
import am2.armor.infusions.LifeSaving;
import am2.armor.infusions.Lightstep;
import am2.armor.infusions.MiningSpeed;
import am2.armor.infusions.Recoil;
import am2.armor.infusions.SwimSpeed;
import am2.armor.infusions.WaterBreathing;
import am2.armor.infusions.WaterWalking;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityParticleEmitter;
import am2.buffs.BuffList;
import am2.enchantments.AMEnchantments;
import am2.entities.EntityManager;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.network.AMPacketProcessorServer;
import am2.particles.ParticleManagerServer;
import am2.playerextensions.ExtendedProperties;
import am2.power.PowerNodeCache;
import am2.power.PowerNodeEntry;
import am2.proxy.gui.ServerGuiManager;
import am2.proxy.tick.ServerTickHandler;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellUnlockManager;
import am2.utility.ProxyUtilitiesCommon;
import am2.worldgen.AM2WorldDecorator;
import am2.worldgen.RetroactiveWorldgenerator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy {
    private ArrayList<AMVector3> pendingFlickerLinks;
    public BlocksCommonProxy blocks;
    public ItemsCommonProxy items;
    public PlayerTracker playerTracker;
    public static HashMap<String, String> teamHostility;
    public ParticleManagerServer particleManager;
    public NBTTagCompound cwCopyLoc;
    public AM2WorldDecorator worldGen;
    public AMEnchantments enchantments;
    public ItemFrameWatcher itemFrameWatcher;
    protected ProxyUtilitiesCommon utils;
    public static EntityManager entities;
    public static ServerGuiManager guiManager;
    private ServerTickHandler serverTickHandler;
    private HashMap<EntityLivingBase, ArrayList<PotionEffect>> deferredPotionEffects = new HashMap();
    private HashMap<EntityLivingBase, Integer> deferredDimensionTransfers = new HashMap();
    private int totalFlickerCount = 0;

    public CommonProxy() {
        teamHostility = new HashMap();
        this.playerTracker = new PlayerTracker();
        this.particleManager = new ParticleManagerServer();
        this.itemFrameWatcher = new ItemFrameWatcher();
        this.pendingFlickerLinks = new ArrayList();
        this.cwCopyLoc = null;
    }

    public void postinit() {
        this.blocks.setupSpellConstraints();
        this.items.postInit();
        this.playerTracker.postInit();
        MinecraftForge.EVENT_BUS.register((Object)new AMEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)PowerNodeCache.instance);
        MinecraftForge.EVENT_BUS.register((Object)new AffinityHelper());
        MinecraftForge.EVENT_BUS.register((Object)new SpellUnlockManager());
        MinecraftForge.EVENT_BUS.register((Object)new ArmorEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)EntityManager.instance);
        MinecraftForge.EVENT_BUS.register((Object)new AMWorldEventHandler());
        if (!SkillTreeManager.instance.isSkillDisabled(SkillManager.instance.getSkill("Shrink"))) {
            MinecraftForge.EVENT_BUS.register((Object)new ShrinkHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)this.particleManager);
        FMLCommonHandler.instance().bus().register((Object)this.particleManager);
        FMLCommonHandler.instance().bus().register((Object)this.playerTracker);
    }

    public void preinit() {
        AMCore.config.init();
        AMCore.skillConfig.init();
        this.utils = new ProxyUtilitiesCommon();
        this.blocks = new BlocksCommonProxy();
        this.items = new ItemsCommonProxy();
        entities = EntityManager.instance;
        BuffList.Init();
        BuffList.Instantiate();
        this.blocks.InstantiateBlocks();
        this.items.InstantiateItems();
        ObeliskFuelHelper.instance.registerFuelType(new ItemStack((Item)ItemsCommonProxy.itemOre, 0, 0), 200);
        ObeliskFuelHelper.instance.registerFuelType(new ItemStack((Item)ItemsCommonProxy.itemAMBucket, 0, Short.MAX_VALUE), 2000);
        this.registerInfusions();
    }

    public void init() {
        this.blocks.RegisterBlocks();
        this.blocks.RegisterTileEntities();
        this.blocks.InitRecipes();
        this.items.InitRecipes();
        entities.registerEntities();
        entities.initializeSpawns();
        SkillManager.instance.init();
        SkillTreeManager.instance.init();
        this.worldGen = new AM2WorldDecorator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldGen, (int)0);
        EntityItemWatcher.instance.init();
        this.enchantments = new AMEnchantments();
        this.enchantments.Init();
    }

    public AM2WorldDecorator getWorldGen() {
        return this.worldGen;
    }

    public void InitializeAndRegisterHandlers() {
        guiManager = new ServerGuiManager();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)AMCore.instance, (IGuiHandler)guiManager);
        this.serverTickHandler = new ServerTickHandler();
        FMLCommonHandler.instance().bus().register((Object)this.serverTickHandler);
        AMNetHandler.INSTANCE.registerChannels(new AMPacketProcessorServer());
    }

    public void addQueuedRetrogen(int dimensionID, ChunkCoordIntPair pair) {
        ArrayList<ChunkCoordIntPair> chunks = RetroactiveWorldgenerator.deferredChunkGeneration.containsKey(dimensionID) ? RetroactiveWorldgenerator.deferredChunkGeneration.get(dimensionID) : new ArrayList<ChunkCoordIntPair>();
        chunks.add(pair);
        RetroactiveWorldgenerator.deferredChunkGeneration.put(dimensionID, chunks);
    }

    public void flashManaBar() {
    }

    public void blackoutArmorPiece(EntityPlayerMP player, int slot, int cooldown) {
        this.serverTickHandler.blackoutArmorPiece(player, slot, cooldown);
    }

    public Entity getEntityByID(World world, int ID) {
        EntityLivingBase ent = null;
        for (Object o : world.field_72996_f) {
            if (!(o instanceof EntityLivingBase) || (ent = (EntityLivingBase)o).func_145782_y() != ID) continue;
            return ent;
        }
        return null;
    }

    public WorldServer[] getWorldServers() {
        return FMLServerHandler.instance().getServer().field_71305_c;
    }

    public EntityLivingBase getEntityByID(int entityID) {
        Entity ent = null;
        for (WorldServer ws : this.getWorldServers()) {
            ent = ws.func_73045_a(entityID);
            if (ent == null) continue;
            if (ent instanceof EntityLivingBase) break;
            return null;
        }
        return (EntityLivingBase)ent;
    }

    public EntityPlayer getLocalPlayer() {
        return null;
    }

    public ProxyUtilitiesCommon getProxyUtils() {
        return this.utils;
    }

    public int getArmorRenderIndex(String prefix) {
        return 0;
    }

    public void openSkillTreeUI(World world, EntityPlayer player) {
    }

    public void openParticleBlockGUI(World world, EntityPlayer player, TileEntityParticleEmitter te) {
    }

    public void setMouseDWheel(int dwheel) {
    }

    public void renderGameOverlay() {
    }

    public void addName(Object obj, String s) {
    }

    public void addLocalization(String s1, String string) {
    }

    public String getItemStackDisplayName(ItemStack newStack) {
        return "";
    }

    public String getCurrentLanguage() {
        return null;
    }

    public void sendLocalMovementData(EntityLivingBase ent) {
    }

    public void setCompendiumSaveBase(String compendiumBase) {
    }

    public void addDeferredPotionEffect(EntityLivingBase ent, PotionEffect pe) {
        if (!this.deferredPotionEffects.containsKey(ent)) {
            this.deferredPotionEffects.put(ent, new ArrayList());
        }
        ArrayList<PotionEffect> effects = this.deferredPotionEffects.get(ent);
        effects.add(pe);
    }

    public void addDeferredDimensionTransfer(EntityLivingBase ent, int dimension) {
        this.deferredDimensionTransfers.put(ent, dimension);
    }

    public HashMap<EntityLivingBase, ArrayList<PotionEffect>> getDeferredPotionEffects() {
        return (HashMap)this.deferredPotionEffects.clone();
    }

    public void clearDeferredDimensionTransfers() {
        this.deferredDimensionTransfers.clear();
    }

    public HashMap<EntityLivingBase, Integer> getDeferredDimensionTransfers() {
        return (HashMap)this.deferredDimensionTransfers.clone();
    }

    public void clearDeferredPotionEffects() {
        this.deferredPotionEffects.clear();
    }

    public void requestPowerPathVisuals(IPowerNode node, EntityPlayerMP player) {
    }

    public void receivePowerPathVisuals(HashMap<PowerTypes, ArrayList<LinkedList<AMVector3>>> paths) {
    }

    public HashMap<PowerTypes, ArrayList<LinkedList<AMVector3>>> getPowerPathVisuals() {
        return null;
    }

    public boolean isClientPlayer(EntityLivingBase ent) {
        return false;
    }

    public void setViewSettings() {
        if (ExtendedProperties.For((EntityLivingBase)this.getLocalPlayer()).getFlipRotation() > 0.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        }
    }

    public void registerInfusions() {
        DamageReductionImbuement.registerAll();
        GenericImbuement.registerAll();
        ImbuementRegistry.instance.registerImbuement(new Dispelling());
        ImbuementRegistry.instance.registerImbuement(new FallProtection());
        ImbuementRegistry.instance.registerImbuement(new FireProtection());
        ImbuementRegistry.instance.registerImbuement(new Freedom());
        ImbuementRegistry.instance.registerImbuement(new Healing());
        ImbuementRegistry.instance.registerImbuement(new HungerBoost());
        ImbuementRegistry.instance.registerImbuement(new JumpBoost());
        ImbuementRegistry.instance.registerImbuement(new LifeSaving());
        ImbuementRegistry.instance.registerImbuement(new Lightstep());
        ImbuementRegistry.instance.registerImbuement(new MiningSpeed());
        ImbuementRegistry.instance.registerImbuement(new Recoil());
        ImbuementRegistry.instance.registerImbuement(new SwimSpeed());
        ImbuementRegistry.instance.registerImbuement(new WaterBreathing());
        ImbuementRegistry.instance.registerImbuement(new WaterWalking());
    }

    public void setTrackedPowerCompound(NBTTagCompound compound) {
    }

    public void setTrackedLocation(AMVector3 location) {
    }

    public boolean hasTrackedLocationSynced() {
        return false;
    }

    public PowerNodeEntry getTrackedData() {
        return null;
    }

    public void addDeferredTargetSet(EntityLiving ent, EntityLivingBase target) {
        this.serverTickHandler.addDeferredTarget(ent, target);
    }

    public void unlockCompendiumEntry(String id) {
    }

    public void unlockCompendiumCategory(String id) {
    }

    public void drawPowerOnBlockHighlight(EntityPlayer player, MovingObjectPosition target, float partialTicks) {
    }

    public void incrementFlickerCount() {
        ++this.totalFlickerCount;
    }

    public void decrementFlickerCount() {
        --this.totalFlickerCount;
        if (this.totalFlickerCount < 0) {
            this.totalFlickerCount = 0;
        }
    }

    public int getTotalFlickerCount() {
        return this.totalFlickerCount;
    }
}

