/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.power.PowerNodeCache;
import am2.power.PowerNodeEntry;
import am2.power.PowerNodePathfinder;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PowerNodeRegistry {
    private static final HashMap<Integer, PowerNodeRegistry> dimensionPowerManagers = new HashMap();
    private static final PowerNodeRegistry dummyRegistry = new PowerNodeRegistry();
    static final int POWER_SEARCH_RADIUS = 10;
    static final int POWER_SEARCH_RADIUS_SQ = 100;
    static final int MAX_POWER_SEARCH_RADIUS = 10000;
    private TreeMap<ChunkCoordIntPair, HashMap<AMVector3, PowerNodeEntry>> powerNodes;

    public static final PowerNodeRegistry For(World world) {
        if (world == null) {
            return dummyRegistry;
        }
        if (dimensionPowerManagers.containsKey(world.field_73011_w.field_76574_g)) {
            return dimensionPowerManagers.get(world.field_73011_w.field_76574_g);
        }
        PowerNodeRegistry reg = new PowerNodeRegistry();
        dimensionPowerManagers.put(world.field_73011_w.field_76574_g, reg);
        return reg;
    }

    private PowerNodeRegistry() {
        ChunkCoordComparator comparator = new ChunkCoordComparator();
        this.powerNodes = new TreeMap(comparator);
    }

    public void registerPowerNode(IPowerNode node) {
        this.registerPowerNodeInternal(node);
    }

    PowerNodeEntry registerPowerNodeInternal(IPowerNode node) {
        HashMap<AMVector3, PowerNodeEntry> nodeList;
        ChunkCoordIntPair chunk = this.getChunkFromNode(node);
        TileEntity te = (TileEntity)node;
        World world = te.func_145831_w();
        if (this.powerNodes.containsKey(chunk)) {
            nodeList = this.powerNodes.get(chunk);
            FMLLog.finer((String)"Ars Magica 2 >> Located Power Node list for chunk %d, %d", (Object[])new Object[]{chunk.field_77276_a, chunk.field_77275_b});
        } else {
            FMLLog.finer((String)"Ars Magica 2 >> Node list not found.  Checking cache/files for prior data", (Object[])new Object[0]);
            NBTTagCompound compound = PowerNodeCache.instance.getNBTForChunk(world, chunk);
            nodeList = new HashMap();
            if (compound == null || !compound.func_74764_b("AM2PowerData")) {
                this.powerNodes.put(chunk, nodeList);
                FMLLog.finer((String)"Ars Magica 2 >> Prior node list not found.  Created Power Node list for chunk %d, %d", (Object[])new Object[]{chunk.field_77276_a, chunk.field_77275_b});
            } else {
                this.LoadChunkFromNBT(chunk, compound);
                nodeList = this.powerNodes.get(chunk);
                if (nodeList == null) {
                    nodeList = new HashMap();
                }
                FMLLog.finer((String)"Ars Magica 2 >> Loaded power data for chunk %d, %d", (Object[])new Object[]{chunk.field_77276_a, chunk.field_77275_b});
            }
        }
        AMVector3 nodeLoc = new AMVector3((TileEntity)node);
        if (nodeList.containsKey(nodeLoc)) {
            return nodeList.get(nodeLoc);
        }
        PowerNodeEntry pnd = new PowerNodeEntry();
        nodeList.put(nodeLoc, pnd);
        FMLLog.finer((String)"Ars Magica 2 >> Successfully registered power node at {%d, %d, %d}", (Object[])new Object[]{((TileEntity)node).field_145851_c, ((TileEntity)node).field_145848_d, ((TileEntity)node).field_145849_e});
        return pnd;
    }

    public void removePowerNode(IPowerNode node) {
        ChunkCoordIntPair chunk = this.getChunkFromNode(node);
        this.removePowerNode(chunk, new AMVector3((TileEntity)node));
    }

    public String tryPairNodes(IPowerNode powerSource, IPowerNode destination) {
        if (powerSource == destination) {
            return StatCollector.func_74838_a((String)"am2.tooltip.nodePairToSelf");
        }
        ArrayList<PowerTypes> typesProvided = new ArrayList<PowerTypes>();
        for (PowerTypes type : destination.getValidPowerTypes()) {
            if (!powerSource.canProvidePower(type)) continue;
            typesProvided.add(type);
        }
        if (typesProvided.size() == 0) {
            return StatCollector.func_74838_a((String)"am2.tooltip.noSupportedPowertypes");
        }
        AMVector3 sourceLocation = new AMVector3((TileEntity)powerSource);
        AMVector3 destLocation = new AMVector3((TileEntity)destination);
        double rawDist = sourceLocation.distanceSqTo(destLocation);
        if (rawDist > 10000.0) {
            return StatCollector.func_74838_a((String)"am2.tooltip.nodesTooFar");
        }
        int successes = 0;
        for (PowerTypes type : typesProvided) {
            LinkedList<AMVector3> powerPath = new LinkedList<AMVector3>();
            PowerNodePathfinder pathfinder = new PowerNodePathfinder(((TileEntity)powerSource).func_145831_w(), sourceLocation, destLocation, type);
            List<AMVector3> path = pathfinder.compute(sourceLocation);
            if (path == null) continue;
            for (AMVector3 vec : path) {
                powerPath.addFirst(vec);
            }
            ++successes;
            this.getPowerNodeData(destination).registerNodePath(type, powerPath);
        }
        if (successes == 0) {
            return StatCollector.func_74838_a((String)"am2.tooltip.noPathFound");
        }
        if (successes == typesProvided.size()) {
            return StatCollector.func_74838_a((String)"am2.tooltip.success");
        }
        return StatCollector.func_74838_a((String)"am2.tooltip.partialSuccess");
    }

    public void tryDisconnectAllNodes(IPowerNode node) {
        this.getPowerNodeData(node).clearNodePaths();
    }

    private void removePowerNode(ChunkCoordIntPair chunk, AMVector3 location) {
        if (this.powerNodes.containsKey(chunk)) {
            HashMap<AMVector3, PowerNodeEntry> nodeList = this.powerNodes.get(chunk);
            nodeList.remove(location);
            FMLLog.finer((String)"Ars Magica 2 >> Successfully removed a node from chunk %d, %d", (Object[])new Object[]{chunk.field_77276_a, chunk.field_77275_b});
            if (nodeList.size() == 0) {
                this.powerNodes.remove(chunk);
                FMLLog.finer((String)"Ars Magica 2 >> No more nodes exist in chunk.  Removing tracking data for chunk.", (Object[])new Object[0]);
            }
        } else {
            FMLLog.severe((String)"Ars Magica 2 >> Power Node removal requested in a non-tracked chunk (%d, %d)!", (Object[])new Object[]{chunk.field_77276_a, chunk.field_77275_b});
        }
    }

    public float requestPower(IPowerNode destination, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(destination);
        if (data == null) {
            return 0.0f;
        }
        float requested = data.requestPower(((TileEntity)destination).func_145831_w(), type, amount, destination.getCapacity());
        return requested;
    }

    public float consumePower(IPowerNode consumer, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(consumer);
        if (data == null) {
            return 0.0f;
        }
        float availablePower = data.getPower(type);
        if (availablePower < amount) {
            amount = availablePower;
        }
        data.setPower(type, availablePower - amount);
        return amount;
    }

    public float insertPower(IPowerNode destination, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(destination);
        if (data == null) {
            return 0.0f;
        }
        float curPower = data.getPower(type);
        if (curPower + amount > destination.getCapacity()) {
            amount = destination.getCapacity() - curPower;
        }
        data.setPower(type, curPower + amount);
        return amount;
    }

    public void setPower(IPowerNode destination, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(destination);
        if (data == null) {
            return;
        }
        if (amount > destination.getCapacity()) {
            amount = destination.getCapacity();
        }
        data.setPower(type, amount);
    }

    public boolean checkPower(IPowerNode node, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return false;
        }
        return data.getPower(type) >= amount;
    }

    public boolean checkPower(IPowerNode node, float amount) {
        for (PowerTypes type : PowerTypes.all()) {
            if (!this.checkPower(node, type, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPower(IPowerNode node) {
        return this.getHighestPower(node) > 0.0f;
    }

    public float getPower(IPowerNode node, PowerTypes type) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return 0.0f;
        }
        return data.getPower(type);
    }

    public float getHighestPower(IPowerNode node) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return 0.0f;
        }
        return data.getHighestPower();
    }

    public PowerTypes getHighestPowerType(IPowerNode node) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return PowerTypes.NONE;
        }
        return data.getHighestPowerType();
    }

    PowerNodeEntry getPowerNodeData(IPowerNode node) {
        PowerNodeEntry pnd;
        ChunkCoordIntPair pair = this.getChunkFromNode(node);
        if (pair != null && this.powerNodes.containsKey(pair) && (pnd = this.powerNodes.get(pair).get(new AMVector3((TileEntity)node))) != null) {
            return pnd;
        }
        return this.registerPowerNodeInternal(node);
    }

    public IPowerNode[] getAllNearbyNodes(World world, AMVector3 location, PowerTypes power) {
        ChunkCoordIntPair[] search = this.getSearchChunks(location);
        HashMap<AMVector3, PowerNodeEntry> nodesToSearch = new HashMap<AMVector3, PowerNodeEntry>();
        for (ChunkCoordIntPair pair : search) {
            HashMap<AMVector3, PowerNodeEntry> nodesInChunk = this.powerNodes.get(pair);
            if (nodesInChunk == null) continue;
            for (AMVector3 vector : nodesInChunk.keySet()) {
                if (!(location.distanceSqTo(vector) <= 100.0) || vector.equals(location)) continue;
                nodesToSearch.put(vector, nodesInChunk.get(vector));
            }
        }
        ArrayList<IPowerNode> nodes = new ArrayList<IPowerNode>();
        int deadNodesRemoved = 0;
        for (AMVector3 vector : nodesToSearch.keySet()) {
            if (!world.func_72904_c((int)vector.x, (int)vector.y, (int)vector.z, (int)vector.x, (int)vector.y, (int)vector.z)) continue;
            Chunk chunk = world.func_72938_d((int)vector.x, (int)vector.z);
            if (!chunk.field_76636_d) continue;
            TileEntity te = world.func_147438_o((int)vector.x, (int)vector.y, (int)vector.z);
            if (te == null || !(te instanceof IPowerNode)) {
                this.removePowerNode(chunk.func_76632_l(), vector);
                ++deadNodesRemoved;
                continue;
            }
            IPowerNode node = (IPowerNode)te;
            nodes.add(node);
        }
        if (deadNodesRemoved > 0) {
            FMLLog.finer((String)"Ars Magica 2 >> Removed %d dead power nodes", (Object[])new Object[]{deadNodesRemoved});
        }
        IPowerNode[] nodeArray = nodes.toArray(new IPowerNode[nodes.size()]);
        FMLLog.finer((String)"Ars Magica 2 >> Located %d nearby power providers", (Object[])new Object[]{nodeArray.length});
        return nodeArray;
    }

    private ChunkCoordIntPair[] getSearchChunks(AMVector3 location) {
        int chunkX = (int)location.x >> 4;
        int chunkZ = (int)location.z >> 4;
        ArrayList<ChunkCoordIntPair> searchChunks = new ArrayList<ChunkCoordIntPair>();
        searchChunks.add(new ChunkCoordIntPair(chunkX, chunkZ));
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                ChunkCoordIntPair newPair = new ChunkCoordIntPair(chunkX + i, chunkZ + j);
                if ((int)location.x + 10 * i >> 4 != newPair.field_77276_a || (int)location.z + 10 * j >> 4 != newPair.field_77275_b) continue;
                searchChunks.add(newPair);
            }
        }
        return searchChunks.toArray(new ChunkCoordIntPair[searchChunks.size()]);
    }

    private ChunkCoordIntPair getChunkFromNode(IPowerNode node) {
        TileEntity te = (TileEntity)node;
        if (te.func_145831_w() == null) {
            return null;
        }
        if (!te.func_145831_w().func_72904_c(te.field_145851_c, 0, te.field_145849_e, te.field_145851_c, te.func_145831_w().func_72940_L(), te.field_145849_e)) {
            return new ChunkCoordIntPair(te.field_145851_c >> 4, te.field_145849_e >> 4);
        }
        return te.func_145831_w().func_72938_d(te.field_145851_c, te.field_145849_e).func_76632_l();
    }

    private ChunkCoordIntPair getChunkFromPosition(World world, AMVector3 location) {
        return new ChunkCoordIntPair((int)location.x >> 4, (int)location.z >> 4);
    }

    public void SaveChunkToNBT(ChunkCoordIntPair chunk, NBTTagCompound compound) {
        HashMap<AMVector3, PowerNodeEntry> nodeData = this.powerNodes.get(chunk);
        if (nodeData == null) {
            return;
        }
        NBTTagList powerNodeTagList = new NBTTagList();
        for (AMVector3 location : nodeData.keySet()) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            nodeCompound.func_74768_a("xCoord", (int)location.x);
            nodeCompound.func_74768_a("yCoord", (int)location.y);
            nodeCompound.func_74768_a("zCoord", (int)location.z);
            PowerNodeEntry pnd = nodeData.get(location);
            nodeCompound.func_74782_a("nodeData", (NBTBase)pnd.saveToNBT());
            powerNodeTagList.func_74742_a((NBTBase)nodeCompound);
        }
        FMLLog.finer((String)"Ars Magica 2 >> Saved %d power node entries", (Object[])new Object[]{powerNodeTagList.func_74745_c()});
        compound.func_74782_a("AM2PowerData", (NBTBase)powerNodeTagList);
    }

    public void LoadChunkFromNBT(ChunkCoordIntPair chunk, NBTTagCompound compound) {
        if (!compound.func_74764_b("AM2PowerData")) {
            return;
        }
        NBTTagList powerNodeTagList = compound.func_150295_c("AM2PowerData", 10);
        HashMap<AMVector3, PowerNodeEntry> chunkPowerData = new HashMap<AMVector3, PowerNodeEntry>();
        for (int i = 0; i < powerNodeTagList.func_74745_c(); ++i) {
            NBTTagCompound nodeCompound = powerNodeTagList.func_150305_b(i);
            AMVector3 nodeLocation = new AMVector3(nodeCompound.func_74762_e("xCoord"), nodeCompound.func_74762_e("yCoord"), nodeCompound.func_74762_e("zCoord"));
            PowerNodeEntry pnd = new PowerNodeEntry();
            pnd.readFromNBT(nodeCompound.func_74775_l("nodeData"));
            chunkPowerData.put(nodeLocation, pnd);
        }
        FMLLog.finer((String)"Ars Magica 2 >> Loaded %d power node entries", (Object[])new Object[]{chunkPowerData.size()});
        this.powerNodes.put(chunk, chunkPowerData);
    }

    public void unloadChunk(Chunk chunk) {
        this.powerNodes.remove(chunk.func_76632_l());
    }

    public boolean hasDataForChunk(Chunk chunk) {
        return this.powerNodes.containsKey(chunk.func_76632_l());
    }

    public NBTTagCompound getDataCompoundForNode(IPowerNode node) {
        PowerNodeEntry pnd = this.getPowerNodeData(node);
        if (pnd == null) {
            return null;
        }
        return pnd.saveToNBT();
    }

    public void setDataCompoundForNode(IPowerNode node, NBTTagCompound compound) {
        PowerNodeEntry pnd = this.getPowerNodeData(node);
        if (pnd == null) {
            return;
        }
        pnd.readFromNBT((NBTTagCompound)compound.func_74737_b());
    }

    public PowerNodeEntry parseFromNBT(NBTTagCompound compound) {
        PowerNodeEntry pnd = new PowerNodeEntry();
        pnd.readFromNBT((NBTTagCompound)compound.func_74737_b());
        return pnd;
    }

    public HashMap<ChunkCoordIntPair, NBTTagCompound> saveAll() {
        HashMap<ChunkCoordIntPair, NBTTagCompound> allData = new HashMap<ChunkCoordIntPair, NBTTagCompound>();
        for (ChunkCoordIntPair pair : this.powerNodes.keySet()) {
            NBTTagCompound chunkCompound = new NBTTagCompound();
            this.SaveChunkToNBT(pair, chunkCompound);
            allData.put(pair, chunkCompound);
        }
        return allData;
    }

    public void unloadAll() {
        this.powerNodes.clear();
    }

    private class IPowerNodeComparer
    implements Comparator<IPowerNode> {
        private IPowerNodeComparer() {
        }

        @Override
        public int compare(IPowerNode o1, IPowerNode o2) {
            TileEntity te1 = (TileEntity)o1;
            TileEntity te2 = (TileEntity)o2;
            if (te1.field_145851_c == te2.field_145851_c && te1.field_145849_e == te2.field_145849_e && te1.field_145848_d == te2.field_145848_d) {
                return 0;
            }
            if (te1.field_145851_c > te2.field_145851_c) {
                return 1;
            }
            if (te1.field_145849_e > te2.field_145849_e) {
                return 1;
            }
            if (te1.field_145848_d > te2.field_145848_d) {
                return 1;
            }
            return -1;
        }
    }

    private class ChunkCoordComparator
    implements Comparator<ChunkCoordIntPair> {
        private ChunkCoordComparator() {
        }

        @Override
        public int compare(ChunkCoordIntPair a, ChunkCoordIntPair b) {
            if (a.field_77276_a == b.field_77276_a && a.field_77275_b == b.field_77275_b) {
                return 0;
            }
            if (a.field_77276_a > b.field_77276_a) {
                return 1;
            }
            if (a.field_77275_b > b.field_77275_b) {
                return 1;
            }
            return -1;
        }
    }
}

