/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;

public class ParticlePendulum
extends ParticleController {
    private double angle = 0.0;
    private float amplitude = 0.0f;
    private float speed = 0.1f;
    private double lastDeltaX;
    private double lastDeltaZ;
    private double lastDeltaY;
    private boolean stopOnCollide = true;

    public ParticlePendulum(AMParticle particleEffect, float amplitude, float speed, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.amplitude = amplitude;
        this.lastDeltaX = 0.0;
        this.lastDeltaZ = 0.0;
        this.generateNewAngle();
        this.speed = speed;
    }

    public ParticlePendulum setStopOnCollide(boolean stop) {
        this.stopOnCollide = stop;
        return this;
    }

    private void generateNewAngle() {
        this.angle = Math.toRadians(this.rand.nextInt(360));
    }

    @Override
    public void doUpdate() {
        if (this.stopOnCollide && (this.particle.field_70124_G || this.particle.field_70123_F)) {
            this.finish();
            return;
        }
        double deltaX = Math.sin(this.angle) * (double)this.amplitude * Math.sin((float)this.particle.field_70173_aa * this.speed);
        double deltaZ = Math.cos(this.angle) * (double)this.amplitude * Math.sin((float)this.particle.field_70173_aa * this.speed);
        double posX = deltaX - this.lastDeltaX;
        double posY = Math.sin((float)System.currentTimeMillis() / Float.MAX_VALUE);
        double posZ = deltaZ - this.lastDeltaZ;
        this.lastDeltaX = deltaX;
        this.lastDeltaZ = deltaZ;
        this.particle.func_70091_d(posX, posY, posZ);
    }

    @Override
    public ParticleController clone() {
        return new ParticlePendulum(this.particle, this.amplitude, this.speed, this.priority, this.exclusive).setStopOnCollide(this.stopOnCollide);
    }
}

