/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;

public final class ParticleColorShift
extends ParticleController {
    private float minRed = 0.0f;
    private float maxRed = 1.0f;
    private float minGreen = 0.0f;
    private float maxGreen = 1.0f;
    private float minBlue = 0.0f;
    private float maxBlue = 1.0f;
    private float targetRed;
    private float targetGreen;
    private float targetBlue;
    private boolean endOnReachingColor = false;
    private float shiftSpeed = 0.01f;
    private float redShift;
    private float greenShift;
    private float blueShift;

    public ParticleColorShift(AMParticle particleEffect, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.GenerateNextColorTarget();
    }

    public ParticleColorShift SetColorTarget(float red, float green, float blue) {
        this.targetRed = red;
        this.targetGreen = green;
        this.targetBlue = blue;
        this.redShift = Math.abs(this.particle.GetParticleRed() - this.targetRed) * this.shiftSpeed;
        this.greenShift = Math.abs(this.particle.GetParticleGreen() - this.targetGreen) * this.shiftSpeed;
        this.blueShift = Math.abs(this.particle.GetParticleBlue() - this.targetBlue) * this.shiftSpeed;
        return this;
    }

    public ParticleColorShift SetShiftSpeed(float speed) {
        this.redShift = this.shiftSpeed = speed;
        this.greenShift = this.shiftSpeed;
        this.blueShift = this.shiftSpeed;
        return this;
    }

    public ParticleColorShift SetColorRange(float minRed, float minBlue, float minGreen, float maxRed, float maxGreen, float maxBlue) {
        this.minRed = minRed;
        this.maxRed = maxRed;
        this.minGreen = minGreen;
        this.maxGreen = maxGreen;
        this.minBlue = minBlue;
        this.maxBlue = maxBlue;
        return this;
    }

    public ParticleColorShift SetEndOnReachingTargetColor() {
        this.endOnReachingColor = true;
        return this;
    }

    private void GenerateNextColorTarget() {
        this.targetRed = this.rand.nextFloat() * (this.maxRed - this.minRed) + this.minRed;
        this.targetGreen = this.rand.nextFloat() * (this.maxGreen - this.minGreen) + this.minGreen;
        this.targetBlue = this.rand.nextFloat() * (this.maxBlue - this.minBlue) + this.minBlue;
    }

    @Override
    public void doUpdate() {
        float currentRed = this.particle.GetParticleRed();
        float currentGreen = this.particle.GetParticleGreen();
        float currentBlue = this.particle.GetParticleBlue();
        if (currentRed == this.targetRed && currentGreen == this.targetGreen && currentBlue == this.targetBlue) {
            if (this.endOnReachingColor) {
                this.finish();
                return;
            }
            this.GenerateNextColorTarget();
        }
        this.particle.setRGBColorF(this.ShiftValue(currentRed, this.targetRed, this.redShift), this.ShiftValue(currentGreen, this.targetGreen, this.greenShift), this.ShiftValue(currentBlue, this.targetBlue, this.blueShift));
    }

    private float ShiftValue(float current, float target, float step) {
        float curDist = Math.abs(target - current);
        if (curDist < step) {
            step = curDist;
        }
        if (current < target) {
            current += step;
        } else if (current > target) {
            current -= step;
        }
        return current;
    }

    @Override
    public ParticleController clone() {
        ParticleColorShift clone = new ParticleColorShift(this.particle, this.priority, this.endOnReachingColor).SetShiftSpeed(this.shiftSpeed).SetColorRange(this.minRed, this.minBlue, this.minGreen, this.maxRed, this.maxGreen, this.maxBlue).SetColorTarget(this.targetRed, this.targetGreen, this.targetBlue);
        if (this.endOnReachingColor) {
            clone.SetEndOnReachingTargetColor();
        }
        return clone;
    }
}

