/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.AMCore;
import am2.armor.ArmorHelper;
import am2.blocks.BlocksCommonProxy;
import am2.items.ArsMagicaItem;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCandle
extends ArsMagicaItem {
    private static final int radius = 10;
    private static final int short_radius = 5;
    private static final float immediate_radius = 2.5f;

    public ItemCandle() {
        this.func_77625_d(1);
        this.func_77656_e(18000);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block;
        if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b("search_block")) {
            block = world.func_147439_a(x, y, z);
            if (player.func_70093_af() && block != null && block.func_149712_f(world, x, y, z) > 0.0f && world.func_147438_o(x, y, z) == null) {
                if (!world.field_72995_K) {
                    this.setSearchBlock(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), stack);
                    world.func_147468_f(x, y, z);
                } else {
                    AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "radiant", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                    if (particle != null) {
                        particle.AddParticleController(new ParticleHoldPosition(particle, 20, 1, false));
                        particle.setRGBColorF(0.0f, 0.5f, 1.0f);
                    }
                }
                return true;
            }
        }
        if (!world.field_72995_K) {
            if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("search_block")) {
                player.func_145747_a((IChatComponent)new ChatComponentText("am2.tooltip.candlecantplace"));
                return false;
            }
            switch (side) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
            block = world.func_147439_a(x, y, z);
            if (block == null || block.isReplaceable((IBlockAccess)world, x, y, z)) {
                int newMeta = (int)Math.ceil(stack.func_77960_j() / 1200);
                world.func_147465_d(x, y, z, (Block)BlocksCommonProxy.candle, newMeta, 2);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            return true;
        }
        return false;
    }

    public void setSearchBlock(Block block, int meta, ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        this.setFlameColor(item, 0.0f, 1.0f, 0.0f);
        item.field_77990_d.func_74768_a("search_block", Block.func_149682_b((Block)block));
        item.field_77990_d.func_74768_a("search_meta", meta);
    }

    private void setFlameColor(ItemStack stack, float r, float g, float b) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74776_a("flame_red", r);
        stack.field_77990_d.func_74776_a("flame_green", g);
        stack.field_77990_d.func_74776_a("flame_blue", b);
    }

    public void search(EntityPlayer player, ItemStack stack, World world, int cx, int cy, int cz, Block block, int meta) {
        boolean found = false;
        for (int i = -10; i <= 10; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -10; k <= 10; ++k) {
                    Block f_block = world.func_147439_a(cx + i, cy + j, cz + k);
                    int f_meta = world.func_72805_g(cx + i, cy + j, cz + k);
                    if (block != f_block || meta != Short.MAX_VALUE && meta != f_meta) continue;
                    if ((float)Math.abs(i) <= 2.5f && (float)Math.abs(k) <= 2.5f && player.func_82169_q(3) != null && ArmorHelper.isInfusionPreset(player.func_82169_q(3), "pp_ore")) {
                        this.setFlameColor(stack, 0.0f, 0.0f, 0.0f);
                        continue;
                    }
                    if (Math.abs(i) <= 5 && Math.abs(k) <= 5) {
                        this.setFlameColor(stack, 1.0f, 0.0f, 0.0f);
                        return;
                    }
                    this.setFlameColor(stack, 0.0f, 0.5f, 1.0f);
                    found = true;
                }
            }
        }
        if (!found) {
            this.setFlameColor(stack, 0.0f, 1.0f, 0.0f);
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int indexInInventory, boolean isCurrentlyHeld) {
        if (isCurrentlyHeld && entity instanceof EntityPlayer) {
            if (!world.field_72995_K && stack.func_77942_o() && stack.func_77960_j() % 40 == 0) {
                this.search((EntityPlayer)entity, stack, world, (int)Math.round(entity.field_70165_t), (int)Math.round(entity.field_70163_u), (int)Math.round(entity.field_70161_v), Block.func_149729_e((int)stack.field_77990_d.func_74762_e("search_block")), stack.field_77990_d.func_74762_e("search_meta"));
            }
            stack.func_77972_a(1, (EntityLivingBase)((EntityPlayer)entity));
            if (!world.field_72995_K && stack.func_77960_j() >= this.func_77612_l()) {
                ((EntityPlayer)entity).field_71071_by.func_70299_a(indexInInventory, null);
            }
            if (!world.field_72995_K && AMCore.config.candlesAreRovingLights() && world.func_147437_c((int)Math.round(entity.field_70165_t), (int)Math.round(entity.field_70163_u), (int)Math.round(entity.field_70161_v)) && world.func_72957_l((int)Math.round(entity.field_70165_t), (int)Math.round(entity.field_70163_u), (int)Math.round(entity.field_70161_v)) < 14) {
                world.func_147465_d((int)Math.round(entity.field_70165_t), (int)Math.round(entity.field_70163_u), (int)Math.round(entity.field_70161_v), (Block)BlocksCommonProxy.invisibleUtility, 2, 2);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name = StatCollector.func_74838_a((String)"item.arsmagica2:warding_candle.name");
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("search_block")) {
            ItemStack blockStack = new ItemStack(Block.func_149729_e((int)stack.field_77990_d.func_74762_e("search_block")), 1, stack.field_77990_d.func_74762_e("search_meta"));
            name = name + " (" + blockStack.func_82833_r() + ")";
        } else {
            name = name + " (" + StatCollector.func_74838_a((String)"am2.tooltip.unattuned") + ")";
        }
        return name;
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack unattuned = new ItemStack((Item)this, 1, 0);
        par3List.add(unattuned);
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
    }
}

