/*
 * Decompiled with CFR 0.152.
 */
package am2.guis.controls;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSlideControl
extends GuiButton {
    public float sliderValue = 1.0f;
    public boolean dragging = false;
    private String displayStringBase;
    private float sliderMin;
    private float sliderMax;
    private boolean isPercent;
    private boolean isInteger;
    private boolean noDynamicDisplay;
    private boolean isVertical;
    private boolean buttonOnly;
    private float scale = 0.5f;
    private ResourceLocation buttonImage = new ResourceLocation("textures/gui/widgets.png");
    private int buttonUL = 0;
    private int buttonVL = 66;
    private int buttonUR = 196;
    private int buttonVR = 66;
    private int buttonW = 4;
    private int buttonH = 20;

    public GuiSlideControl(int par1, int par2, int par3, int width, String par5Str, float initialValue, float sliderMin, float sliderMax) {
        super(par1, par2, par3, width, 10, par5Str);
        this.sliderValue = (initialValue - sliderMin) / (sliderMax - sliderMin);
        this.displayStringBase = par5Str;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.isPercent = false;
        this.isInteger = false;
        this.field_73735_i = 5000.0f;
        this.formatDisplayString();
    }

    public GuiSlideControl(int par1, int par2, int par3, int width, int height, String par5Str, float initialValue, float sliderMin, float sliderMax) {
        super(par1, par2, par3, width, height, par5Str);
        this.sliderValue = (initialValue - sliderMin) / (sliderMax - sliderMin);
        this.displayStringBase = par5Str;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.isPercent = false;
        this.isInteger = false;
        this.formatDisplayString();
    }

    public void setMaximum(float maximum) {
        this.sliderMax = maximum;
        if (this.sliderValue > this.sliderMax) {
            this.sliderValue = this.sliderMax;
        }
    }

    public void setVertical() {
        this.isVertical = true;
        int tmp = this.field_146120_f;
        this.field_146120_f = this.field_146121_g;
        this.field_146121_g = tmp;
    }

    public void setButtonOnly() {
        this.buttonOnly = true;
    }

    public void setButtonProperties(int UL, int VL, int UR, int VR, int W, int H) {
        this.buttonUL = UL;
        this.buttonVL = VL;
        this.buttonUR = UR;
        this.buttonVR = VR;
        this.buttonW = W;
        this.buttonH = H;
    }

    public void setOverrideTexture(ResourceLocation rLoc) {
        this.buttonImage = rLoc;
    }

    public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            FontRenderer fontrenderer = par1Minecraft.field_71466_p;
            par1Minecraft.field_71446_o.func_110577_a(this.buttonImage);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.dragging = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.dragging);
            if (!this.buttonOnly) {
                if (this.isVertical) {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46, this.field_146120_f / 2, this.field_146121_g);
                    this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46, this.field_146120_f / 2, this.field_146121_g);
                } else {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                    this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46, this.field_146120_f / 2, this.field_146121_g);
                }
            }
            this.func_146119_b(par1Minecraft, par2, par3);
            int l = 0xE0E0E0;
            if (!this.field_146124_l) {
                l = -6250336;
            } else if (this.dragging) {
                l = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 6) / 2, l);
        }
    }

    public GuiSlideControl setPercent(boolean percent) {
        this.isPercent = percent;
        this.formatDisplayString();
        return this;
    }

    public GuiSlideControl setNoDynamicDisplay(boolean dynamic) {
        this.noDynamicDisplay = dynamic;
        this.formatDisplayString();
        return this;
    }

    public GuiSlideControl setInteger(boolean integer) {
        this.isInteger = integer;
        this.formatDisplayString();
        return this;
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = this.isVertical ? (float)(par3 - this.field_146129_i) / (float)this.field_146121_g : (float)(par2 - (this.field_146128_h + this.buttonW)) / (float)(this.field_146120_f - 2 * this.buttonW);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                }
                if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
                this.formatDisplayString();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0f, (float)this.scale, (float)0.0f);
            int yPos = (int)((float)this.field_146129_i / this.scale);
            int xPos = (int)((float)this.field_146128_h / this.scale);
            if (this.isVertical) {
                this.func_73729_b(xPos, this.field_146129_i + (int)(this.sliderValue / this.scale * (float)(this.field_146121_g - this.buttonH)), this.buttonUL, this.buttonVL, this.buttonW, this.buttonH);
                this.func_73729_b(xPos + this.buttonW, this.field_146129_i + (int)(this.sliderValue / this.scale * (float)(this.field_146121_g - this.buttonH)), this.buttonUR, this.buttonVR, this.buttonW, this.buttonH);
            } else {
                this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - this.buttonW * 2)), yPos, this.buttonUL, this.buttonVL, this.buttonW, this.buttonH);
                this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - this.buttonW * 2)) + this.buttonW, yPos, this.buttonUR, this.buttonVR, this.buttonW, this.buttonH);
            }
            GL11.glPopMatrix();
        }
    }

    public float getShiftedValue() {
        return (this.sliderMax - this.sliderMin) * this.sliderValue + this.sliderMin;
    }

    private void formatDisplayString() {
        if (this.noDynamicDisplay) {
            this.field_146126_j = this.displayStringBase;
            return;
        }
        float value = (this.sliderMax - this.sliderMin) * this.sliderValue + this.sliderMin;
        this.field_146126_j = !this.isInteger ? this.displayStringBase + ": " + String.format("%.2f", Float.valueOf(value)) + (this.isPercent ? "%" : "") : this.displayStringBase + ": " + String.format("%d", (int)value) + (this.isPercent ? "%" : "");
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        if (super.func_146116_c(par1Minecraft, par2, par3)) {
            this.sliderValue = this.isVertical ? (float)(par3 - (this.field_146129_i + 4)) / (float)(this.field_146121_g - 8) : (float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.formatDisplayString();
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int par1, int par2) {
        this.dragging = false;
    }

    public void setScale(float f) {
        this.scale = f;
    }
}

